/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;

public class GroovyScriptRunConfigurationType
implements ConfigurationType {
    private final GroovyFactory myConfigurationFactory = new GroovyFactory(this);

    public String getDisplayName() {
        return "Groovy";
    }

    public String getConfigurationTypeDescription() {
        return "Groovy Class or Script";
    }

    public Icon getIcon() {
        return JetgroovyIcons.Groovy.Groovy_16x16;
    }

    @NonNls
    @NotNull
    public String getId() {
        if ("GroovyScriptRunConfiguration" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfigurationType", "getId"));
        }
        return "GroovyScriptRunConfiguration";
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myConfigurationFactory};
    }

    public static GroovyScriptRunConfigurationType getInstance() {
        return (GroovyScriptRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(GroovyScriptRunConfigurationType.class);
    }

    private static class GroovyFactory
    extends ConfigurationFactory {
        public GroovyFactory(ConfigurationType type) {
            super(type);
        }

        public boolean isApplicable(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfigurationType$GroovyFactory", "isApplicable"));
            }
            return FileTypeIndex.containsFileOfType((FileType)GroovyFileType.GROOVY_FILE_TYPE, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        }

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfigurationType$GroovyFactory", "createTemplateConfiguration"));
            }
            GroovyScriptRunConfiguration groovyScriptRunConfiguration = new GroovyScriptRunConfiguration("Groovy Script", project, this);
            if (groovyScriptRunConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfigurationType$GroovyFactory", "createTemplateConfiguration"));
            }
            return groovyScriptRunConfiguration;
        }
    }
}

