/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class BindableTransformationSupport
implements AstTransformationSupport {
    private static final String BINDABLE_FQN = "groovy.beans.Bindable";
    private static final String PCL_FQN = "java.beans.PropertyChangeListener";
    private static final String PCS_FQN = "java.beans.PropertyChangeSupport";
    public static final String ORIGIN_INFO = "via @Bindable";

    private static boolean isApplicable(@NotNull GrTypeDefinition clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/plugins/groovy/transformations/impl/BindableTransformationSupport", "isApplicable"));
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)clazz, (boolean)true, (String[])new String[]{BINDABLE_FQN});
        if (annotation != null) {
            return true;
        }
        for (GrField method : clazz.getCodeFields()) {
            if (AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (boolean)true, (String[])new String[]{BINDABLE_FQN}) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/transformations/impl/BindableTransformationSupport", "applyTransformation"));
        }
        GrTypeDefinition clazz = context.getCodeClass();
        if (!BindableTransformationSupport.isApplicable(clazz)) {
            return;
        }
        PsiManager manager = clazz.getManager();
        GlobalSearchScope scope = clazz.getResolveScope();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)clazz.getProject());
        PsiClassType pclType = facade.getElementFactory().createTypeByFQClassName(PCL_FQN, scope);
        PsiArrayType pclArrayType = new PsiArrayType((PsiType)pclType);
        PsiClassType stringType = PsiType.getJavaLangString((PsiManager)manager, (GlobalSearchScope)scope);
        PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)scope);
        ArrayList methods = ContainerUtil.newArrayList();
        methods.add(new LightMethodBuilder(manager, (Language)GroovyLanguage.INSTANCE, "addPropertyChangeListener").setMethodReturnType((PsiType)PsiType.VOID).addParameter("listener", (PsiType)pclType));
        methods.add(new LightMethodBuilder(manager, (Language)GroovyLanguage.INSTANCE, "addPropertyChangeListener").setMethodReturnType((PsiType)PsiType.VOID).addParameter("name", (PsiType)stringType).addParameter("listener", (PsiType)pclType));
        methods.add(new LightMethodBuilder(manager, (Language)GroovyLanguage.INSTANCE, "removePropertyChangeListener").setMethodReturnType((PsiType)PsiType.VOID).addParameter("listener", (PsiType)pclType));
        methods.add(new LightMethodBuilder(manager, (Language)GroovyLanguage.INSTANCE, "removePropertyChangeListener").setMethodReturnType((PsiType)PsiType.VOID).addParameter("name", (PsiType)stringType).addParameter("listener", (PsiType)pclType));
        methods.add(new LightMethodBuilder(manager, (Language)GroovyLanguage.INSTANCE, "firePropertyChange").setMethodReturnType((PsiType)PsiType.VOID).addParameter("name", (PsiType)stringType).addParameter("oldValue", (PsiType)objectType).addParameter("newValue", (PsiType)objectType));
        methods.add(new LightMethodBuilder(manager, (Language)GroovyLanguage.INSTANCE, "getPropertyChangeListeners").setMethodReturnType((PsiType)pclArrayType));
        methods.add(new LightMethodBuilder(manager, (Language)GroovyLanguage.INSTANCE, "getPropertyChangeListeners").setMethodReturnType((PsiType)pclArrayType).addParameter("name", (PsiType)stringType));
        PsiClass docDelegate = facade.findClass(PCS_FQN, context.getCodeClass().getResolveScope());
        for (LightMethodBuilder method : methods) {
            method.addModifier("public");
            method.setOriginInfo(ORIGIN_INFO);
            if (docDelegate == null) continue;
            method.putUserData(ResolveUtil.DOCUMENTATION_DELEGATE, (Object)docDelegate.findMethodBySignature((PsiMethod)method, false));
        }
        context.addMethods(methods);
    }
}

