/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.unwrap.GroovyElseUnwrapperBase;
import org.jetbrains.plugins.groovy.unwrap.GroovyUnwrapper;

public class GroovyElseUnwrapper
extends GroovyElseUnwrapperBase {
    public GroovyElseUnwrapper() {
        super(CodeInsightBundle.message((String)"unwrap.else", (Object[])new Object[0]));
    }

    public PsiElement collectAffectedElements(PsiElement e, List<PsiElement> toExtract) {
        super.collectAffectedElements(e, toExtract);
        return GroovyElseUnwrapper.findTopmostIfStatement(e);
    }

    @Override
    protected void unwrapElseBranch(GrStatement branch, PsiElement parent, GroovyUnwrapper.Context context) throws IncorrectOperationException {
        if (branch instanceof GrIfStatement) {
            branch = ((GrIfStatement)branch).getThenBranch();
        }
        parent = GroovyElseUnwrapper.findTopmostIfStatement(parent);
        context.extractFromBlockOrSingleStatement(branch, parent);
        context.delete(parent);
    }

    private static PsiElement findTopmostIfStatement(PsiElement parent) {
        while (parent.getParent() instanceof GrIfStatement) {
            parent = parent.getParent();
        }
        return parent;
    }
}

