/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class NotNullCachedComputableWrapper<T>
implements NotNullComputable<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)NotNullCachedComputableWrapper.class.getName());
    private volatile NotNullComputable<T> myComputable;
    private final AtomicReference<T> myValueRef;

    public NotNullCachedComputableWrapper(@NotNull NotNullComputable<T> computable) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/plugins/groovy/util/NotNullCachedComputableWrapper", "<init>"));
        }
        this.myValueRef = new AtomicReference();
        this.myComputable = computable;
    }

    @NotNull
    public T compute() {
        Object value;
        block5: {
            while (true) {
                if ((value = this.myValueRef.get()) != null) {
                    T t = value;
                    if (t == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/NotNullCachedComputableWrapper", "compute"));
                    }
                    return t;
                }
                NotNullComputable<T> computable = this.myComputable;
                if (computable == null) continue;
                RecursionGuard.StackStamp stamp = ourGuard.markStack();
                value = computable.compute();
                if (!stamp.mayCacheNow()) break block5;
                if (this.myValueRef.compareAndSet(null, value)) break;
            }
            this.myComputable = null;
            Object object = value;
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/NotNullCachedComputableWrapper", "compute"));
            }
            return object;
        }
        Object object = value;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/NotNullCachedComputableWrapper", "compute"));
        }
        return object;
    }

    public boolean isComputed() {
        return this.myValueRef.get() != null;
    }
}

