/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.filesystem.services;

import net.rubygrapefruit.platform.PosixFiles;
import org.gradle.api.JavaVersion;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.nativeintegration.filesystem.FileCanonicalizer;
import org.gradle.internal.nativeintegration.filesystem.FileModeAccessor;
import org.gradle.internal.nativeintegration.filesystem.FileModeMutator;
import org.gradle.internal.nativeintegration.filesystem.Symlink;
import org.gradle.internal.nativeintegration.filesystem.services.EmptyChmod;
import org.gradle.internal.nativeintegration.filesystem.services.FallbackFileCanonicalizer;
import org.gradle.internal.nativeintegration.filesystem.services.FallbackStat;
import org.gradle.internal.nativeintegration.filesystem.services.GenericFileSystem;
import org.gradle.internal.nativeintegration.filesystem.services.NativePlatformBackedChmod;
import org.gradle.internal.nativeintegration.filesystem.services.NativePlatformBackedStat;
import org.gradle.internal.nativeintegration.filesystem.services.NativePlatformBackedSymlink;
import org.gradle.internal.nativeintegration.filesystem.services.UnavailablePosixFiles;
import org.gradle.internal.nativeintegration.filesystem.services.UnsupportedFilePermissions;
import org.gradle.internal.nativeintegration.filesystem.services.UnsupportedSymlink;
import org.gradle.internal.nativeintegration.filesystem.services.WindowsSymlink;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;
import org.gradle.internal.os.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemServices {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemServices.class);

    public FileCanonicalizer createFileCanonicalizer() {
        return (FileCanonicalizer)this.newInstance("org.gradle.internal.nativeintegration.filesystem.jdk7.Jdk7FileCanonicalizer", FallbackFileCanonicalizer.class);
    }

    public FileSystem createFileSystem(OperatingSystem operatingSystem, PosixFiles posixFiles) throws Exception {
        if (operatingSystem.isWindows()) {
            Symlink symlink = (Symlink)this.newInstance("org.gradle.internal.nativeintegration.filesystem.jdk7.WindowsJdk7Symlink", WindowsSymlink.class);
            return new GenericFileSystem(new EmptyChmod(), new FallbackStat(), symlink);
        }
        if (!(posixFiles instanceof UnavailablePosixFiles)) {
            NativePlatformBackedSymlink symlink = new NativePlatformBackedSymlink(posixFiles);
            NativePlatformBackedChmod chmod = new NativePlatformBackedChmod(posixFiles);
            NativePlatformBackedStat stat = new NativePlatformBackedStat(posixFiles);
            return new GenericFileSystem(chmod, stat, symlink);
        }
        LOGGER.debug("Native-platform file system integration is not available. Continuing with fallback.");
        Symlink symlink = (Symlink)this.newInstance("org.gradle.internal.nativeintegration.filesystem.jdk7.Jdk7Symlink", UnsupportedSymlink.class);
        LOGGER.debug("Using {} implementation as symlink.", (Object)symlink.getClass().getSimpleName());
        Object handler = this.newInstance("org.gradle.internal.nativeintegration.filesystem.jdk7.PosixJdk7FilePermissionHandler", UnsupportedFilePermissions.class);
        return new GenericFileSystem((FileModeMutator)handler, (FileModeAccessor)handler, symlink);
    }

    private Object newInstance(String jdk7Type, Class<?> fallbackType) {
        Class<?> handlerClass = null;
        if (JavaVersion.current().isJava7Compatible()) {
            try {
                handlerClass = FileSystemServices.class.getClassLoader().loadClass(jdk7Type);
                LOGGER.debug("Using JDK 7 file service {}", (Object)jdk7Type);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (handlerClass == null) {
            LOGGER.debug("Unable to load {}. Continuing with fallback {}.", (Object)jdk7Type, (Object)fallbackType.getName());
            handlerClass = fallbackType;
        }
        try {
            return handlerClass.newInstance();
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

