/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.vfs;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.tabs.TabInfo;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jediterm.terminal.ui.settings.TabbedSettingsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionFileType;

public class TerminalSessionVirtualFileImpl
extends LightVirtualFile {
    private final JediTermWidget myTerminal;
    private TabbedSettingsProvider mySettingsProvider;
    private final TabInfo myTabInfo;

    public TerminalSessionVirtualFileImpl(@NotNull TabInfo tabInfo, @NotNull JediTermWidget terminal, @NotNull TabbedSettingsProvider settingsProvider) {
        if (tabInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabInfo", "org/jetbrains/plugins/terminal/vfs/TerminalSessionVirtualFileImpl", "<init>"));
        }
        if (terminal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terminal", "org/jetbrains/plugins/terminal/vfs/TerminalSessionVirtualFileImpl", "<init>"));
        }
        if (settingsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsProvider", "org/jetbrains/plugins/terminal/vfs/TerminalSessionVirtualFileImpl", "<init>"));
        }
        this.myTabInfo = tabInfo;
        this.myTerminal = terminal;
        this.mySettingsProvider = settingsProvider;
        this.setFileType((FileType)TerminalSessionFileType.INSTANCE);
        this.setWritable(true);
    }

    public JediTermWidget getTerminal() {
        return this.myTerminal;
    }

    @NotNull
    public String getName() {
        String string = this.myTabInfo.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/vfs/TerminalSessionVirtualFileImpl", "getName"));
        }
        return string;
    }

    public TabbedSettingsProvider getSettingsProvider() {
        return this.mySettingsProvider;
    }
}

