/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.FileContentUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.InjectionsSettingsUI;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.jetbrains.annotations.NotNull;

public class EditInjectionSettingsAction
implements IntentionAction,
LowPriorityAction {
    public static final String EDIT_INJECTION_TITLE = "Language Injection Settings";

    @NotNull
    public String getText() {
        if (EDIT_INJECTION_TITLE == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/EditInjectionSettingsAction", "getText"));
        }
        return EDIT_INJECTION_TITLE;
    }

    @NotNull
    public String getFamilyName() {
        if ("Edit Injection Settings" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/EditInjectionSettingsAction", "getFamilyName"));
        }
        return "Edit Injection Settings";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/intelliLang/inject/EditInjectionSettingsAction", "isAvailable"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiFile psiFile = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)file, (int)offset);
        if (psiFile == null) {
            return false;
        }
        LanguageInjectionSupport support = (LanguageInjectionSupport)psiFile.getUserData(LanguageInjectionSupport.SETTINGS_EDITOR);
        return support != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/intelliLang/inject/EditInjectionSettingsAction", "invoke"));
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/intelliLang/inject/EditInjectionSettingsAction", "lambda$invoke$0"));
            }
            EditInjectionSettingsAction.invokeImpl(project, editor, file);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeImpl(Project project, Editor editor, PsiFile file) {
        PsiFile psiFile = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)file, (int)editor.getCaretModel().getOffset());
        if (psiFile == null) {
            return;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)project).getInjectionHost((PsiElement)psiFile);
        if (host == null) {
            return;
        }
        LanguageInjectionSupport support = (LanguageInjectionSupport)psiFile.getUserData(LanguageInjectionSupport.SETTINGS_EDITOR);
        if (support == null) {
            return;
        }
        try {
            if (!support.editInjectionInPlace(host)) {
                ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new InjectionsSettingsUI(project, Configuration.getProjectInstance(project)));
            }
        }
        finally {
            FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

