/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.FileContentUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.intellij.plugins.intelliLang.references.InjectedReferencesContributor;
import org.jetbrains.annotations.NotNull;

public class UnInjectLanguageAction
implements IntentionAction,
LowPriorityAction {
    @NotNull
    public String getText() {
        if ("Un-inject Language/Reference" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/UnInjectLanguageAction", "getText"));
        }
        return "Un-inject Language/Reference";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/UnInjectLanguageAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/intelliLang/inject/UnInjectLanguageAction", "isAvailable"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiFile element = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)file, (int)offset);
        if (element == null) {
            return InjectedReferencesContributor.isInjected(file.findReferenceAt(offset));
        }
        return element.getUserData(LanguageInjectionSupport.INJECTOR_SUPPORT) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/intelliLang/inject/UnInjectLanguageAction", "invoke"));
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/intelliLang/inject/UnInjectLanguageAction", "lambda$invoke$0"));
            }
            UnInjectLanguageAction.invokeImpl(project, editor, file);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeImpl(Project project, Editor editor, PsiFile file) {
        block13: {
            int offset = editor.getCaretModel().getOffset();
            PsiFile psiFile = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)file, (int)offset);
            if (psiFile == null) {
                PsiElement element;
                LanguageInjectionSupport support;
                PsiReference reference = file.findReferenceAt(offset);
                if (reference == null) {
                    return;
                }
                if (reference.getElement() instanceof PsiLanguageInjectionHost) {
                    PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)reference.getElement();
                    for (LanguageInjectionSupport support2 : InjectorUtils.getActiveInjectionSupports()) {
                        if (!support2.isApplicableTo(host) || !support2.removeInjectionInPlace(host)) continue;
                        ((PsiModificationTrackerImpl)PsiManager.getInstance((Project)project).getModificationTracker()).incCounter();
                        return;
                    }
                }
                if ((support = (LanguageInjectionSupport)(element = reference.getElement()).getUserData(LanguageInjectionSupport.INJECTOR_SUPPORT)) != null && support.removeInjection(element)) {
                    ((PsiModificationTrackerImpl)PsiManager.getInstance((Project)project).getModificationTracker()).incCounter();
                }
                return;
            }
            PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)project).getInjectionHost((PsiElement)psiFile);
            if (host == null) {
                return;
            }
            LanguageInjectionSupport support = (LanguageInjectionSupport)psiFile.getUserData(LanguageInjectionSupport.INJECTOR_SUPPORT);
            if (support == null) {
                return;
            }
            try {
                if (psiFile.getUserData(LanguageInjectionSupport.TEMPORARY_INJECTED_LANGUAGE) != null) {
                    TemporaryPlacesRegistry temporaryPlacesRegistry = TemporaryPlacesRegistry.getInstance(project);
                    for (PsiLanguageInjectionHost.Shred shred : InjectedLanguageUtil.getShreds((PsiFile)psiFile)) {
                        if (!temporaryPlacesRegistry.removeHostWithUndo(project, shred.getHost())) continue;
                        break block13;
                    }
                    break block13;
                }
                if (!support.removeInjectionInPlace(host)) {
                    UnInjectLanguageAction.defaultFunctionalityWorked(host);
                }
            }
            finally {
                FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
            }
        }
    }

    private static boolean defaultFunctionalityWorked(PsiLanguageInjectionHost host) {
        THashSet languages = new THashSet();
        List files = InjectedLanguageManager.getInstance((Project)host.getProject()).getInjectedPsiFiles((PsiElement)host);
        if (files == null) {
            return false;
        }
        for (Pair pair : files) {
            for (Language lang = ((PsiElement)pair.first).getLanguage(); lang != null; lang = lang.getBaseLanguage()) {
                languages.add((Object)lang.getID());
            }
        }
        return Configuration.getProjectInstance(host.getProject()).setHostInjectionEnabled(host, (Collection<String>)languages, false);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

