/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.compiler;

import java.io.File;
import java.io.FileFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootCopyingHandlerProvider;
import org.jetbrains.jps.incremental.artifacts.instructions.FileCopyingHandler;
import org.jetbrains.jps.incremental.artifacts.instructions.FilterCopyHandler;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenEjbClientConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenResourceFileFilter;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.ex.JpsElementBase;

public class MavenEjbArtifactRootCopyingHandlerProvider
extends ArtifactRootCopyingHandlerProvider {
    @Nullable
    public FileCopyingHandler createCustomHandler(@NotNull JpsArtifact artifact, @NotNull File root, @NotNull JpsPackagingElement contextElement, @NotNull JpsModel model, @NotNull BuildDataPaths buildDataPaths) {
        JpsArtifact parentArtifact;
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/jps/maven/compiler/MavenEjbArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jps/maven/compiler/MavenEjbArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "org/jetbrains/jps/maven/compiler/MavenEjbArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/maven/compiler/MavenEjbArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (buildDataPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDataPaths", "org/jetbrains/jps/maven/compiler/MavenEjbArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        MavenProjectConfiguration projectConfiguration = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(buildDataPaths);
        if (projectConfiguration == null) {
            return null;
        }
        MavenEjbClientConfiguration ejbCfg = projectConfiguration.ejbClientArtifactConfigs.get(artifact.getName());
        if (ejbCfg == null && (parentArtifact = MavenEjbArtifactRootCopyingHandlerProvider.findParentArtifact((JpsElement)contextElement)) != null) {
            ejbCfg = projectConfiguration.ejbClientArtifactConfigs.get(parentArtifact.getName());
        }
        return ejbCfg == null ? null : new FilterCopyHandler((FileFilter)new MavenResourceFileFilter(root, ejbCfg));
    }

    private static JpsArtifact findParentArtifact(JpsElement element) {
        if (element instanceof JpsElementBase) {
            JpsElementBase parent = ((JpsElementBase)element).getParent();
            if (parent instanceof JpsArtifact) {
                return (JpsArtifact)parent;
            }
            if (parent != null) {
                return MavenEjbArtifactRootCopyingHandlerProvider.findParentArtifact((JpsElement)parent);
            }
        }
        return null;
    }
}

