/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.model.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashMap;
import java.io.File;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.resources.ResourcesBuilder;
import org.jetbrains.jps.incremental.resources.StandardResourceBuilderEnabler;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.JpsMavenModuleExtension;
import org.jetbrains.jps.maven.model.impl.JpsMavenModuleExtensionImpl;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsMavenExtensionServiceImpl
extends JpsMavenExtensionService {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.maven.model.impl.JpsMavenExtensionServiceImpl");
    private static final JpsElementChildRole<JpsSimpleElement<Boolean>> PRODUCTION_ON_TEST_ROLE = JpsElementChildRoleBase.create((String)"production on test");
    private final Map<File, MavenProjectConfiguration> myLoadedConfigs = new THashMap(FileUtil.FILE_HASHING_STRATEGY);
    private final FactoryMap<File, Boolean> myConfigFileExists = new ConcurrentFactoryMap<File, Boolean>(){

        @Nullable
        protected Boolean create(File key) {
            return key.exists();
        }
    };

    public JpsMavenExtensionServiceImpl() {
        ResourcesBuilder.registerEnabler((StandardResourceBuilderEnabler)new StandardResourceBuilderEnabler(){

            public boolean isResourceProcessingEnabled(JpsModule module) {
                return JpsMavenExtensionServiceImpl.this.getExtension(module) == null;
            }
        });
    }

    @Override
    @Nullable
    public JpsMavenModuleExtension getExtension(@NotNull JpsModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/maven/model/impl/JpsMavenExtensionServiceImpl", "getExtension"));
        }
        return (JpsMavenModuleExtension)module.getContainer().getChild(JpsMavenModuleExtensionImpl.ROLE);
    }

    @Override
    @NotNull
    public JpsMavenModuleExtension getOrCreateExtension(@NotNull JpsModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/maven/model/impl/JpsMavenExtensionServiceImpl", "getOrCreateExtension"));
        }
        JpsMavenModuleExtension extension = (JpsMavenModuleExtension)module.getContainer().getChild(JpsMavenModuleExtensionImpl.ROLE);
        if (extension == null) {
            extension = new JpsMavenModuleExtensionImpl();
            module.getContainer().setChild(JpsMavenModuleExtensionImpl.ROLE, (JpsElement)extension);
        }
        JpsMavenModuleExtension jpsMavenModuleExtension = extension;
        if (jpsMavenModuleExtension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/maven/model/impl/JpsMavenExtensionServiceImpl", "getOrCreateExtension"));
        }
        return jpsMavenModuleExtension;
    }

    @Override
    public void setProductionOnTestDependency(@NotNull JpsDependencyElement dependency, boolean value) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "org/jetbrains/jps/maven/model/impl/JpsMavenExtensionServiceImpl", "setProductionOnTestDependency"));
        }
        if (value) {
            dependency.getContainer().setChild(PRODUCTION_ON_TEST_ROLE, (JpsElement)JpsElementFactory.getInstance().createSimpleElement((Object)true));
        } else {
            dependency.getContainer().removeChild(PRODUCTION_ON_TEST_ROLE);
        }
    }

    @Override
    public boolean isProductionOnTestDependency(@NotNull JpsDependencyElement dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "org/jetbrains/jps/maven/model/impl/JpsMavenExtensionServiceImpl", "isProductionOnTestDependency"));
        }
        JpsSimpleElement child = (JpsSimpleElement)dependency.getContainer().getChild(PRODUCTION_ON_TEST_ROLE);
        return child != null && (Boolean)child.getData() != false;
    }

    @Override
    public boolean hasMavenProjectConfiguration(@NotNull BuildDataPaths paths) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/jps/maven/model/impl/JpsMavenExtensionServiceImpl", "hasMavenProjectConfiguration"));
        }
        return (Boolean)this.myConfigFileExists.get((Object)new File(paths.getDataStorageRoot(), "maven/configuration.xml"));
    }

    @Override
    public MavenProjectConfiguration getMavenProjectConfiguration(BuildDataPaths paths) {
        if (!this.hasMavenProjectConfiguration(paths)) {
            return null;
        }
        File dataStorageRoot = paths.getDataStorageRoot();
        return this.getMavenProjectConfiguration(dataStorageRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public MavenProjectConfiguration getMavenProjectConfiguration(@NotNull File dataStorageRoot) {
        MavenProjectConfiguration config;
        if (dataStorageRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStorageRoot", "org/jetbrains/jps/maven/model/impl/JpsMavenExtensionServiceImpl", "getMavenProjectConfiguration"));
        }
        File configFile = new File(dataStorageRoot, "maven/configuration.xml");
        Map<File, MavenProjectConfiguration> map = this.myLoadedConfigs;
        synchronized (map) {
            config = this.myLoadedConfigs.get(configFile);
            if (config == null) {
                config = new MavenProjectConfiguration();
                try {
                    XmlSerializer.deserializeInto((Object)config, (Element)JDOMUtil.load((File)configFile));
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                }
                this.myLoadedConfigs.put(configFile, config);
            }
        }
        MavenProjectConfiguration mavenProjectConfiguration = config;
        if (mavenProjectConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/maven/model/impl/JpsMavenExtensionServiceImpl", "getMavenProjectConfiguration"));
        }
        return mavenProjectConfiguration;
    }
}

