/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import icons.EclipseIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.EclipseBundle;

public class EclipseFileType
implements FileType {
    public static final FileType INSTANCE = new EclipseFileType();

    @NotNull
    @NonNls
    public String getName() {
        if ("Eclipse" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/config/EclipseFileType", "getName"));
        }
        return "Eclipse";
    }

    @NotNull
    public String getDescription() {
        String string = EclipseBundle.message("eclipse.file.type.descr", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/config/EclipseFileType", "getDescription"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getDefaultExtension() {
        if ("classpath" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/config/EclipseFileType", "getDefaultExtension"));
        }
        return "classpath";
    }

    @Nullable
    public Icon getIcon() {
        return EclipseIcons.Eclipse;
    }

    public boolean isBinary() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/eclipse/config/EclipseFileType", "getCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/idea/eclipse/config/EclipseFileType", "getCharset"));
        }
        return "UTF-8";
    }
}

