/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.model;

import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.theoryinpractice.testng.model.TestType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TestData
implements Cloneable {
    public String SUITE_NAME;
    public String PACKAGE_NAME;
    public String MAIN_CLASS_NAME;
    public String METHOD_NAME;
    public String GROUP_NAME;
    public String TEST_OBJECT;
    public String VM_PARAMETERS;
    public String PARAMETERS;
    public String WORKING_DIRECTORY;
    public String OUTPUT_DIRECTORY;
    public String ANNOTATION_TYPE;
    public String ENV_VARIABLES;
    private Map<String, String> ENVS = new LinkedHashMap<String, String>();
    public boolean PASS_PARENT_ENVS = true;
    public TestSearchScope.Wrapper TEST_SEARCH_SCOPE;
    public Map<String, String> TEST_PROPERTIES = new HashMap<String, String>();
    public List<String> TEST_LISTENERS = new ArrayList<String>();
    public boolean USE_DEFAULT_REPORTERS = false;
    public String PROPERTIES_FILE;
    private LinkedHashSet<String> myPatterns = new LinkedHashSet();

    public TestData() {
        this.TEST_OBJECT = TestType.CLASS.getType();
        this.TEST_SEARCH_SCOPE = new TestSearchScope.Wrapper();
    }

    public TestSearchScope getScope() {
        return this.TEST_SEARCH_SCOPE.getScope();
    }

    public void setScope(TestSearchScope testseachscope) {
        this.TEST_SEARCH_SCOPE.setScope(testseachscope);
    }

    public String getPackageName() {
        return this.PACKAGE_NAME == null ? "" : this.PACKAGE_NAME;
    }

    public String getGroupName() {
        return this.GROUP_NAME == null ? "" : this.GROUP_NAME;
    }

    public String getMethodName() {
        return this.METHOD_NAME == null ? "" : this.METHOD_NAME;
    }

    public String getSuiteName() {
        return this.SUITE_NAME == null ? "" : this.SUITE_NAME;
    }

    public String getPropertiesFile() {
        return this.PROPERTIES_FILE == null ? "" : this.PROPERTIES_FILE;
    }

    public String getOutputDirectory() {
        return this.OUTPUT_DIRECTORY == null ? "" : this.OUTPUT_DIRECTORY;
    }

    public void setVMParameters(String value) {
        this.VM_PARAMETERS = value;
    }

    public String getVMParameters() {
        return this.VM_PARAMETERS;
    }

    public void setProgramParameters(String value) {
        this.PARAMETERS = value;
    }

    public String getProgramParameters() {
        return this.PARAMETERS;
    }

    public void setWorkingDirectory(String value) {
        this.WORKING_DIRECTORY = ExternalizablePath.urlValue((String)value);
    }

    public String getWorkingDirectory(Project project) {
        return ExternalizablePath.localPathValue((String)this.WORKING_DIRECTORY);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TestData)) {
            return false;
        }
        TestData data = (TestData)obj;
        return Comparing.equal((String)this.TEST_OBJECT, (String)data.TEST_OBJECT) && Comparing.equal((String)this.getMainClassName(), (String)data.getMainClassName()) && Comparing.equal((String)this.getPackageName(), (String)data.getPackageName()) && Comparing.equal((String)this.getSuiteName(), (String)data.getSuiteName()) && Comparing.equal((String)this.getMethodName(), (String)data.getMethodName()) && Comparing.equal((String)this.WORKING_DIRECTORY, (String)data.WORKING_DIRECTORY) && Comparing.equal((String)this.OUTPUT_DIRECTORY, (String)data.OUTPUT_DIRECTORY) && Comparing.equal((String)this.VM_PARAMETERS, (String)data.VM_PARAMETERS) && Comparing.equal((String)this.PARAMETERS, (String)data.PARAMETERS) && Comparing.equal(this.myPatterns, data.myPatterns) && this.USE_DEFAULT_REPORTERS == data.USE_DEFAULT_REPORTERS;
    }

    public int hashCode() {
        return Comparing.hashcode((Object)this.getMainClassName()) ^ Comparing.hashcode((Object)this.getMethodName()) ^ Comparing.hashcode((Object)this.getGroupName()) ^ Comparing.hashcode((Object)this.getSuiteName()) ^ Comparing.hashcode((Object)this.TEST_OBJECT) ^ Comparing.hashcode((Object)this.WORKING_DIRECTORY) ^ Comparing.hashcode((Object)this.OUTPUT_DIRECTORY) ^ Comparing.hashcode((Object)this.VM_PARAMETERS) ^ Comparing.hashcode((Object)this.PARAMETERS) ^ Comparing.hashcode((Object)this.USE_DEFAULT_REPORTERS) ^ Comparing.hashcode(this.myPatterns);
    }

    public TestData clone() {
        TestData data;
        try {
            data = (TestData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            data = new TestData();
        }
        data.TEST_SEARCH_SCOPE = new TestSearchScope.Wrapper();
        data.TEST_PROPERTIES = new HashMap<String, String>();
        data.TEST_PROPERTIES.putAll(this.TEST_PROPERTIES);
        data.TEST_LISTENERS = new ArrayList<String>();
        data.TEST_LISTENERS.addAll(this.TEST_LISTENERS);
        data.USE_DEFAULT_REPORTERS = this.USE_DEFAULT_REPORTERS;
        data.ENVS = new LinkedHashMap<String, String>(this.ENVS);
        data.myPatterns = new LinkedHashSet();
        data.myPatterns.addAll(this.myPatterns);
        data.setScope(this.getScope());
        return data;
    }

    public String getMainClassName() {
        return this.MAIN_CLASS_NAME == null ? "" : this.MAIN_CLASS_NAME;
    }

    public Module setTestMethod(Location<PsiMethod> location) {
        PsiMethod method = (PsiMethod)location.getPsiElement();
        this.METHOD_NAME = method.getName();
        this.TEST_OBJECT = TestType.METHOD.getType();
        return this.setMainClass(location instanceof MethodLocation ? ((MethodLocation)location).getContainingClass() : method.getContainingClass());
    }

    public Module setPackage(PsiPackage pkg) {
        this.PACKAGE_NAME = pkg.getQualifiedName();
        return null;
    }

    public Module setMainClass(PsiClass psiclass) {
        this.MAIN_CLASS_NAME = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiclass);
        PsiPackage psipackage = JUnitUtil.getContainingPackage((PsiClass)psiclass);
        this.PACKAGE_NAME = psipackage == null ? "" : psipackage.getQualifiedName();
        return JavaExecutionUtil.findModule((PsiClass)psiclass);
    }

    public Map<String, String> getEnvs() {
        return this.ENVS;
    }

    public void setEnvs(Map<String, String> envs) {
        this.ENVS = envs;
    }

    public Set<String> getPatterns() {
        return this.myPatterns;
    }

    public void setPatterns(LinkedHashSet<String> set) {
        this.myPatterns = set;
    }
}

