/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.model;

import com.intellij.openapi.project.Project;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.theoryinpractice.testng.model.TestProxy;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.testng.remote.strprotocol.TestResultMessage;

public class TestNGResultsTableModel
extends ListTableModel<TestResultMessage> {
    private final List<TestResultMessage> testResults = new ArrayList<TestResultMessage>();

    public TestNGResultsTableModel(Project project) {
        super(new ColumnInfo[]{new StatusColumnInfo(), new TestNameColumnInfo(project), new TestClassNameColumnInfo(project), new DurationColumnInfo()});
    }

    public void addTestResult(TestResultMessage result) {
        this.testResults.add(result);
        this.setItems(this.testResults);
    }

    private static long getDuration(TestResultMessage result) {
        return result.getEndMillis() - result.getStartMillis();
    }

    private static class DurationColumnInfo
    extends ColumnInfo<TestResultMessage, String> {
        public DurationColumnInfo() {
            super("Time");
        }

        public String valueOf(TestResultMessage result) {
            long time = TestNGResultsTableModel.getDuration(result);
            if (time == 0L) {
                return "0.0 s";
            }
            return NumberFormat.getInstance().format((double)time / 1000.0) + " s";
        }

        public Comparator<TestResultMessage> getComparator() {
            return (o1, o2) -> (int)(TestNGResultsTableModel.getDuration(o1) - TestNGResultsTableModel.getDuration(o2));
        }
    }

    private static class TestClassNameColumnInfo
    extends ColumnInfo<TestResultMessage, String> {
        private final Project project;

        public TestClassNameColumnInfo(Project project) {
            super("Test Class");
            this.project = project;
        }

        public String valueOf(TestResultMessage result) {
            String description = result.getTestClass();
            if (description != null) {
                return description;
            }
            return TestProxy.toDisplayText(result, this.project);
        }

        public Comparator<TestResultMessage> getComparator() {
            return (o1, o2) -> o1.getTestClass().compareToIgnoreCase(o2.getTestClass());
        }
    }

    private static class TestNameColumnInfo
    extends ColumnInfo<TestResultMessage, String> {
        private final Project project;

        public TestNameColumnInfo(Project project) {
            super("Test");
            this.project = project;
        }

        public String valueOf(TestResultMessage result) {
            String displayString = TestProxy.toDisplayText(result, this.project);
            String description = result.getTestDescription();
            if (description != null && description.startsWith(displayString)) {
                return description;
            }
            return displayString;
        }

        public Comparator<TestResultMessage> getComparator() {
            return (o1, o2) -> o1.getMethod().compareToIgnoreCase(o2.getMethod());
        }
    }

    private static class StatusColumnInfo
    extends ColumnInfo<TestResultMessage, String> {
        public StatusColumnInfo() {
            super("Status");
        }

        public String valueOf(TestResultMessage result) {
            switch (result.getResult()) {
                case 1001: {
                    return "Pass";
                }
                case 1002: {
                    return "Fail";
                }
                case 1003: {
                    return "Skipped";
                }
                case 1004: {
                    return "Failed On %";
                }
            }
            return "Unknown result " + result.getResult();
        }

        public Comparator<TestResultMessage> getComparator() {
            return (o1, o2) -> o1.getResult() - o2.getResult();
        }
    }
}

