/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;

public class AddJavascriptInterfaceDetector
extends Detector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("AddJavascriptInterface", "addJavascriptInterface Called", "For applications built for API levels below 17, `WebView#addJavascriptInterface` presents a security hazard as JavaScript on the target web page has the ability to use reflection to access the injected object's public fields and thus manipulate the host application in unintended ways.", Category.SECURITY, 9, Severity.WARNING, new Implementation(AddJavascriptInterfaceDetector.class, Scope.SOURCE_FILE_SCOPE)).addMoreInfo("https://labs.mwrinfosecurity.com/blog/2013/09/24/webview-addjavascriptinterface-remote-code-execution/");
    private static final String WEB_VIEW = "android.webkit.WebView";
    private static final String ADD_JAVASCRIPT_INTERFACE = "addJavascriptInterface";

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    @Nullable
    public List<String> getApplicableFunctionNames() {
        return Collections.singletonList(ADD_JAVASCRIPT_INTERFACE);
    }

    @Override
    public void visitCall(UastAndroidContext context, UCallExpression node) {
        if (context.getLintContext().getMainProject().getMinSdk() >= 17) {
            return;
        }
        UFunction resolvedFunction = node.resolveOrEmpty(context);
        UClass containingClass = UastUtils.getContainingClassOrEmpty(resolvedFunction);
        if (!containingClass.isSubclassOf(WEB_VIEW)) {
            return;
        }
        List<UVariable> valueParameters2 = resolvedFunction.getValueParameters();
        if (node.getValueArgumentCount() != 2 || !valueParameters2.get(0).getType().matchesFqName("java.lang.Object") || !valueParameters2.get(1).getType().matchesFqName("java.lang.String")) {
            return;
        }
        String message2 = "`WebView.addJavascriptInterface` should not be called with minSdkVersion < 17 for security reasons: JavaScript can use reflection to manipulate application";
        context.report(ISSUE, node, context.getLocation(node), message2);
    }
}

