/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.tools.klint.checks.ApiDetector;
import com.android.tools.klint.client.api.IssueRegistry;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UQualifiedExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastVariableKind;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class AnnotationDetector
extends Detector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("LocalSuppress", "@SuppressLint on invalid element", "The `@SuppressAnnotation` is used to suppress Lint warnings in Java files. However, while many lint checks analyzes the Java source code, where they can find annotations on (for example) local variables, some checks are analyzing the `.class` files. And in class files, annotations only appear on classes, fields and methods. Annotations placed on local variables disappear. If you attempt to suppress a lint error for a class-file based lint check, the suppress annotation not work. You must move the annotation out to the surrounding method.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(AnnotationDetector.class, Scope.SOURCE_FILE_SCOPE));

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public UastVisitor createUastVisitor(UastAndroidContext context) {
        return new AnnotationChecker(context);
    }

    private static class AnnotationChecker
    extends AbstractUastVisitor {
        private final UastAndroidContext mContext;

        public AnnotationChecker(UastAndroidContext context) {
            this.mContext = context;
        }

        @Override
        public boolean visitAnnotation(@NotNull UAnnotation node) {
            UElement parent;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/AnnotationDetector$AnnotationChecker", "visitAnnotation"));
            }
            String type2 = node.getName();
            if (("SuppressLint".equals(type2) || "android.annotation.SuppressLint".equals(type2)) && (parent = node.getParent()) instanceof UVariable) {
                for (UNamedExpression element : node.getValueArguments()) {
                    UCallExpression array;
                    UExpression valueNode = element.getExpression();
                    if (UastLiteralUtils.isStringLiteral(valueNode)) {
                        ULiteralExpression literal = (ULiteralExpression)valueNode;
                        String id = (String)literal.getValue();
                        if (this.checkId(node, id)) continue;
                        return super.visitAnnotation(node);
                    }
                    if (!(valueNode instanceof UCallExpression) || ((UCallExpression)valueNode).getKind() != UastCallKind.ARRAY_INITIALIZER || (array = (UCallExpression)valueNode).getValueArgumentCount() == 0) continue;
                    for (UExpression arrayElement : array.getValueArguments()) {
                        String id;
                        if (!UastLiteralUtils.isStringLiteral(arrayElement) || this.checkId(node, id = (String)((ULiteralExpression)arrayElement).getValue())) continue;
                        return super.visitAnnotation(node);
                    }
                }
            }
            return super.visitAnnotation(node);
        }

        private boolean checkId(UAnnotation node, String id) {
            IssueRegistry registry = this.mContext.getLintContext().getDriver().getRegistry();
            Issue issue = registry.getIssue(id);
            if (issue != null && !issue.getImplementation().getScope().contains((Object)Scope.SOURCE_FILE) || issue == ApiDetector.UNSUPPORTED) {
                UElement parent = node.getParent();
                while (parent != null && !(parent instanceof UFunction) && !(parent instanceof UBlockExpression)) {
                    if (issue == ApiDetector.UNSUPPORTED && parent instanceof UDeclarationsExpression) {
                        UDeclarationsExpression declarations2 = (UDeclarationsExpression)parent;
                        for (UVariable var : declarations2.getVariables()) {
                            if (var.getKind() == UastVariableKind.MEMBER || !(var.getInitializer() instanceof UQualifiedExpression)) continue;
                            return true;
                        }
                    }
                    if ((parent = parent.getParent()) != null) continue;
                    return true;
                }
                this.mContext.report(ISSUE, node, this.mContext.getLocation(node), String.format("The `@SuppressLint` annotation cannot be used on a local variable with the lint check '%1$s': move out to the surrounding method", id));
                return false;
            }
            return true;
        }
    }
}

