/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import com.android.tools.klint.detector.api.TextFormat;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;

public class AppCompatCallDetector
extends Detector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("AppCompatMethod", "Using Wrong AppCompat Method", "When using the appcompat library, there are some methods you should be calling instead of the normal ones; for example, `getSupportActionBar()` instead of `getActionBar()`. This lint check looks for calls to the wrong method.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(AppCompatCallDetector.class, Scope.SOURCE_FILE_SCOPE)).addMoreInfo("http://developer.android.com/tools/support-library/index.html");
    private static final String GET_ACTION_BAR = "getActionBar";
    private static final String START_ACTION_MODE = "startActionMode";
    private static final String SET_PROGRESS_BAR_VIS = "setProgressBarVisibility";
    private static final String SET_PROGRESS_BAR_IN_VIS = "setProgressBarIndeterminateVisibility";
    private static final String SET_PROGRESS_BAR_INDETERMINATE = "setProgressBarIndeterminate";
    private static final String REQUEST_WINDOW_FEATURE = "requestWindowFeature";
    private static final String ERROR_MESSAGE_FORMAT = "Should use `%1$s` instead of `%2$s` name";
    private boolean mDependsOnAppCompat;

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.NORMAL;
    }

    @Override
    public void beforeCheckProject(@NonNull Context context) {
        Boolean dependsOnAppCompat = context.getProject().dependsOn("com.android.support:appcompat-v7");
        this.mDependsOnAppCompat = dependsOnAppCompat != null && dependsOnAppCompat != false;
    }

    @Override
    public List<String> getApplicableFunctionNames() {
        return Arrays.asList(GET_ACTION_BAR, START_ACTION_MODE, SET_PROGRESS_BAR_VIS, SET_PROGRESS_BAR_IN_VIS, SET_PROGRESS_BAR_INDETERMINATE, REQUEST_WINDOW_FEATURE);
    }

    @Override
    public void visitCall(UastAndroidContext context, UCallExpression node) {
        if (this.mDependsOnAppCompat && AppCompatCallDetector.isAppBarActivityCall(context, node)) {
            String replace = null;
            if (node.matchesFunctionName(GET_ACTION_BAR)) {
                replace = "getSupportActionBar";
            } else if (node.matchesFunctionName(START_ACTION_MODE)) {
                replace = "startSupportActionMode";
            } else if (node.matchesFunctionName(SET_PROGRESS_BAR_VIS)) {
                replace = "setSupportProgressBarVisibility";
            } else if (node.matchesFunctionName(SET_PROGRESS_BAR_IN_VIS)) {
                replace = "setSupportProgressBarIndeterminateVisibility";
            } else if (node.matchesFunctionName(SET_PROGRESS_BAR_INDETERMINATE)) {
                replace = "setSupportProgressBarIndeterminate";
            } else if (node.matchesFunctionName(REQUEST_WINDOW_FEATURE)) {
                replace = "supportRequestWindowFeature";
            }
            if (replace != null) {
                String message2 = String.format(ERROR_MESSAGE_FORMAT, replace, node.getFunctionName());
                context.report(ISSUE, node, context.getLocation(node), message2);
            }
        }
    }

    private static boolean isAppBarActivityCall(@NonNull UastAndroidContext context, @NonNull UCallExpression node) {
        UClass containingClass;
        UFunction resolved = node.resolve(context);
        if (resolved != null && (containingClass = UastUtils.getContainingClass(resolved)) != null && containingClass.isSubclassOf("android.app.Activity")) {
            return UastUtils.getContainingClassOrEmpty(node).isSubclassOf("android.support.v7.app.ActionBarActivity");
        }
        return false;
    }

    @Nullable
    public static String getOldCall(@NonNull String errorMessage, @NonNull TextFormat format) {
        return AppCompatCallDetector.getMessagePart(errorMessage, 2, format);
    }

    @Nullable
    public static String getNewCall(@NonNull String errorMessage, @NonNull TextFormat format) {
        return AppCompatCallDetector.getMessagePart(errorMessage, 1, format);
    }

    @Nullable
    private static String getMessagePart(@NonNull String errorMessage, int group, @NonNull TextFormat format) {
        List<String> parameters2 = LintUtils.getFormattedParameters(TextFormat.RAW.convertTo(ERROR_MESSAGE_FORMAT, format), errorMessage);
        if (parameters2.size() == 2 && group <= 2) {
            return parameters2.get(group - 1);
        }
        return null;
    }
}

