/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.checks.SupportAnnotationDetector;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UQualifiedExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class CallSuperDetector
extends Detector
implements UastScanner {
    private static final String CALL_SUPER_ANNOTATION = "android.support.annotation.CallSuper";
    private static final String ON_DETACHED_FROM_WINDOW = "onDetachedFromWindow";
    private static final String ON_VISIBILITY_CHANGED = "onVisibilityChanged";
    private static final Implementation IMPLEMENTATION = new Implementation(CallSuperDetector.class, Scope.SOURCE_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("MissingSuperCall", "Missing Super Call", "Some methods, such as `View#onDetachedFromWindow`, require that you also call the super implementation as part of your method.", Category.CORRECTNESS, 9, Severity.ERROR, IMPLEMENTATION);

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public UastVisitor createUastVisitor(final UastAndroidContext context) {
        return new AbstractUastVisitor(){

            @Override
            public boolean visitFunction(@NotNull UFunction node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/CallSuperDetector$1", "visitFunction"));
                }
                CallSuperDetector.checkCallSuper(context, node);
                return false;
            }
        };
    }

    private static void checkCallSuper(@NonNull UastAndroidContext context, @NonNull UFunction declaration2) {
        UFunction superMethod = CallSuperDetector.getRequiredSuperMethod(context, declaration2);
        if (superMethod != null && !SuperCallVisitor.callsSuper(context, declaration2, superMethod)) {
            String methodName = declaration2.getName();
            String message2 = "Overriding method should call `super." + methodName + "`";
            Location location = context.getLocation(declaration2.getNameElement());
            context.report(ISSUE, declaration2, location, message2);
        }
    }

    @Nullable
    private static UFunction getRequiredSuperMethod(UastAndroidContext context, @NonNull UFunction method) {
        UFunction directSuper;
        String name2 = method.getName();
        if (ON_DETACHED_FROM_WINDOW.equals(name2)) {
            if (!UastUtils.getContainingClassOrEmpty(method).isSubclassOf("android.view.View")) {
                return null;
            }
            List<UFunction> superFunctions = method.getSuperFunctions(context);
            return superFunctions.isEmpty() ? null : superFunctions.get(0);
        }
        if (ON_VISIBILITY_CHANGED.equals(name2)) {
            if (!UastUtils.getContainingClassOrEmpty(method).isSubclassOf("android.support.wearable.watchface.WatchFaceService.Engine")) {
                return null;
            }
            List<UFunction> superFunctions = method.getSuperFunctions(context);
            return superFunctions.isEmpty() ? null : superFunctions.get(0);
        }
        List<UFunction> superFunctions = method.getSuperFunctions(context);
        UFunction superMethod = directSuper = superFunctions.isEmpty() ? null : superFunctions.get(0);
        while (superMethod != null) {
            for (UAnnotation annotation : superMethod.getAnnotations()) {
                if ((annotation = SupportAnnotationDetector.getRelevantAnnotation(annotation, context)) == null) continue;
                String fqName = annotation.getFqName();
                if (CALL_SUPER_ANNOTATION.equals(fqName)) {
                    return directSuper;
                }
                if (fqName == null || !fqName.endsWith(".OverrideMustInvoke")) continue;
                return directSuper;
            }
            superFunctions = superMethod.getSuperFunctions(context);
            superMethod = superFunctions.isEmpty() ? null : superFunctions.get(0);
        }
        return null;
    }

    private static class SuperCallVisitor
    extends AbstractUastVisitor {
        private final UastAndroidContext mContext;
        private final String mMethodContainingClassFqName;
        private final String mMethodName;
        private boolean mCallsSuper;

        public static boolean callsSuper(@NonNull UastAndroidContext context, @NonNull UFunction methodDeclaration, @NonNull UFunction superMethod) {
            SuperCallVisitor visitor2 = new SuperCallVisitor(context, superMethod);
            methodDeclaration.accept(visitor2);
            return visitor2.mCallsSuper;
        }

        private SuperCallVisitor(@NonNull UastAndroidContext context, @NonNull UFunction function) {
            this.mContext = context;
            this.mMethodContainingClassFqName = UastUtils.getContainingClassOrEmpty(function).getFqName();
            this.mMethodName = function.getName();
        }

        @Override
        public boolean visitQualifiedExpression(@NotNull UQualifiedExpression node) {
            UFunction resolvedFunction;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/CallSuperDetector$SuperCallVisitor", "visitQualifiedExpression"));
            }
            UExpression receiver2 = node.getReceiver();
            UExpression selector2 = node.getSelector();
            if (receiver2 instanceof USuperExpression && selector2 instanceof UCallExpression && (resolvedFunction = ((UCallExpression)selector2).resolve(this.mContext)) != null && resolvedFunction.matchesNameWithContaining(this.mMethodContainingClassFqName, this.mMethodName)) {
                this.mCallsSuper = true;
                return true;
            }
            return false;
        }

        @Override
        public boolean visitElement(@NotNull UElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/CallSuperDetector$SuperCallVisitor", "visitElement"));
            }
            return this.mCallsSuper || super.visitElement(node);
        }
    }
}

