/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;

public class CipherGetInstanceDetector
extends Detector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("GetInstance", "Cipher.getInstance with ECB", "`Cipher#getInstance` should not be called with ECB as the cipher mode or without setting the cipher mode because the default mode on android is ECB, which is insecure.", Category.SECURITY, 9, Severity.WARNING, new Implementation(CipherGetInstanceDetector.class, Scope.SOURCE_FILE_SCOPE));
    private static final String CIPHER = "javax.crypto.Cipher";
    private static final String GET_INSTANCE = "getInstance";
    private static final Set<String> ALGORITHM_ONLY = Sets.newHashSet((Object[])new String[]{"AES", "DES", "DESede"});
    private static final String ECB = "ECB";

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public List<String> getApplicableFunctionNames() {
        return Collections.singletonList(GET_INSTANCE);
    }

    @Override
    public void visitCall(UastAndroidContext context, UCallExpression node) {
        UClass containingClass = UastUtils.getContainingClass(node);
        if (containingClass == null || !containingClass.isSubclassOf(CIPHER)) {
            return;
        }
        List<UExpression> argumentList = node.getValueArguments();
        if (argumentList.size() == 1) {
            Object value2;
            UVariable field;
            UExpression initializer2;
            UDeclaration declaration2;
            UExpression expression2 = argumentList.get(0);
            if (expression2 instanceof ULiteralExpression) {
                ULiteralExpression argument = (ULiteralExpression)expression2;
                String parameter = argument.renderString();
                CipherGetInstanceDetector.checkParameter(context, node, argument, parameter, false);
            } else if (expression2 instanceof UResolvable && (declaration2 = ((UResolvable)((Object)expression2)).resolve(context)) instanceof UVariable && (initializer2 = (field = (UVariable)declaration2).getInitializer()) != null && (value2 = initializer2.evaluate()) instanceof String) {
                CipherGetInstanceDetector.checkParameter(context, node, expression2, (String)value2, true);
            }
        }
    }

    private static void checkParameter(@NonNull UastAndroidContext context, @NonNull UCallExpression call, @NonNull UExpression arg, @NonNull String value2, boolean includeValue) {
        if (ALGORITHM_ONLY.contains(value2)) {
            String message2 = "`Cipher.getInstance` should not be called without setting the encryption mode and padding";
            context.report(ISSUE, call, context.getLocation(arg), message2);
        } else if (value2.contains(ECB)) {
            String message3 = "ECB encryption mode should not be used";
            if (includeValue) {
                message3 = message3 + " (was \"" + value2 + "\")";
            }
            context.report(ISSUE, call, context.getLocation(arg), message3);
        }
    }
}

