/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UType;
import org.jetbrains.uast.UastModifier;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;

public class HandlerDetector
extends Detector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("HandlerLeak", "Handler reference leaks", "Since this Handler is declared as an inner class, it may prevent the outer class from being garbage collected. If the Handler is using a Looper or MessageQueue for a thread other than the main thread, then there is no issue. If the Handler is using the Looper or MessageQueue of the main thread, you need to fix your Handler declaration, as follows: Declare the Handler as a static class; In the outer class, instantiate a WeakReference to the outer class and pass this object to your Handler when you instantiate the Handler; Make all references to members of the outer class using the WeakReference object.", Category.PERFORMANCE, 4, Severity.WARNING, new Implementation(HandlerDetector.class, Scope.SOURCE_FILE_SCOPE));
    private static final String LOOPER_CLS = "android.os.Looper";
    private static final String HANDLER_CLS = "android.os.Handler";

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public List<String> getApplicableSuperClasses() {
        return Collections.singletonList(HANDLER_CLS);
    }

    @Override
    public void visitClass(UastAndroidContext context, UClass node) {
        if (UastUtils.isTopLevel(node)) {
            return;
        }
        if (node.hasModifier(UastModifier.STATIC)) {
            return;
        }
        if (HandlerDetector.hasLooperConstructorParameter(node)) {
            return;
        }
        UElement locationNode = node.getNameElement();
        Location location = context.getLocation(locationNode);
        context.report(ISSUE, node, location, String.format("This Handler class should be static or leaks might occur (%1$s)", node.getName()));
    }

    private static boolean hasLooperConstructorParameter(@NonNull UClass cls) {
        for (UFunction constructor : cls.getConstructors()) {
            int n = constructor.getValueParameterCount();
            for (int i = 0; i < n; ++i) {
                UType type2 = constructor.getValueParameters().get(i).getType();
                if (!type2.matchesFqName(LOOPER_CLS)) continue;
                return true;
            }
        }
        return false;
    }
}

