/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.klint.client.api.LintClient;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.LayoutDetector;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Project;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import com.android.tools.klint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedExpression;
import org.jetbrains.uast.USimpleReferenceExpression;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.kxml2.io.KXmlParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xmlpull.v1.XmlPullParserException;

public class LayoutInflationDetector
extends LayoutDetector
implements UastScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(LayoutInflationDetector.class, Scope.SOURCE_AND_RESOURCE_FILES, Scope.SOURCE_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("InflateParams", "Layout Inflation without a Parent", "When inflating a layout, avoid passing in null as the parent view, since otherwise any layout parameters on the root of the inflated layout will be ignored.", Category.CORRECTNESS, 5, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://www.doubleencore.com/2013/05/layout-inflation-as-intended");
    private static final String ERROR_MESSAGE = "Avoid passing `null` as the view root (needed to resolve layout parameters on the inflated layout's root element)";
    private Set<String> mLayoutsWithRootLayoutParams;
    private List<Pair<String, Location>> mPendingErrors;

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.NORMAL;
    }

    @Override
    public void afterCheckProject(@NonNull Context context) {
        if (this.mPendingErrors != null) {
            for (Pair<String, Location> pair : this.mPendingErrors) {
                String inflatedLayout = (String)pair.getFirst();
                if (this.mLayoutsWithRootLayoutParams == null || !this.mLayoutsWithRootLayoutParams.contains(inflatedLayout)) continue;
                Location location = (Location)pair.getSecond();
                context.report(ISSUE, location, ERROR_MESSAGE);
            }
        }
    }

    @Override
    public void visitDocument(@NonNull XmlContext context, @NonNull Document document) {
        Element root = document.getDocumentElement();
        if (root != null) {
            NamedNodeMap attributes = root.getAttributes();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attribute = (Attr)attributes.item(i);
                if (attribute.getLocalName() == null || !attribute.getLocalName().startsWith("layout_")) continue;
                if (this.mLayoutsWithRootLayoutParams == null) {
                    this.mLayoutsWithRootLayoutParams = Sets.newHashSetWithExpectedSize((int)20);
                }
                this.mLayoutsWithRootLayoutParams.add(LintUtils.getBaseName(context.file.getName()));
                break;
            }
        }
    }

    @Override
    public List<String> getApplicableFunctionNames() {
        return Collections.singletonList("inflate");
    }

    @Override
    public void visitCall(UastAndroidContext context, UCallExpression node) {
        UQualifiedExpression rLayout;
        assert ("inflate".equals(node.getFunctionName()));
        if (node instanceof USimpleReferenceExpression) {
            return;
        }
        List<UExpression> arguments = node.getValueArguments();
        if (arguments.size() < 2) {
            return;
        }
        Iterator<UExpression> iterator = arguments.iterator();
        UExpression first = iterator.next();
        UExpression second = iterator.next();
        if (!UastLiteralUtils.isNullLiteral(second) || !(first instanceof UQualifiedExpression)) {
            return;
        }
        UQualifiedExpression select = (UQualifiedExpression)first;
        UExpression receiver2 = select.getReceiver();
        UExpression selector2 = select.getSelector();
        if (receiver2 instanceof UQualifiedExpression && selector2 instanceof USimpleReferenceExpression && (rLayout = (UQualifiedExpression)receiver2).selectorMatches(ResourceType.LAYOUT.getName()) && rLayout.getReceiver().renderString().endsWith("R")) {
            String layoutName = ((USimpleReferenceExpression)selector2).getIdentifier();
            JavaContext lintContext = context.getLintContext();
            if (lintContext.getScope().contains((Object)Scope.RESOURCE_FILE)) {
                if (!lintContext.getDriver().isSuppressed(lintContext, ISSUE, node)) {
                    if (this.mPendingErrors == null) {
                        this.mPendingErrors = Lists.newArrayList();
                    }
                    Location location = context.getLocation(second);
                    this.mPendingErrors.add((Pair<String, Location>)Pair.of((Object)layoutName, (Object)location));
                }
            } else if (LayoutInflationDetector.hasLayoutParams(lintContext, layoutName)) {
                context.report(ISSUE, node, context.getLocation(second), ERROR_MESSAGE);
            }
        }
    }

    private static boolean hasLayoutParams(@NonNull JavaContext context, String name2) {
        LintClient client = context.getClient();
        if (!client.supportsProjectResources()) {
            return true;
        }
        Project project = context.getProject();
        AbstractResourceRepository resources2 = client.getProjectResources(project, true);
        if (resources2 == null) {
            return true;
        }
        List items = resources2.getResourceItem(ResourceType.LAYOUT, name2);
        if (items == null || items.isEmpty()) {
            return false;
        }
        for (ResourceItem item : items) {
            ResourceFile source = (ResourceFile)item.getSource();
            if (source == null) {
                return true;
            }
            File file = source.getFile();
            if (!file.exists()) continue;
            try {
                String s = context.getClient().readFile(file);
                if (!LayoutInflationDetector.hasLayoutParams(new StringReader(s))) continue;
                return true;
            }
            catch (Exception e) {
                context.log(e, "Could not read/parse inflated layout", new Object[0]);
                return true;
            }
        }
        return false;
    }

    static boolean hasLayoutParams(@NonNull Reader reader) throws XmlPullParserException, IOException {
        int event;
        KXmlParser parser = new KXmlParser();
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        parser.setInput(reader);
        do {
            if ((event = parser.next()) != 2) continue;
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String prefix;
                if (!parser.getAttributeName(i).startsWith("layout_") || (prefix = parser.getAttributePrefix(i)) == null || prefix.isEmpty() || !"http://schemas.android.com/apk/res/android".equals(parser.getNamespace(prefix))) continue;
                return true;
            }
            return false;
        } while (event != 1);
        return false;
    }
}

