/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;

public class SetJavaScriptEnabledDetector
extends Detector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("SetJavaScriptEnabled", "Using `setJavaScriptEnabled`", "Your code should not invoke `setJavaScriptEnabled` if you are not sure that your app really requires JavaScript support.", Category.SECURITY, 6, Severity.WARNING, new Implementation(SetJavaScriptEnabledDetector.class, Scope.SOURCE_FILE_SCOPE)).addMoreInfo("http://developer.android.com/guide/practices/security.html");

    @Override
    public void visitCall(UastAndroidContext context, UCallExpression node) {
        if (node.getValueArgumentCount() != 1) {
            return;
        }
        Object value2 = node.getValueArguments().get(0).evaluate();
        if (value2 instanceof Boolean && ((Boolean)value2).booleanValue()) {
            context.report(ISSUE, node, context.getLocation(node), "Using `setJavaScriptEnabled` can introduce XSS vulnerabilities into you application, review carefully.");
        }
    }

    @Override
    public List<String> getApplicableFunctionNames() {
        return Collections.singletonList("setJavaScriptEnabled");
    }
}

