/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDoWhileExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UForExpression;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UQualifiedExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.UType;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UWhileExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.jetbrains.uast.java.JavaUAssertExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;

public class SharedPrefsDetector
extends Detector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("CommitPrefEdits", "Missing `commit()` on `SharedPreference` editor", "After calling `edit()` on a `SharedPreference`, you must call `commit()` or `apply()` on the editor to save the results.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(SharedPrefsDetector.class, Scope.SOURCE_FILE_SCOPE));
    public static final String ANDROID_CONTENT_SHARED_PREFERENCES = "android.content.SharedPreferences";
    private static final String ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR = "android.content.SharedPreferences.Editor";

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @Override
    public List<String> getApplicableFunctionNames() {
        return Collections.singletonList("edit");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitCall(UastAndroidContext context, UCallExpression node) {
        boolean allowCommitBeforeTarget;
        UElement parent;
        assert ("edit".equals(node.getFunctionName()));
        boolean verifiedType = false;
        UFunction resolve = node.resolve(context);
        if (resolve != null) {
            UType returnType2 = resolve.getReturnType();
            if (returnType2 == null || !returnType2.matchesFqName(ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR)) {
                return;
            }
            verifiedType = true;
        }
        if (!((parent = node.getParent()) instanceof UQualifiedExpression)) {
            return;
        }
        UExpression operand2 = ((UQualifiedExpression)parent).getReceiver();
        UVariable definition = SharedPrefsDetector.getLhs(parent);
        if (definition == null) {
            String type2;
            if (!(operand2 instanceof USimpleReferenceExpression)) return;
            UDeclaration resolvedDeclaration = ((USimpleReferenceExpression)operand2).resolve(context);
            if (resolvedDeclaration instanceof UVariable && !(type2 = ((UVariable)resolvedDeclaration).getType().getName()).equals("SharedPreferences")) {
                return;
            }
            allowCommitBeforeTarget = true;
        } else {
            if (!verifiedType) {
                UType type3 = definition.getType();
                UClass clazz = type3.resolveOrEmpty(context);
                String possiblefqName = clazz.getFqName();
                if (possiblefqName == null) {
                    possiblefqName = clazz.getName();
                }
                if (!(!possiblefqName.endsWith("SharedPreferences.Editor") || type3.matchesFqName("Editor") && LintUtils.isImported(context.getLintContext().getCompilationUnit(), ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR))) {
                    return;
                }
            }
            allowCommitBeforeTarget = false;
        }
        UFunction method = UastUtils.getContainingFunction(parent);
        if (method == null) {
            return;
        }
        CommitFinder finder = new CommitFinder(context, node, allowCommitBeforeTarget);
        method.accept(finder);
        if (finder.isCommitCalled()) return;
        context.report(ISSUE, method, context.getLocation(node), "`SharedPreferences.edit()` without a corresponding `commit()` or `apply()` call");
    }

    @Nullable
    private static UVariable getLhs(@NonNull UElement node) {
        while (node != null) {
            if (node instanceof UFunction) {
                return null;
            }
            if (node instanceof UVariable) {
                return (UVariable)node;
            }
            node = node.getParent();
        }
        return null;
    }

    private static class CommitFinder
    extends AbstractUastVisitor {
        private final UCallExpression mTarget;
        private final boolean mAllowCommitBeforeTarget;
        private final UastAndroidContext mContext;
        private boolean mFound;
        private boolean mSeenTarget;

        private CommitFinder(UastAndroidContext context, UCallExpression target, boolean allowCommitBeforeTarget) {
            this.mContext = context;
            this.mTarget = target;
            this.mAllowCommitBeforeTarget = allowCommitBeforeTarget;
        }

        @Override
        public boolean visitCallExpression(@NotNull UCallExpression node) {
            String name2;
            boolean isCommit;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/SharedPrefsDetector$CommitFinder", "visitCallExpression"));
            }
            UExpression qualifiedElement = UastUtils.getQualifiedCallElement(node);
            if (node == this.mTarget) {
                this.mSeenTarget = true;
            } else if ((this.mAllowCommitBeforeTarget || this.mSeenTarget || qualifiedElement instanceof UQualifiedExpression && ((UQualifiedExpression)qualifiedElement).getReceiver() == this.mTarget) && ((isCommit = "commit".equals(name2 = node.getFunctionName())) || "apply".equals(name2))) {
                UClass clz;
                this.mFound = true;
                UFunction method = node.resolve(this.mContext);
                if (method != null && (clz = UastUtils.getContainingClassOrEmpty(method)).isSubclassOf(SharedPrefsDetector.ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR) && this.mContext.getLintContext().getProject().getMinSdkVersion().getApiLevel() >= 9) {
                    boolean returnValueIgnored = false;
                    if (qualifiedElement instanceof UFunction || qualifiedElement instanceof UClass || qualifiedElement instanceof UBlockExpression) {
                        returnValueIgnored = true;
                    } else if (qualifiedElement instanceof UIfExpression) {
                        returnValueIgnored = ((UIfExpression)qualifiedElement).getCondition() != node;
                    } else if (qualifiedElement instanceof UReturnExpression) {
                        returnValueIgnored = false;
                    } else if (qualifiedElement instanceof UVariable) {
                        returnValueIgnored = false;
                    } else if (qualifiedElement instanceof UForExpression) {
                        returnValueIgnored = ((UForExpression)qualifiedElement).getCondition() != node;
                    } else if (qualifiedElement instanceof UWhileExpression) {
                        returnValueIgnored = ((UWhileExpression)qualifiedElement).getCondition() != node;
                    } else if (qualifiedElement instanceof UDoWhileExpression) {
                        returnValueIgnored = ((UDoWhileExpression)qualifiedElement).getCondition() != node;
                    } else if (qualifiedElement instanceof USwitchClauseExpression) {
                        List<UExpression> caseValues2 = ((USwitchClauseExpression)qualifiedElement).getCaseValues();
                        for (UExpression caseValue : caseValues2) {
                            if (caseValue != node) continue;
                            returnValueIgnored = false;
                            break;
                        }
                    } else {
                        returnValueIgnored = qualifiedElement instanceof JavaUAssertExpression ? !((JavaUAssertExpression)qualifiedElement).getCondition().equals(node) : true;
                    }
                    if (returnValueIgnored && isCommit) {
                        String message2 = "Consider using `apply()` instead; `commit` writes its data to persistent storage immediately, whereas `apply` will handle it in the background";
                        this.mContext.report(ISSUE, node, this.mContext.getLocation(node), message2);
                    }
                }
            }
            return false;
        }

        @Override
        public boolean visitReturnExpression(@NotNull UReturnExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/SharedPrefsDetector$CommitFinder", "visitReturnExpression"));
            }
            if (this.mTarget.equals(node.getExpressionType())) {
                this.mFound = true;
            }
            return false;
        }

        boolean isCommitCalled() {
            return this.mFound;
        }
    }
}

