/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import com.android.tools.klint.detector.api.TextFormat;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UQualifiedExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastFunctionKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;

public class WrongCallDetector
extends Detector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("WrongCall", "Using wrong draw/layout method", "Custom views typically need to call `measure()` on their children, not `onMeasure`. Ditto for onDraw, onLayout, etc.", Category.CORRECTNESS, 6, Severity.FATAL, new Implementation(WrongCallDetector.class, Scope.SOURCE_FILE_SCOPE));

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public List<String> getApplicableFunctionNames() {
        return Arrays.asList("onDraw", "onMeasure", "onLayout");
    }

    @Override
    public void visitCall(UastAndroidContext context, UCallExpression node) {
        UExpression operand2;
        if (node.getKind() != UastCallKind.FUNCTION_CALL) {
            return;
        }
        UElement referenceExpression = node.getParent();
        if (referenceExpression instanceof UQualifiedExpression && !((operand2 = ((UQualifiedExpression)referenceExpression).getReceiver()) instanceof USuperExpression)) {
            WrongCallDetector.report(context, node);
            return;
        }
        UFunction containingFunction = UastUtils.getContainingFunction(node);
        if (containingFunction == null) {
            return;
        }
        if (containingFunction.getKind() == UastFunctionKind.CONSTRUCTOR || !containingFunction.matchesName(node.getFunctionName())) {
            WrongCallDetector.report(context, node);
        }
    }

    private static void report(UastAndroidContext context, UCallExpression node) {
        UClass containingClass;
        UFunction resolved = node.resolve(context);
        if (!(resolved == null || resolved.getKind() == UastFunctionKind.CONSTRUCTOR || (containingClass = UastUtils.getContainingClass(resolved)) != null && containingClass.isSubclassOf("android.view.View"))) {
            return;
        }
        String name2 = node.getFunctionName();
        if (name2 == null) {
            return;
        }
        String suggestion = Character.toLowerCase(name2.charAt(2)) + name2.substring(3);
        String message2 = String.format("Suspicious method call; should probably call \"`%1$s`\" rather than \"`%2$s`\"", suggestion, name2);
        context.report(ISSUE, node, context.getLocation(node.getFunctionReference()), message2);
    }

    @Nullable
    public static String getOldValue(@NonNull String errorMessage, @NonNull TextFormat format) {
        errorMessage = format.toText(errorMessage);
        return LintUtils.findSubstring(errorMessage, "than \"", "\"");
    }

    @Nullable
    public static String getNewValue(@NonNull String errorMessage, @NonNull TextFormat format) {
        errorMessage = format.toText(errorMessage);
        return LintUtils.findSubstring(errorMessage, "call \"", "\"");
    }
}

