/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.client.api;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.klint.client.api.CircularDependencyException;
import com.android.tools.klint.client.api.ClassEntry;
import com.android.tools.klint.client.api.CompositeIssueRegistry;
import com.android.tools.klint.client.api.Configuration;
import com.android.tools.klint.client.api.DefaultConfiguration;
import com.android.tools.klint.client.api.DefaultSdkInfo;
import com.android.tools.klint.client.api.IssueRegistry;
import com.android.tools.klint.client.api.JarFileIssueRegistry;
import com.android.tools.klint.client.api.SdkInfo;
import com.android.tools.klint.client.api.SdkWrapper;
import com.android.tools.klint.client.api.XmlParser;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Project;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.TextFormat;
import com.android.utils.XmlUtils;
import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.uast.UastLanguagePlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Beta
public abstract class LintClient {
    private static final String PROP_BIN_DIR = "com.android.tools.lint.bindir";
    private Map<Project, ClassPathInfo> mProjectInfo;
    private Map<File, Project> mDirToProject;
    private Set<File> mProjectDirs = Sets.newHashSet();
    protected IAndroidTarget[] mTargets;
    protected SdkWrapper mSdk;
    private ResourceVisibilityLookup.Provider mResourceVisibility;

    public Configuration getConfiguration(@NonNull Project project) {
        return DefaultConfiguration.create(this, project, null);
    }

    public abstract void report(@NonNull Context var1, @NonNull Issue var2, @NonNull Severity var3, @Nullable Location var4, @NonNull String var5, @NonNull TextFormat var6);

    public void log(@Nullable Throwable exception, @Nullable String format, Object ... args) {
        this.log(Severity.WARNING, exception, format, args);
    }

    public abstract void log(@NonNull Severity var1, @Nullable Throwable var2, @Nullable String var3, Object ... var4);

    @Nullable
    public abstract XmlParser getXmlParser();

    @NonNull
    public Class<? extends Detector> replaceDetector(@NonNull Class<? extends Detector> detectorClass) {
        return detectorClass;
    }

    @NonNull
    public abstract String readFile(@NonNull File var1);

    @NonNull
    public byte[] readBytes(@NonNull File file) throws IOException {
        return Files.toByteArray((File)file);
    }

    @NonNull
    public List<File> getJavaSourceFolders(@NonNull Project project) {
        return this.getClassPath(project).getSourceFolders();
    }

    @NonNull
    public List<File> getJavaClassFolders(@NonNull Project project) {
        return this.getClassPath(project).getClassFolders();
    }

    @NonNull
    public List<File> getJavaLibraries(@NonNull Project project) {
        return this.getClassPath(project).getLibraries();
    }

    @NonNull
    public List<File> getTestSourceFolders(@NonNull Project project) {
        return this.getClassPath(project).getTestSourceFolders();
    }

    @NonNull
    public List<File> getResourceFolders(@NonNull Project project) {
        File res = new File(project.getDir(), "res");
        if (res.exists()) {
            return Collections.singletonList(res);
        }
        return Collections.emptyList();
    }

    @NonNull
    public SdkInfo getSdkInfo(@NonNull Project project) {
        return new DefaultSdkInfo();
    }

    @Nullable
    public File getCacheDir(boolean create) {
        String home = System.getProperty("user.home");
        String relative = ".android" + File.separator + "cache";
        File dir = new File(home, relative);
        if (create && !dir.exists() && !dir.mkdirs()) {
            return null;
        }
        return dir;
    }

    @Nullable
    private static File getLintBinDir() {
        File file;
        String path = System.getProperty(PROP_BIN_DIR);
        if (path == null || path.isEmpty()) {
            path = System.getenv(PROP_BIN_DIR);
        }
        if (path != null && !path.isEmpty() && (file = new File(path)).exists()) {
            return file;
        }
        return null;
    }

    @Nullable
    public File getSdkHome() {
        String home;
        File binDir = LintClient.getLintBinDir();
        if (binDir != null) {
            assert (binDir.getName().equals("tools"));
            File root = binDir.getParentFile();
            if (root != null && root.isDirectory()) {
                return root;
            }
        }
        if ((home = System.getenv("ANDROID_HOME")) != null) {
            return new File(home);
        }
        return null;
    }

    @Nullable
    public File findResource(@NonNull String relativePath) {
        File top = this.getSdkHome();
        if (top == null) {
            throw new IllegalArgumentException("Lint must be invoked with the System property com.android.tools.lint.bindir pointing to the ANDROID_SDK tools directory");
        }
        File file = new File(top, relativePath);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public boolean isGradleProject(Project project) {
        File root;
        if (new File(project.getDir(), "build.gradle").exists()) {
            return true;
        }
        File parent = project.getDir().getParentFile();
        return parent != null && parent.getName().equals("src") && (root = parent.getParentFile()) != null && new File(root, "build.gradle").exists();
    }

    @Nullable
    public com.intellij.openapi.project.Project getProject() {
        return null;
    }

    public List<UastLanguagePlugin> getLanguagePlugins() {
        return Collections.emptyList();
    }

    @NonNull
    protected ClassPathInfo getClassPath(@NonNull Project project) {
        ClassPathInfo info;
        if (this.mProjectInfo == null) {
            this.mProjectInfo = Maps.newHashMap();
            info = null;
        } else {
            info = this.mProjectInfo.get(project);
        }
        if (info == null) {
            File[] jars;
            File libs;
            ArrayList<File> sources = new ArrayList<File>(2);
            ArrayList<File> classes = new ArrayList<File>(1);
            ArrayList<File> libraries = new ArrayList<File>();
            List<File> tests = Collections.emptyList();
            File projectDir = project.getDir();
            File classpathFile = new File(projectDir, ".classpath");
            if (classpathFile.exists()) {
                String classpathXml = this.readFile(classpathFile);
                try {
                    Document document = XmlUtils.parseDocument((String)classpathXml, (boolean)false);
                    File[] tags = document.getElementsByTagName("classpathentry");
                    int n = tags.getLength();
                    for (int i = 0; i < n; ++i) {
                        String path;
                        File folder;
                        Element element = (Element)tags.item(i);
                        String kind2 = element.getAttribute("kind");
                        ArrayList<File> addTo = null;
                        if (kind2.equals("src")) {
                            addTo = sources;
                        } else if (kind2.equals("output")) {
                            addTo = classes;
                        } else if (kind2.equals("lib")) {
                            addTo = libraries;
                        }
                        if (addTo == null || !(folder = new File(projectDir, path = element.getAttribute("path"))).exists()) continue;
                        addTo.add(folder);
                    }
                }
                catch (Exception e) {
                    this.log(null, null, new Object[0]);
                }
            }
            if ((libs = new File(project.getDir(), "libs")).isDirectory() && (jars = libs.listFiles()) != null) {
                for (File jar : jars) {
                    if (!LintUtils.endsWith(jar.getPath(), ".jar") || libraries.contains(jar)) continue;
                    libraries.add(jar);
                }
            }
            if (classes.isEmpty()) {
                File folder = new File(projectDir, SdkConstants.CLASS_FOLDER);
                if (folder.exists()) {
                    classes.add(folder);
                } else {
                    folder = new File(projectDir, "target" + File.separator + "classes");
                    if (folder.exists()) {
                        classes.add(folder);
                        if (sources.isEmpty()) {
                            File src = new File(projectDir, "src" + File.separator + "main" + File.separator + "java");
                            if (src.exists()) {
                                sources.add(src);
                            } else {
                                src = new File(projectDir, "src");
                                if (src.exists()) {
                                    sources.add(src);
                                }
                            }
                            File gen = new File(projectDir, "target" + File.separator + "generated-sources" + File.separator + "r");
                            if (gen.exists()) {
                                sources.add(gen);
                            }
                        }
                    }
                }
            }
            if (sources.isEmpty()) {
                File gen;
                File src = new File(projectDir, "src");
                if (src.exists()) {
                    sources.add(src);
                }
                if ((gen = new File(projectDir, "gen")).exists()) {
                    sources.add(gen);
                }
            }
            info = new ClassPathInfo(sources, classes, libraries, tests);
            this.mProjectInfo.put(project, info);
        }
        return info;
    }

    @NonNull
    public Project getProject(@NonNull File dir, @NonNull File referenceDir) {
        if (this.mDirToProject == null) {
            this.mDirToProject = new HashMap<File, Project>();
        }
        File canonicalDir = dir;
        try {
            canonicalDir = dir.getCanonicalFile();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        Project project = this.mDirToProject.get(canonicalDir);
        if (project != null) {
            return project;
        }
        project = this.createProject(dir, referenceDir);
        this.mDirToProject.put(canonicalDir, project);
        return project;
    }

    public Collection<Project> getKnownProjects() {
        return this.mDirToProject != null ? this.mDirToProject.values() : Collections.emptyList();
    }

    public void registerProject(@NonNull File dir, @NonNull Project project) {
        File canonicalDir = dir;
        try {
            canonicalDir = dir.getCanonicalFile();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (this.mDirToProject == null) {
            this.mDirToProject = new HashMap<File, Project>();
        } else assert (!this.mDirToProject.containsKey(dir)) : dir;
        this.mDirToProject.put(canonicalDir, project);
    }

    @NonNull
    protected Project createProject(@NonNull File dir, @NonNull File referenceDir) {
        if (this.mProjectDirs.contains(dir)) {
            throw new CircularDependencyException("Circular library dependencies; check your project.properties files carefully");
        }
        this.mProjectDirs.add(dir);
        return Project.create(this, dir, referenceDir);
    }

    @NonNull
    public String getProjectName(@NonNull Project project) {
        return project.getDir().getName();
    }

    @NonNull
    public IAndroidTarget[] getTargets() {
        if (this.mTargets == null) {
            SdkWrapper localSdk = this.getSdk();
            this.mTargets = localSdk != null ? localSdk.getTargets() : new IAndroidTarget[0];
        }
        return this.mTargets;
    }

    @Nullable
    public SdkWrapper getSdk() {
        File sdkHome;
        if (this.mSdk == null && (sdkHome = this.getSdkHome()) != null) {
            this.mSdk = SdkWrapper.createLocalSdk(sdkHome);
        }
        return this.mSdk;
    }

    @Nullable
    public IAndroidTarget getCompileTarget(@NonNull Project project) {
        int buildSdk = project.getBuildSdk();
        IAndroidTarget[] targets = this.getTargets();
        for (int i = targets.length - 1; i >= 0; --i) {
            IAndroidTarget target = targets[i];
            if (!target.isPlatform() || target.getVersion().getApiLevel() != buildSdk) continue;
            return target;
        }
        return null;
    }

    public int getHighestKnownApiLevel() {
        int max = 23;
        for (IAndroidTarget target : this.getTargets()) {
            int api;
            if (!target.isPlatform() || (api = target.getVersion().getApiLevel()) <= max || target.getVersion().isPreview()) continue;
            max = api;
        }
        return max;
    }

    @Nullable
    public String getSuperClass(@NonNull Project project, @NonNull String name2) {
        assert (name2.indexOf(46) == -1) : "Use VM signatures, e.g. java/lang/Integer";
        if ("java/lang/Object".equals(name2)) {
            return null;
        }
        String superClass = project.getSuperClassMap().get(name2);
        if (superClass != null) {
            return superClass;
        }
        for (Project library : project.getAllLibraries()) {
            superClass = library.getSuperClassMap().get(name2);
            if (superClass == null) continue;
            return superClass;
        }
        return null;
    }

    @NonNull
    public Map<String, String> createSuperClassMap(@NonNull Project project) {
        List<File> libraries = project.getJavaLibraries();
        List<File> classFolders = project.getJavaClassFolders();
        List<ClassEntry> classEntries = ClassEntry.fromClassPath(this, classFolders, true);
        if (libraries.isEmpty()) {
            return ClassEntry.createSuperClassMap(this, classEntries);
        }
        List<ClassEntry> libraryEntries = ClassEntry.fromClassPath(this, libraries, true);
        return ClassEntry.createSuperClassMap(this, libraryEntries, classEntries);
    }

    @Nullable
    public Boolean isSubclassOf(@NonNull Project project, @NonNull String name2, @NonNull String superClassName) {
        return null;
    }

    @NonNull
    public List<File> findGlobalRuleJars() {
        String lintClassPath;
        File jarFile;
        List<File> files = null;
        try {
            File[] list;
            String androidHome = AndroidLocation.getFolder();
            File lint = new File(androidHome + File.separator + "lint");
            if (lint.exists() && (list = lint.listFiles()) != null) {
                File[] fileArray = list;
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    jarFile = fileArray[i];
                    if (!LintUtils.endsWith(jarFile.getName(), ".jar")) continue;
                    if (files == null) {
                        files = new ArrayList<File>();
                    }
                    files.add(jarFile);
                }
            }
        }
        catch (AndroidLocation.AndroidLocationException e) {
            // empty catch block
        }
        if ((lintClassPath = System.getenv("ANDROID_LINT_JARS")) != null && !lintClassPath.isEmpty()) {
            String[] paths;
            for (String path : paths = lintClassPath.split(File.pathSeparator)) {
                jarFile = new File(path);
                if (!jarFile.exists()) continue;
                if (files == null) {
                    files = new ArrayList<File>();
                } else if (files.contains(jarFile)) continue;
                files.add(jarFile);
            }
        }
        return files != null ? files : Collections.emptyList();
    }

    @NonNull
    public List<File> findRuleJars(@NonNull Project project) {
        File lintJar;
        if (project.getDir().getPath().endsWith(".aar") && (lintJar = new File(project.getDir(), "lint.jar")).exists()) {
            return Collections.singletonList(lintJar);
        }
        return Collections.emptyList();
    }

    @Nullable
    public URLConnection openConnection(@NonNull URL url) throws IOException {
        return url.openConnection();
    }

    public void closeConnection(@NonNull URLConnection connection) throws IOException {
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        }
    }

    public boolean isProjectDirectory(@NonNull File dir) {
        return LintUtils.isManifestFolder(dir) || Project.isAospFrameworksProject(dir);
    }

    public boolean checkForSuppressComments() {
        return true;
    }

    public IssueRegistry addCustomLintRules(@NonNull IssueRegistry registry) {
        List<File> jarFiles = this.findGlobalRuleJars();
        if (!jarFiles.isEmpty()) {
            ArrayList registries = Lists.newArrayListWithExpectedSize((int)jarFiles.size());
            registries.add(registry);
            for (File jarFile : jarFiles) {
                try {
                    registries.add(JarFileIssueRegistry.get(this, jarFile));
                }
                catch (Throwable e) {
                    this.log(e, "Could not load custom rule jar file %1$s", jarFile);
                }
            }
            if (registries.size() > 1) {
                return new CompositeIssueRegistry(registries);
            }
        }
        return registry;
    }

    public boolean supportsProjectResources() {
        return false;
    }

    @Nullable
    public AbstractResourceRepository getProjectResources(Project project, boolean includeDependencies) {
        return null;
    }

    @NonNull
    public Location.Handle createResourceItemHandle(@NonNull ResourceItem item) {
        return new Location.ResourceItemHandle(item);
    }

    @NonNull
    public ResourceVisibilityLookup.Provider getResourceVisibilityProvider() {
        if (this.mResourceVisibility == null) {
            this.mResourceVisibility = new ResourceVisibilityLookup.Provider();
        }
        return this.mResourceVisibility;
    }

    protected static class ClassPathInfo {
        private final List<File> mClassFolders;
        private final List<File> mSourceFolders;
        private final List<File> mLibraries;
        private final List<File> mTestFolders;

        public ClassPathInfo(@NonNull List<File> sourceFolders, @NonNull List<File> classFolders, @NonNull List<File> libraries, @NonNull List<File> testFolders) {
            this.mSourceFolders = sourceFolders;
            this.mClassFolders = classFolders;
            this.mLibraries = libraries;
            this.mTestFolders = testFolders;
        }

        @NonNull
        public List<File> getSourceFolders() {
            return this.mSourceFolders;
        }

        @NonNull
        public List<File> getClassFolders() {
            return this.mClassFolders;
        }

        @NonNull
        public List<File> getLibraries() {
            return this.mLibraries;
        }

        public List<File> getTestSourceFolders() {
            return this.mTestFolders;
        }
    }
}

