/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.detector.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.google.common.annotations.Beta;

@Beta
public final class Category
implements Comparable<Category> {
    private final String mName;
    private final int mPriority;
    private final Category mParent;
    public static final Category LINT = Category.create("Lint", 110);
    public static final Category CORRECTNESS = Category.create("Correctness", 100);
    public static final Category SECURITY = Category.create("Security", 90);
    public static final Category PERFORMANCE = Category.create("Performance", 80);
    public static final Category USABILITY = Category.create("Usability", 70);
    public static final Category A11Y = Category.create("Accessibility", 60);
    public static final Category I18N = Category.create("Internationalization", 50);
    public static final Category RTL = Category.create("Bi-directional Text", 40);
    public static final Category ICONS = Category.create(USABILITY, "Icons", 73);
    public static final Category TYPOGRAPHY = Category.create(USABILITY, "Typography", 76);
    public static final Category MESSAGES = Category.create(CORRECTNESS, "Messages", 95);

    private Category(@Nullable Category parent, @NonNull String name2, int priority) {
        this.mParent = parent;
        this.mName = name2;
        this.mPriority = priority;
    }

    @NonNull
    public static Category create(@NonNull String name2, int priority) {
        return new Category(null, name2, priority);
    }

    @NonNull
    public static Category create(@Nullable Category parent, @NonNull String name2, int priority) {
        return new Category(parent, name2, priority);
    }

    public Category getParent() {
        return this.mParent;
    }

    public String getName() {
        return this.mName;
    }

    public String getFullName() {
        if (this.mParent != null) {
            return this.mParent.getFullName() + ':' + this.mName;
        }
        return this.mName;
    }

    @Override
    public int compareTo(Category other) {
        if (other.mPriority == this.mPriority) {
            if (this.mParent == other) {
                return 1;
            }
            if (other.mParent == this) {
                return -1;
            }
        }
        return other.mPriority - this.mPriority;
    }
}

