/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.ConfigureByMapAction;
import org.gradle.api.internal.artifacts.BaseRepositoryFactory;
import org.gradle.api.internal.artifacts.DefaultArtifactRepositoryContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepositoryHandler
extends DefaultArtifactRepositoryContainer
implements RepositoryHandler {
    public static final String DEFAULT_BINTRAY_JCENTER_REPO_NAME = "BintrayJCenter";
    public static final String BINTRAY_JCENTER_URL = "https://jcenter.bintray.com/";
    public static final String FLAT_DIR_DEFAULT_NAME = "flatDir";
    private static final String MAVEN_REPO_DEFAULT_NAME = "maven";
    private static final String IVY_REPO_DEFAULT_NAME = "ivy";
    private final BaseRepositoryFactory repositoryFactory;

    public DefaultRepositoryHandler(BaseRepositoryFactory repositoryFactory, Instantiator instantiator) {
        super(instantiator);
        this.repositoryFactory = repositoryFactory;
    }

    @Override
    public FlatDirectoryArtifactRepository flatDir(Action<? super FlatDirectoryArtifactRepository> action) {
        return this.addRepository(this.repositoryFactory.createFlatDirRepository(), FLAT_DIR_DEFAULT_NAME, action);
    }

    @Override
    public FlatDirectoryArtifactRepository flatDir(Closure configureClosure) {
        return this.flatDir((Action<? super FlatDirectoryArtifactRepository>)new ClosureBackedAction(configureClosure));
    }

    @Override
    public FlatDirectoryArtifactRepository flatDir(Map<String, ?> args) {
        HashMap modifiedArgs = new HashMap(args);
        if (modifiedArgs.containsKey("dirs")) {
            modifiedArgs.put("dirs", CollectionUtils.flattenCollections((Object[])new Object[]{modifiedArgs.get("dirs")}));
        }
        return this.flatDir(new ConfigureByMapAction(modifiedArgs));
    }

    @Override
    public MavenArtifactRepository mavenCentral() {
        return this.addRepository(this.repositoryFactory.createMavenCentralRepository(), "MavenRepo");
    }

    @Override
    public MavenArtifactRepository jcenter() {
        return this.addRepository(this.repositoryFactory.createJCenterRepository(), DEFAULT_BINTRAY_JCENTER_REPO_NAME);
    }

    @Override
    public MavenArtifactRepository jcenter(Action<? super MavenArtifactRepository> action) {
        return this.addRepository(this.repositoryFactory.createJCenterRepository(), DEFAULT_BINTRAY_JCENTER_REPO_NAME, action);
    }

    @Override
    public MavenArtifactRepository mavenCentral(Map<String, ?> args) {
        HashMap modifiedArgs = new HashMap(args);
        return this.addRepository(this.repositoryFactory.createMavenCentralRepository(), "MavenRepo", new ConfigureByMapAction(modifiedArgs));
    }

    @Override
    public MavenArtifactRepository mavenLocal() {
        return this.addRepository(this.repositoryFactory.createMavenLocalRepository(), "MavenLocal");
    }

    @Override
    public MavenArtifactRepository maven(Action<? super MavenArtifactRepository> action) {
        return this.addRepository(this.repositoryFactory.createMavenRepository(), MAVEN_REPO_DEFAULT_NAME, action);
    }

    @Override
    public MavenArtifactRepository maven(Closure closure) {
        return this.maven((Action<? super MavenArtifactRepository>)new ClosureBackedAction(closure));
    }

    @Override
    public IvyArtifactRepository ivy(Action<? super IvyArtifactRepository> action) {
        return this.addRepository(this.repositoryFactory.createIvyRepository(), IVY_REPO_DEFAULT_NAME, action);
    }

    @Override
    public IvyArtifactRepository ivy(Closure closure) {
        return this.ivy((Action<? super IvyArtifactRepository>)new ClosureBackedAction(closure));
    }
}

