/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.util.containers.WeakValueHashMap;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;

public class RemoteNativeMavenProjectHolder
implements NativeMavenProjectHolder {
    private static final WeakValueHashMap<Integer, RemoteNativeMavenProjectHolder> myMap = new WeakValueHashMap();
    private final MavenProject myMavenProject;

    public RemoteNativeMavenProjectHolder(@NotNull MavenProject mavenProject) {
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/server/RemoteNativeMavenProjectHolder", "<init>"));
        }
        this.myMavenProject = mavenProject;
        myMap.put((Object)this.getId(), (Object)this);
    }

    public int getId() {
        return System.identityHashCode(this);
    }

    @NotNull
    public static MavenProject findProjectById(int id) {
        RemoteNativeMavenProjectHolder result = (RemoteNativeMavenProjectHolder)myMap.get((Object)id);
        if (result == null) {
            throw new RuntimeException("NativeMavenProjectHolder not found for id: " + id);
        }
        MavenProject mavenProject = result.myMavenProject;
        if (mavenProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/RemoteNativeMavenProjectHolder", "findProjectById"));
        }
        return mavenProject;
    }
}

