/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.handler.mxCellMarker;
import com.mxgraph.swing.handler.mxGraphTransferHandler;
import com.mxgraph.swing.handler.mxMovePreview;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphTransferable;
import com.mxgraph.swing.util.mxMouseAdapter;
import com.mxgraph.swing.util.mxSwingConstants;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.TooManyListenersException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class mxGraphHandler
extends mxMouseAdapter
implements DropTargetListener {
    private static final long serialVersionUID = 3241109976696510225L;
    public static Cursor DEFAULT_CURSOR = new Cursor(0);
    public static Cursor MOVE_CURSOR = new Cursor(13);
    public static Cursor FOLD_CURSOR = new Cursor(12);
    protected mxGraphComponent graphComponent;
    protected boolean enabled = true;
    protected boolean cloneEnabled = true;
    protected boolean moveEnabled = true;
    protected boolean selectEnabled = true;
    protected boolean markerEnabled = true;
    protected boolean removeCellsFromParent = true;
    protected mxMovePreview movePreview;
    protected boolean livePreview = false;
    protected boolean imagePreview = true;
    protected boolean centerPreview = true;
    protected boolean keepOnTop = true;
    protected transient Object[] cells;
    protected transient ImageIcon dragImage;
    protected transient Point first;
    protected transient Object cell;
    protected transient Object initialCell;
    protected transient Object[] dragCells;
    protected transient mxCellMarker marker;
    protected transient boolean canImport;
    protected transient mxRectangle cellBounds;
    protected transient mxRectangle bbox;
    protected transient mxRectangle transferBounds;
    protected transient boolean visible = false;
    protected transient Rectangle previewBounds = null;
    protected transient boolean gridEnabledEvent = false;
    protected transient boolean constrainedEvent = false;
    protected transient DropTarget currentDropTarget = null;

    public mxGraphHandler(mxGraphComponent mxGraphComponent2) {
        this.graphComponent = mxGraphComponent2;
        this.marker = this.createMarker();
        this.movePreview = this.createMovePreview();
        mxGraphComponent2.addListener("afterPaint", new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object object, mxEventObject mxEventObject2) {
                Graphics graphics = (Graphics)mxEventObject2.getProperty("g");
                mxGraphHandler.this.paint(graphics);
            }
        });
        mxGraphComponent2.getGraphControl().addMouseListener(this);
        mxGraphComponent2.getGraphControl().addMouseMotionListener(this);
        this.installDragGestureHandler();
        this.installDropTargetHandler();
        mxGraphComponent2.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("transferHandler")) {
                    if (mxGraphHandler.this.currentDropTarget != null) {
                        mxGraphHandler.this.currentDropTarget.removeDropTargetListener(mxGraphHandler.this);
                    }
                    mxGraphHandler.this.installDropTargetHandler();
                }
            }
        });
        this.setVisible(false);
    }

    protected void installDragGestureHandler() {
        DragGestureListener dragGestureListener = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                mxGraphTransferable mxGraphTransferable2;
                TransferHandler transferHandler;
                if (mxGraphHandler.this.graphComponent.isDragEnabled() && mxGraphHandler.this.first != null && (transferHandler = mxGraphHandler.this.graphComponent.getTransferHandler()) instanceof mxGraphTransferHandler && (mxGraphTransferable2 = (mxGraphTransferable)((mxGraphTransferHandler)transferHandler).createTransferable(mxGraphHandler.this.graphComponent)) != null) {
                    dragGestureEvent.startDrag(null, mxSwingConstants.EMPTY_IMAGE, new Point(), mxGraphTransferable2, new DragSourceAdapter(){

                        @Override
                        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
                            ((mxGraphTransferHandler)transferHandler).exportDone(mxGraphHandler.this.graphComponent, mxGraphTransferable2, 0);
                            mxGraphHandler.this.first = null;
                        }
                    });
                }
            }
        };
        DragSource dragSource = new DragSource();
        dragSource.createDefaultDragGestureRecognizer(this.graphComponent.getGraphControl(), this.isCloneEnabled() ? 3 : 2, dragGestureListener);
    }

    protected void installDropTargetHandler() {
        DropTarget dropTarget = this.graphComponent.getDropTarget();
        try {
            if (dropTarget != null) {
                dropTarget.addDropTargetListener(this);
                this.currentDropTarget = dropTarget;
            }
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            if (this.previewBounds != null) {
                this.graphComponent.getGraphControl().repaint(this.previewBounds);
            }
        }
    }

    public void setPreviewBounds(Rectangle rectangle) {
        if (rectangle == null && this.previewBounds != null || rectangle != null && this.previewBounds == null || rectangle != null && this.previewBounds != null && !rectangle.equals(this.previewBounds)) {
            Rectangle rectangle2 = null;
            if (this.isVisible()) {
                rectangle2 = this.previewBounds;
                if (rectangle2 != null) {
                    rectangle2.add(rectangle);
                } else {
                    rectangle2 = rectangle;
                }
            }
            this.previewBounds = rectangle;
            if (rectangle2 != null) {
                this.graphComponent.getGraphControl().repaint(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 2, rectangle2.height + 2);
            }
        }
    }

    protected mxMovePreview createMovePreview() {
        return new mxMovePreview(this.graphComponent);
    }

    public mxMovePreview getMovePreview() {
        return this.movePreview;
    }

    protected mxCellMarker createMarker() {
        mxCellMarker mxCellMarker2 = new mxCellMarker(this.graphComponent, Color.BLUE){
            private static final long serialVersionUID = -8451338653189373347L;

            @Override
            public boolean isEnabled() {
                return this.graphComponent.getGraph().isDropEnabled();
            }

            @Override
            public Object getCell(MouseEvent mouseEvent) {
                boolean bl;
                mxIGraphModel mxIGraphModel2 = this.graphComponent.getGraph().getModel();
                TransferHandler transferHandler = this.graphComponent.getTransferHandler();
                boolean bl2 = transferHandler instanceof mxGraphTransferHandler && ((mxGraphTransferHandler)transferHandler).isLocalDrag();
                mxGraph mxGraph2 = this.graphComponent.getGraph();
                Object object = super.getCell(mouseEvent);
                Object[] objectArray = bl2 ? mxGraph2.getSelectionCells() : mxGraphHandler.this.dragCells;
                Object object2 = object = mxGraph2.getDropTarget(objectArray, mouseEvent.getPoint(), object);
                while (object2 != null) {
                    if (mxUtils.contains(objectArray, object2)) {
                        return null;
                    }
                    object2 = mxIGraphModel2.getParent(object2);
                }
                boolean bl3 = bl = this.graphComponent.isCloneEvent(mouseEvent) && mxGraphHandler.this.isCloneEnabled();
                if (bl2 && object != null && objectArray.length > 0 && !bl && mxGraph2.getModel().getParent(objectArray[0]) == object) {
                    object = null;
                }
                return object;
            }
        };
        mxCellMarker2.setSwimlaneContentEnabled(true);
        return mxCellMarker2;
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isCloneEnabled() {
        return this.cloneEnabled;
    }

    public void setCloneEnabled(boolean bl) {
        this.cloneEnabled = bl;
    }

    public boolean isMoveEnabled() {
        return this.moveEnabled;
    }

    public void setMoveEnabled(boolean bl) {
        this.moveEnabled = bl;
    }

    public boolean isMarkerEnabled() {
        return this.markerEnabled;
    }

    public void setMarkerEnabled(boolean bl) {
        this.markerEnabled = bl;
    }

    public mxCellMarker getMarker() {
        return this.marker;
    }

    public void setMarker(mxCellMarker mxCellMarker2) {
        this.marker = mxCellMarker2;
    }

    public boolean isSelectEnabled() {
        return this.selectEnabled;
    }

    public void setSelectEnabled(boolean bl) {
        this.selectEnabled = bl;
    }

    public boolean isRemoveCellsFromParent() {
        return this.removeCellsFromParent;
    }

    public void setRemoveCellsFromParent(boolean bl) {
        this.removeCellsFromParent = bl;
    }

    public boolean isLivePreview() {
        return this.livePreview;
    }

    public void setLivePreview(boolean bl) {
        this.livePreview = bl;
    }

    public boolean isImagePreview() {
        return this.imagePreview;
    }

    public void setImagePreview(boolean bl) {
        this.imagePreview = bl;
    }

    public boolean isCenterPreview() {
        return this.centerPreview;
    }

    public void setCenterPreview(boolean bl) {
        this.centerPreview = bl;
    }

    public void updateDragImage(Object[] objectArray) {
        BufferedImage bufferedImage;
        this.dragImage = null;
        if (objectArray != null && objectArray.length > 0 && (bufferedImage = mxCellRenderer.createBufferedImage(this.graphComponent.getGraph(), objectArray, this.graphComponent.getGraph().getView().getScale(), null, this.graphComponent.isAntiAlias(), null, this.graphComponent.getCanvas())) != null) {
            this.dragImage = new ImageIcon(bufferedImage);
            this.previewBounds.setSize(this.dragImage.getIconWidth(), this.dragImage.getIconHeight());
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !mouseEvent.isConsumed()) {
            Cursor cursor = this.getCursor(mouseEvent);
            if (cursor != null) {
                this.graphComponent.getGraphControl().setCursor(cursor);
                mouseEvent.consume();
            } else {
                this.graphComponent.getGraphControl().setCursor(DEFAULT_CURSOR);
            }
        }
    }

    protected Cursor getCursor(MouseEvent mouseEvent) {
        Object object;
        Cursor cursor = null;
        if (this.isMoveEnabled() && (object = this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY(), false)) != null) {
            if (this.graphComponent.isFoldingEnabled() && this.graphComponent.hitFoldingIcon(object, mouseEvent.getX(), mouseEvent.getY())) {
                cursor = FOLD_CURSOR;
            } else if (this.graphComponent.getGraph().isCellMovable(object)) {
                cursor = MOVE_CURSOR;
            }
        }
        return cursor;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl;
        JComponent jComponent = mxGraphHandler.getDropTarget(dropTargetDragEvent);
        TransferHandler transferHandler = jComponent.getTransferHandler();
        boolean bl2 = bl = transferHandler instanceof mxGraphTransferHandler && ((mxGraphTransferHandler)transferHandler).isLocalDrag();
        if (bl) {
            this.canImport = true;
        } else {
            boolean bl3 = this.canImport = this.graphComponent.isImportEnabled() && transferHandler.canImport(jComponent, dropTargetDragEvent.getCurrentDataFlavors());
        }
        if (this.canImport) {
            this.transferBounds = null;
            this.setVisible(false);
            try {
                Transferable transferable = dropTargetDragEvent.getTransferable();
                if (transferable.isDataFlavorSupported(mxGraphTransferable.dataFlavor)) {
                    mxGraphTransferable mxGraphTransferable2 = (mxGraphTransferable)transferable.getTransferData(mxGraphTransferable.dataFlavor);
                    this.dragCells = mxGraphTransferable2.getCells();
                    if (mxGraphTransferable2.getBounds() != null) {
                        mxGraph mxGraph2 = this.graphComponent.getGraph();
                        double d = mxGraph2.getView().getScale();
                        this.transferBounds = mxGraphTransferable2.getBounds();
                        int n = (int)Math.ceil((this.transferBounds.getWidth() + 1.0) * d);
                        int n2 = (int)Math.ceil((this.transferBounds.getHeight() + 1.0) * d);
                        this.setPreviewBounds(new Rectangle((int)this.transferBounds.getX(), (int)this.transferBounds.getY(), n, n2));
                        if (this.imagePreview) {
                            if (bl) {
                                if (!this.isLivePreview()) {
                                    this.updateDragImage(mxGraph2.getMovableCells(this.dragCells));
                                }
                            } else {
                                Object[] objectArray = this.graphComponent.getImportableCells(this.dragCells);
                                this.updateDragImage(objectArray);
                                if (objectArray == null || objectArray.length == 0) {
                                    this.canImport = false;
                                    dropTargetDragEvent.rejectDrag();
                                    return;
                                }
                            }
                        }
                        this.setVisible(true);
                    }
                }
                dropTargetDragEvent.acceptDrag(3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !mouseEvent.isConsumed() && !this.graphComponent.isForceMarqueeEvent(mouseEvent)) {
            this.initialCell = this.cell = this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY(), false);
            if (this.cell != null) {
                if (this.isSelectEnabled() && !this.graphComponent.getGraph().isCellSelected(this.cell)) {
                    this.graphComponent.selectCellForEvent(this.cell, mouseEvent);
                    this.cell = null;
                }
                if (this.isMoveEnabled() && !mouseEvent.isPopupTrigger()) {
                    this.start(mouseEvent);
                    mouseEvent.consume();
                }
            } else if (mouseEvent.isPopupTrigger()) {
                this.graphComponent.getGraph().clearSelection();
            }
        }
    }

    public Object[] getCells(Object object) {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        return mxGraph2.getMovableCells(mxGraph2.getSelectionCells());
    }

    public void start(MouseEvent mouseEvent) {
        if (this.isLivePreview()) {
            this.movePreview.start(mouseEvent, this.graphComponent.getGraph().getView().getState(this.initialCell));
        } else {
            mxGraph mxGraph2 = this.graphComponent.getGraph();
            this.cells = this.getCells(this.initialCell);
            this.cellBounds = mxGraph2.getView().getBounds(this.cells);
            if (this.cellBounds != null) {
                this.bbox = mxGraph2.getView().getBoundingBox(this.cells);
                Rectangle rectangle = this.cellBounds.getRectangle();
                ++rectangle.width;
                ++rectangle.height;
                this.setPreviewBounds(rectangle);
            }
        }
        this.first = mouseEvent.getPoint();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.canImport) {
            this.mouseDragged(this.createEvent(dropTargetDragEvent));
            mxGraphTransferHandler mxGraphTransferHandler2 = mxGraphHandler.getGraphTransferHandler(dropTargetDragEvent);
            if (mxGraphTransferHandler2 != null) {
                mxGraph mxGraph2 = this.graphComponent.getGraph();
                double d = mxGraph2.getView().getScale();
                Point point = SwingUtilities.convertPoint(this.graphComponent, dropTargetDragEvent.getLocation(), this.graphComponent.getGraphControl());
                point = this.graphComponent.snapScaledPoint(new mxPoint(point)).getPoint();
                mxGraphTransferHandler2.setLocation(new Point(point));
                int n = 0;
                int n2 = 0;
                if (this.centerPreview && this.transferBounds != null) {
                    n = (int)((long)n - Math.round(this.transferBounds.getWidth() * d / 2.0));
                    n2 = (int)((long)n2 - Math.round(this.transferBounds.getHeight() * d / 2.0));
                }
                mxGraphTransferHandler2.setOffset(new Point((int)mxGraph2.snap((double)n / d), (int)mxGraph2.snap((double)n2 / d)));
                point.translate(n, n2);
                if (this.transferBounds != null && this.dragImage != null) {
                    n = (int)Math.round(((double)(this.dragImage.getIconWidth() - 2) - this.transferBounds.getWidth() * d) / 2.0);
                    n2 = (int)Math.round(((double)(this.dragImage.getIconHeight() - 2) - this.transferBounds.getHeight() * d) / 2.0);
                    point.translate(-n, -n2);
                }
                if (!mxGraphTransferHandler2.isLocalDrag() && this.previewBounds != null) {
                    this.setPreviewBounds(new Rectangle(point, this.previewBounds.getSize()));
                }
            }
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public Point convertPoint(Point point) {
        point = SwingUtilities.convertPoint(this.graphComponent, point, this.graphComponent.getGraphControl());
        point.x -= this.graphComponent.getHorizontalScrollBar().getValue();
        point.y -= this.graphComponent.getVerticalScrollBar().getValue();
        return point;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.graphComponent.isAutoScroll()) {
            this.graphComponent.getGraphControl().scrollRectToVisible(new Rectangle(mouseEvent.getPoint()));
        }
        if (!mouseEvent.isConsumed()) {
            this.gridEnabledEvent = this.graphComponent.isGridEnabledEvent(mouseEvent);
            this.constrainedEvent = this.graphComponent.isConstrainedEvent(mouseEvent);
            if (this.constrainedEvent && this.first != null) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (Math.abs(mouseEvent.getX() - this.first.x) > Math.abs(mouseEvent.getY() - this.first.y)) {
                    n2 = this.first.y;
                } else {
                    n = this.first.x;
                }
                mouseEvent = new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n, n2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            }
            if (this.isVisible() && this.isMarkerEnabled()) {
                this.marker.process(mouseEvent);
            }
            if (this.first != null) {
                if (this.movePreview.isActive()) {
                    double d = mouseEvent.getX() - this.first.x;
                    double d2 = mouseEvent.getY() - this.first.y;
                    if (this.graphComponent.isGridEnabledEvent(mouseEvent)) {
                        mxGraph mxGraph2 = this.graphComponent.getGraph();
                        d = mxGraph2.snap(d);
                        d2 = mxGraph2.snap(d2);
                    }
                    boolean bl = this.isCloneEnabled() && this.graphComponent.isCloneEvent(mouseEvent);
                    this.movePreview.update(mouseEvent, d, d2, bl);
                    mouseEvent.consume();
                } else if (this.cellBounds != null) {
                    double d = mouseEvent.getX() - this.first.x;
                    double d3 = mouseEvent.getY() - this.first.y;
                    if (this.previewBounds != null) {
                        this.setPreviewBounds(new Rectangle(this.getPreviewLocation(mouseEvent, this.gridEnabledEvent), this.previewBounds.getSize()));
                    }
                    if (!this.isVisible() && this.graphComponent.isSignificant(d, d3)) {
                        if (this.imagePreview && this.dragImage == null && !this.graphComponent.isDragEnabled()) {
                            this.updateDragImage(this.cells);
                        }
                        this.setVisible(true);
                    }
                    mouseEvent.consume();
                }
            }
        }
    }

    protected Point getPreviewLocation(MouseEvent mouseEvent, boolean bl) {
        int n = 0;
        int n2 = 0;
        if (this.first != null && this.cellBounds != null) {
            mxGraph mxGraph2 = this.graphComponent.getGraph();
            double d = mxGraph2.getView().getScale();
            mxPoint mxPoint2 = mxGraph2.getView().getTranslate();
            double d2 = mouseEvent.getX() - this.first.x;
            double d3 = mouseEvent.getY() - this.first.y;
            double d4 = (this.cellBounds.getX() + d2) / d - mxPoint2.getX();
            double d5 = (this.cellBounds.getY() + d3) / d - mxPoint2.getY();
            if (bl) {
                d4 = mxGraph2.snap(d4);
                d5 = mxGraph2.snap(d5);
            }
            n = (int)Math.round((d4 + mxPoint2.getX()) * d) + (int)Math.round(this.bbox.getX()) - (int)Math.round(this.cellBounds.getX());
            n2 = (int)Math.round((d5 + mxPoint2.getY()) * d) + (int)Math.round(this.bbox.getY()) - (int)Math.round(this.cellBounds.getY());
        }
        return new Point(n, n2);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        mxGraphTransferHandler mxGraphTransferHandler2 = mxGraphHandler.getGraphTransferHandler(dropTargetEvent);
        if (mxGraphTransferHandler2 != null) {
            mxGraphTransferHandler2.setLocation(null);
        }
        this.dragCells = null;
        this.setVisible(false);
        this.marker.reset();
        this.reset();
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (this.canImport) {
            mxGraphTransferHandler mxGraphTransferHandler2 = mxGraphHandler.getGraphTransferHandler(dropTargetDropEvent);
            MouseEvent mouseEvent = this.createEvent(dropTargetDropEvent);
            if (mxGraphTransferHandler2 != null && !mxGraphTransferHandler2.isLocalDrag()) {
                mouseEvent.consume();
            }
            this.mouseReleased(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !mouseEvent.isConsumed()) {
            mxGraph mxGraph2 = this.graphComponent.getGraph();
            double d = 0.0;
            double d2 = 0.0;
            if (this.first != null && (this.cellBounds != null || this.movePreview.isActive())) {
                double d3 = mxGraph2.getView().getScale();
                mxPoint mxPoint2 = mxGraph2.getView().getTranslate();
                d = mouseEvent.getX() - this.first.x;
                d2 = mouseEvent.getY() - this.first.y;
                if (this.cellBounds != null) {
                    double d4 = (this.cellBounds.getX() + d) / d3 - mxPoint2.getX();
                    double d5 = (this.cellBounds.getY() + d2) / d3 - mxPoint2.getY();
                    if (this.gridEnabledEvent) {
                        d4 = mxGraph2.snap(d4);
                        d5 = mxGraph2.snap(d5);
                    }
                    double d6 = (d4 + mxPoint2.getX()) * d3 + this.bbox.getX() - this.cellBounds.getX();
                    double d7 = (d5 + mxPoint2.getY()) * d3 + this.bbox.getY() - this.cellBounds.getY();
                    d = Math.round((d6 - this.bbox.getX()) / d3);
                    d2 = Math.round((d7 - this.bbox.getY()) / d3);
                }
            }
            if (this.first == null || !this.graphComponent.isSignificant(mouseEvent.getX() - this.first.x, mouseEvent.getY() - this.first.y)) {
                if (!(this.cell == null || mouseEvent.isPopupTrigger() || !this.isSelectEnabled() || this.first == null && this.isMoveEnabled())) {
                    this.graphComponent.selectCellForEvent(this.cell, mouseEvent);
                }
                if (this.graphComponent.isFoldingEnabled() && this.graphComponent.hitFoldingIcon(this.initialCell, mouseEvent.getX(), mouseEvent.getY())) {
                    this.fold(this.initialCell);
                } else {
                    Object object = this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY(), this.graphComponent.isSwimlaneSelectionEnabled());
                    if (this.cell == null && this.first == null) {
                        if (object == null) {
                            if (!this.graphComponent.isToggleEvent(mouseEvent)) {
                                mxGraph2.clearSelection();
                            }
                        } else if (mxGraph2.isSwimlane(object) && this.graphComponent.getCanvas().hitSwimlaneContent(this.graphComponent, mxGraph2.getView().getState(object), mouseEvent.getX(), mouseEvent.getY())) {
                            this.graphComponent.selectCellForEvent(object, mouseEvent);
                        }
                    }
                    if (this.graphComponent.isFoldingEnabled() && this.graphComponent.hitFoldingIcon(object, mouseEvent.getX(), mouseEvent.getY())) {
                        this.fold(object);
                        mouseEvent.consume();
                    }
                }
            } else if (this.movePreview.isActive()) {
                boolean bl;
                Object[] objectArray;
                mxCellState mxCellState2;
                Object object;
                if (this.graphComponent.isConstrainedEvent(mouseEvent)) {
                    if (Math.abs(d) > Math.abs(d2)) {
                        d2 = 0.0;
                    } else {
                        d = 0.0;
                    }
                }
                Object object2 = object = (mxCellState2 = this.marker.getMarkedState()) != null ? mxCellState2.getCell() : null;
                if (object == null && this.isRemoveCellsFromParent() && this.shouldRemoveCellFromParent(mxGraph2.getModel().getParent(this.initialCell), this.cells, mouseEvent)) {
                    object = mxGraph2.getDefaultParent();
                }
                if (this.cells != (objectArray = this.movePreview.stop(true, mouseEvent, d, d2, bl = this.isCloneEnabled() && this.graphComponent.isCloneEvent(mouseEvent), object))) {
                    mxGraph2.setSelectionCells(objectArray);
                }
                mouseEvent.consume();
            } else if (this.isVisible()) {
                mxCellState mxCellState3;
                Object object;
                if (this.constrainedEvent) {
                    if (Math.abs(d) > Math.abs(d2)) {
                        d2 = 0.0;
                    } else {
                        d = 0.0;
                    }
                }
                Object object3 = object = (mxCellState3 = this.marker.getValidState()) != null ? mxCellState3.getCell() : null;
                if (mxGraph2.isSplitEnabled() && mxGraph2.isSplitTarget(object, this.cells)) {
                    mxGraph2.splitEdge(object, this.cells, d, d2);
                } else {
                    this.moveCells(this.cells, d, d2, object, mouseEvent);
                }
                mouseEvent.consume();
            }
        }
        this.reset();
    }

    protected void fold(Object object) {
        boolean bl = !this.graphComponent.getGraph().isCellCollapsed(object);
        this.graphComponent.getGraph().foldCells(bl, false, new Object[]{object});
    }

    public void reset() {
        if (this.movePreview.isActive()) {
            this.movePreview.stop(false, null, 0.0, 0.0, false, null);
        }
        this.setVisible(false);
        this.marker.reset();
        this.initialCell = null;
        this.dragCells = null;
        this.dragImage = null;
        this.cells = null;
        this.first = null;
        this.cell = null;
    }

    protected boolean shouldRemoveCellFromParent(Object object, Object[] objectArray, MouseEvent mouseEvent) {
        if (this.graphComponent.getGraph().getModel().isVertex(object)) {
            mxCellState mxCellState2 = this.graphComponent.getGraph().getView().getState(object);
            return mxCellState2 != null && !mxCellState2.contains(mouseEvent.getX(), mouseEvent.getY());
        }
        return false;
    }

    protected void moveCells(Object[] objectArray, double d, double d2, Object object, MouseEvent mouseEvent) {
        boolean bl;
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        boolean bl2 = bl = mouseEvent.isControlDown() && this.isCloneEnabled();
        if (bl) {
            objectArray = mxGraph2.getCloneableCells(objectArray);
        }
        if (objectArray.length > 0) {
            if (object == null && this.isRemoveCellsFromParent() && this.shouldRemoveCellFromParent(mxGraph2.getModel().getParent(this.initialCell), objectArray, mouseEvent)) {
                object = mxGraph2.getDefaultParent();
            }
            Object[] objectArray2 = mxGraph2.moveCells(objectArray, d, d2, bl, object, mouseEvent.getPoint());
            if (this.isSelectEnabled() && bl && objectArray2 != null && objectArray2.length == objectArray.length) {
                mxGraph2.setSelectionCells(objectArray2);
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.isVisible() && this.previewBounds != null) {
            if (this.dragImage != null) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                if (this.graphComponent.getPreviewAlpha() < 1.0f) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, this.graphComponent.getPreviewAlpha()));
                }
                graphics2D.drawImage(this.dragImage.getImage(), this.previewBounds.x, this.previewBounds.y, this.dragImage.getIconWidth(), this.dragImage.getIconHeight(), null);
                graphics2D.dispose();
            } else if (!this.imagePreview) {
                mxSwingConstants.PREVIEW_BORDER.paintBorder(this.graphComponent, graphics, this.previewBounds.x, this.previewBounds.y, this.previewBounds.width, this.previewBounds.height);
            }
        }
    }

    protected MouseEvent createEvent(DropTargetEvent dropTargetEvent) {
        JComponent jComponent = mxGraphHandler.getDropTarget(dropTargetEvent);
        Point point = null;
        int n = 0;
        if (dropTargetEvent instanceof DropTargetDropEvent) {
            point = ((DropTargetDropEvent)dropTargetEvent).getLocation();
            n = ((DropTargetDropEvent)dropTargetEvent).getDropAction();
        } else if (dropTargetEvent instanceof DropTargetDragEvent) {
            point = ((DropTargetDragEvent)dropTargetEvent).getLocation();
            n = ((DropTargetDragEvent)dropTargetEvent).getDropAction();
        }
        if (point != null) {
            point = this.convertPoint(point);
            Rectangle rectangle = this.graphComponent.getViewport().getViewRect();
            point.translate(rectangle.x, rectangle.y);
        }
        int n2 = n == 1 ? 2 : 0;
        return new MouseEvent(jComponent, 0, System.currentTimeMillis(), n2, point.x, point.y, 1, false, 1);
    }

    protected static final mxGraphTransferHandler getGraphTransferHandler(DropTargetEvent dropTargetEvent) {
        JComponent jComponent = mxGraphHandler.getDropTarget(dropTargetEvent);
        TransferHandler transferHandler = jComponent.getTransferHandler();
        if (transferHandler instanceof mxGraphTransferHandler) {
            return (mxGraphTransferHandler)transferHandler;
        }
        return null;
    }

    protected static final JComponent getDropTarget(DropTargetEvent dropTargetEvent) {
        return (JComponent)dropTargetEvent.getDropTargetContext().getComponent();
    }
}

