/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.JavaElementFinder;
import org.jetbrains.kotlin.asJava.KotlinLightTypeParameterListBuilder;
import org.jetbrains.kotlin.asJava.KtLightClass;
import org.jetbrains.kotlin.asJava.KtLightElement;
import org.jetbrains.kotlin.asJava.KtLightField;
import org.jetbrains.kotlin.asJava.KtLightMethod;
import org.jetbrains.kotlin.asJava.KtLightTypeParameter;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001.B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010!\u001a\u00020\"J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010$\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"J\u000e\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u0004\u0018\u00010\u001d2\u0006\u0010(\u001a\u00020)J\u0012\u0010*\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010,\u001a\u00020\nH\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/asJava/LightClassUtil;", "", "()V", "buildLightTypeParameterList", "Lcom/intellij/psi/PsiTypeParameterList;", "owner", "Lcom/intellij/psi/PsiTypeParameterListOwner;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "canGenerateLightClass", "", "extractPropertyAccessors", "Lorg/jetbrains/kotlin/asJava/LightClassUtil$PropertyAccessorsPsiMethods;", "ktDeclaration", "specialGetter", "Lcom/intellij/psi/PsiMethod;", "specialSetter", "findClass", "Lcom/intellij/psi/PsiClass;", "fqn", "Lorg/jetbrains/kotlin/name/FqName;", "stub", "Lcom/intellij/psi/stubs/StubElement;", "getLightClassAccessorMethod", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "getLightClassAccessorMethods", "", "getLightClassBackingField", "Lcom/intellij/psi/PsiField;", "getLightClassMethod", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getLightClassMethods", "getLightClassPropertyMethods", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getLightFieldForCompanionObject", "companionObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getPsiMethodWrapper", "getPsiMethodWrappers", "collectAll", "getWrappingClass", "PropertyAccessorsPsiMethods", "light-classes"})
public final class LightClassUtil {
    public static final LightClassUtil INSTANCE;

    @Nullable
    public final PsiClass findClass(@NotNull FqName fqn, @NotNull StubElement<?> stub) {
        Intrinsics.checkParameterIsNotNull((Object)fqn, (String)"fqn");
        Intrinsics.checkParameterIsNotNull(stub, (String)"stub");
        if (stub instanceof PsiClassStub && Comparing.equal((String)fqn.asString(), (String)((PsiClassStub)stub).getQualifiedName())) {
            return (PsiClass)((PsiClassStub)stub).getPsi();
        }
        if (stub instanceof PsiClassStub || stub instanceof PsiFileStub) {
            Iterator iterator2 = stub.getChildrenStubs().iterator();
            while (iterator2.hasNext()) {
                StubElement child;
                StubElement stubElement = child = (StubElement)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)stubElement, (String)"child");
                PsiClass answer = this.findClass(fqn, stubElement);
                if (answer == null) continue;
                return answer;
            }
        }
        return null;
    }

    @Nullable
    public final PsiMethod getLightClassAccessorMethod(@NotNull KtPropertyAccessor accessor) {
        Intrinsics.checkParameterIsNotNull((Object)accessor, (String)"accessor");
        return (PsiMethod)CollectionsKt.firstOrNull(this.getLightClassAccessorMethods(accessor));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PsiMethod> getLightClassAccessorMethods(@NotNull KtPropertyAccessor accessor) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)accessor, (String)"accessor");
        PsiElement $receiver$iv2 = accessor;
        KtProperty ktProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtProperty.class, (boolean)false);
        if (ktProperty == null) {
            return CollectionsKt.emptyList();
        }
        KtProperty property2 = ktProperty;
        List<PsiMethod> wrappers = this.getPsiMethodWrappers(property2, true);
        Iterable $i$f$getNonStrictParentOfType = wrappers;
        void var5_5 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PsiMethod wrapper2 = (PsiMethod)element$iv$iv;
            if (!(accessor.isGetter() && !JvmAbi.isSetterName(wrapper2.getName()) || accessor.isSetter() && JvmAbi.isSetterName(wrapper2.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final PsiField getLightFieldForCompanionObject(@NotNull KtClassOrObject companionObject) {
        Intrinsics.checkParameterIsNotNull((Object)companionObject, (String)"companionObject");
        PsiClass outerPsiClass = this.getWrappingClass(companionObject);
        if (outerPsiClass != null) {
            PsiField[] psiFieldArray = outerPsiClass.getFields();
            for (int i = 0; i < psiFieldArray.length; ++i) {
                PsiField fieldOfParent = psiFieldArray[i];
                if (!(fieldOfParent instanceof KtLightElement) || ((KtLightElement)fieldOfParent).getKotlinOrigin() != companionObject) continue;
                return fieldOfParent;
            }
        }
        return null;
    }

    @NotNull
    public final PropertyAccessorsPsiMethods getLightClassPropertyMethods(@NotNull KtProperty property2) {
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        KtPropertyAccessor getter = property2.getGetter();
        KtPropertyAccessor setter = property2.getSetter();
        PsiMethod getterWrapper = getter != null ? this.getLightClassAccessorMethod(getter) : (PsiMethod)null;
        PsiMethod setterWrapper = setter != null ? this.getLightClassAccessorMethod(setter) : (PsiMethod)null;
        return this.extractPropertyAccessors(property2, getterWrapper, setterWrapper);
    }

    @Nullable
    public final PsiField getLightClassBackingField(@NotNull KtDeclaration declaration) {
        KtLightClass containingLightClass;
        KtClass containingClass;
        KtClassOrObject origin;
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        PsiClass psiClass = this.getWrappingClass(declaration);
        if (psiClass == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        if (psiClass2 instanceof KtLightClass && (origin = (KtClassOrObject)((KtLightClass)psiClass2).getKotlinOrigin()) instanceof KtObjectDeclaration && ((KtObjectDeclaration)origin).isCompanion() && (containingClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)origin, KtClass.class)) != null && (containingLightClass = LightClassUtilsKt.toLightClass(containingClass)) != null) {
            psiClass2 = containingLightClass;
        }
        PsiField[] psiFieldArray = psiClass2.getFields();
        for (int i = 0; i < psiFieldArray.length; ++i) {
            PsiField field2 = psiFieldArray[i];
            if (!(field2 instanceof KtLightField) || (KtDeclaration)((KtLightField)field2).getKotlinOrigin() != declaration) continue;
            return field2;
        }
        return null;
    }

    @NotNull
    public final PropertyAccessorsPsiMethods getLightClassPropertyMethods(@NotNull KtParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        return this.extractPropertyAccessors(parameter, null, null);
    }

    @Nullable
    public final PsiMethod getLightClassMethod(@NotNull KtFunction function2) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        return this.getPsiMethodWrapper(function2);
    }

    @Nullable
    public final PsiMethod getLightClassMethod(@NotNull KtParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        return this.getPsiMethodWrapper(parameter);
    }

    @NotNull
    public final List<PsiMethod> getLightClassMethods(@NotNull KtFunction function2) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        return this.getPsiMethodWrappers(function2, true);
    }

    private final PsiMethod getPsiMethodWrapper(KtDeclaration declaration) {
        return (PsiMethod)CollectionsKt.firstOrNull(this.getPsiMethodWrappers(declaration, false));
    }

    private final List<PsiMethod> getPsiMethodWrappers(KtDeclaration declaration, boolean collectAll) {
        PsiClass psiClass = this.getWrappingClass(declaration);
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass psiClass2 = psiClass;
        SmartList methods2 = new SmartList();
        for (PsiMethod method : ArraysKt.asList((Object[])psiClass2.getMethods())) {
            try {
                if (!(method instanceof KtLightMethod) || (KtDeclaration)((KtLightMethod)method).getKotlinOrigin() != declaration) continue;
                methods2.add((Object)method);
                if (collectAll) continue;
                return (List)methods2;
            }
            catch (ProcessCanceledException e) {
                throw (Throwable)e;
            }
            catch (Throwable e) {
                throw (Throwable)new IllegalStateException("Error while wrapping declaration " + declaration.getName() + "Context\n:" + method, e);
            }
        }
        return (List)methods2;
    }

    private final PsiClass getWrappingClass(KtDeclaration declaration) {
        KtClassOrObject constructorClass;
        KtDeclaration declaration2 = declaration;
        if (declaration2 instanceof KtParameter && (constructorClass = KtPsiUtil.getClassIfParameterIsProperty((KtParameter)declaration2)) != null) {
            return LightClassUtilsKt.toLightClass(constructorClass);
        }
        if (declaration2 instanceof KtPropertyAccessor) {
            KtProperty ktProperty = ((KtPropertyAccessor)declaration2).getProperty();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktProperty, (String)"declaration.property");
            declaration2 = ktProperty;
        }
        if (declaration2 instanceof KtConstructor) {
            return LightClassUtilsKt.toLightClass(((KtConstructor)declaration2).getContainingClassOrObject());
        }
        PsiElement parent2 = declaration2.getParent();
        if (parent2 instanceof KtFile) {
            FqName fqName2 = JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)parent2);
            Project project = declaration2.getProject();
            return JavaElementFinder.getInstance(project).findClass(fqName2.asString(), GlobalSearchScope.allScope((Project)project));
        }
        if (parent2 instanceof KtClassBody) {
            boolean bl = ((KtClassBody)parent2).getParent() instanceof KtClassOrObject;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            PsiElement psiElement = ((KtClassBody)parent2).getParent();
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
            }
            return LightClassUtilsKt.toLightClass((KtClassOrObject)psiElement);
        }
        return null;
    }

    public final boolean canGenerateLightClass(@NotNull KtDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        return PsiTreeUtil.getParentOfType((PsiElement)declaration, (Class[])new Class[]{KtFunction.class, KtProperty.class}) == null;
    }

    private final PropertyAccessorsPsiMethods extractPropertyAccessors(KtDeclaration ktDeclaration, PsiMethod specialGetter, PsiMethod specialSetter) {
        PsiMethod getterWrapper = specialGetter;
        PsiMethod setterWrapper = specialSetter;
        ArrayList additionalAccessors = CollectionsKt.arrayListOf((Object[])new PsiMethod[0]);
        for (PsiMethod wrapper2 : this.getPsiMethodWrappers(ktDeclaration, true)) {
            if (JvmAbi.isSetterName(wrapper2.getName())) {
                if (setterWrapper == null || setterWrapper == specialSetter) {
                    setterWrapper = wrapper2;
                    continue;
                }
                additionalAccessors.add(wrapper2);
                continue;
            }
            if (getterWrapper == null || Intrinsics.areEqual((Object)getterWrapper, (Object)specialGetter)) {
                getterWrapper = wrapper2;
                continue;
            }
            additionalAccessors.add(wrapper2);
        }
        PsiField backingField = this.getLightClassBackingField(ktDeclaration);
        return new PropertyAccessorsPsiMethods(getterWrapper, setterWrapper, backingField, additionalAccessors);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PsiTypeParameterList buildLightTypeParameterList(@NotNull PsiTypeParameterListOwner owner, @NotNull KtDeclaration declaration) {
        List<KtTypeParameter> parameters2;
        int n;
        int n2;
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        PsiManager psiManager = owner.getManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"owner.manager");
        KotlinLightTypeParameterListBuilder builder = new KotlinLightTypeParameterListBuilder(psiManager);
        if (declaration instanceof KtTypeParameterListOwner && (n2 = 0) <= (n = (parameters2 = ((KtTypeParameterListOwner)declaration).getTypeParameters()).size() - 1)) {
            while (true) {
                void i;
                KtTypeParameter jetTypeParameter;
                String name2;
                String string;
                if ((string = (name2 = (jetTypeParameter = parameters2.get((int)i)).getName())) == null) {
                    string = "__no_name__";
                }
                String safeName = string;
                builder.addParameter(new KtLightTypeParameter(owner, (int)i, safeName));
                if (i == n) break;
                ++i;
            }
        }
        return (PsiTypeParameterList)builder;
    }

    private LightClassUtil() {
        INSTANCE = this;
    }

    static {
        new LightClassUtil();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010(\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0096\u0002R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/asJava/LightClassUtil$PropertyAccessorsPsiMethods;", "", "Lcom/intellij/psi/PsiMethod;", "getter", "setter", "backingField", "Lcom/intellij/psi/PsiField;", "additionalAccessors", "", "(Lcom/intellij/psi/PsiMethod;Lcom/intellij/psi/PsiMethod;Lcom/intellij/psi/PsiField;Ljava/util/List;)V", "allDeclarations", "Lcom/intellij/psi/PsiNamedElement;", "getAllDeclarations", "()Ljava/util/List;", "allMethods", "getBackingField", "()Lcom/intellij/psi/PsiField;", "getGetter", "()Lcom/intellij/psi/PsiMethod;", "getSetter", "iterator", "", "light-classes"})
    public static final class PropertyAccessorsPsiMethods
    implements Iterable<PsiMethod>,
    KMappedMarker {
        private final List<PsiMethod> allMethods;
        @NotNull
        private final List<PsiNamedElement> allDeclarations;
        @Nullable
        private final PsiMethod getter;
        @Nullable
        private final PsiMethod setter;
        @Nullable
        private final PsiField backingField;

        @NotNull
        public final List<PsiNamedElement> getAllDeclarations() {
            return this.allDeclarations;
        }

        @Override
        @NotNull
        public Iterator<PsiMethod> iterator() {
            return this.allMethods.iterator();
        }

        @Nullable
        public final PsiMethod getGetter() {
            return this.getter;
        }

        @Nullable
        public final PsiMethod getSetter() {
            return this.setter;
        }

        @Nullable
        public final PsiField getBackingField() {
            return this.backingField;
        }

        /*
         * WARNING - void declaration
         */
        public PropertyAccessorsPsiMethods(@Nullable PsiMethod getter, @Nullable PsiMethod setter, @Nullable PsiField backingField, @NotNull List<? extends PsiMethod> additionalAccessors) {
            PsiNamedElement[] $receiver$iv;
            Iterable elements$iv;
            Intrinsics.checkParameterIsNotNull(additionalAccessors, (String)"additionalAccessors");
            this.getter = getter;
            this.setter = setter;
            this.backingField = backingField;
            this.allMethods = CollectionsKt.arrayListOf((Object[])new PsiMethod[0]);
            PsiMethod[] psiMethodArray = new PsiMethod[]{this.getter, this.setter};
            ArraysKt.filterNotNullTo((Object[])((Object[])elements$iv), (Collection)this.allMethods);
            elements$iv = additionalAccessors;
            Collection collection = this.allMethods;
            for (Object t : $receiver$iv) {
                void destination$iv;
                if (!(t instanceof PsiMethod)) continue;
                destination$iv.add(t);
            }
            this.allDeclarations = CollectionsKt.arrayListOf((Object[])new PsiNamedElement[0]);
            $receiver$iv = new PsiNamedElement[]{(PsiNamedElement)this.getter, (PsiNamedElement)this.setter, (PsiNamedElement)this.backingField};
            ArraysKt.filterNotNullTo((Object[])((Object[])elements$iv), (Collection)this.allDeclarations);
            ((ArrayList)this.allDeclarations).addAll((Collection)additionalAccessors);
        }
    }
}

