/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.inline.SourceMapper;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class InlineAdapter
extends InstructionAdapter {
    private final SourceMapper sourceMapper;
    private final List<CatchBlock> blocks;
    private boolean isLambdaInlining;
    private int nextLocalIndex;
    private int nextLocalIndexBeforeInline;

    public InlineAdapter(@NotNull MethodVisitor mv, int localsSize, @NotNull SourceMapper sourceMapper) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/inline/InlineAdapter", "<init>"));
        }
        if (sourceMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceMapper", "org/jetbrains/kotlin/codegen/inline/InlineAdapter", "<init>"));
        }
        super(327680, mv);
        this.blocks = new ArrayList<CatchBlock>();
        this.isLambdaInlining = false;
        this.nextLocalIndex = 0;
        this.nextLocalIndexBeforeInline = -1;
        this.nextLocalIndex = localsSize;
        this.sourceMapper = sourceMapper;
    }

    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        this.updateIndex(var, 1);
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        this.updateIndex(var, InlineCodegenUtil.getLoadStoreArgSize(opcode));
    }

    private void updateIndex(int var, int varSize) {
        int newIndex = var + varSize;
        if (newIndex > this.nextLocalIndex) {
            this.nextLocalIndex = newIndex;
        }
    }

    public int getNextLocalIndex() {
        return this.nextLocalIndex;
    }

    public void setLambdaInlining(boolean isInlining) {
        this.isLambdaInlining = isInlining;
        if (isInlining) {
            this.nextLocalIndexBeforeInline = this.nextLocalIndex;
        } else {
            this.nextLocalIndex = this.nextLocalIndexBeforeInline;
        }
    }

    public void visitTryCatchBlock(@NotNull Label start, @NotNull Label end, @NotNull Label handler2, @Nullable String type2) {
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "org/jetbrains/kotlin/codegen/inline/InlineAdapter", "visitTryCatchBlock"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "org/jetbrains/kotlin/codegen/inline/InlineAdapter", "visitTryCatchBlock"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/kotlin/codegen/inline/InlineAdapter", "visitTryCatchBlock"));
        }
        if (!this.isLambdaInlining) {
            this.blocks.add(new CatchBlock(start, end, handler2, type2));
        } else {
            super.visitTryCatchBlock(start, end, handler2, type2);
        }
    }

    public void visitLineNumber(int line, @NotNull Label start) {
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "org/jetbrains/kotlin/codegen/inline/InlineAdapter", "visitLineNumber"));
        }
        if ((line = this.sourceMapper.mapLineNumber(line)) >= 0) {
            super.visitLineNumber(line, start);
        }
    }

    public void visitMaxs(int stack, int locals) {
        for (CatchBlock b : this.blocks) {
            super.visitTryCatchBlock(b.start, b.end, b.handler, b.type);
        }
        super.visitMaxs(stack, locals);
    }

    private static class CatchBlock {
        private final Label start;
        private final Label end;
        private final Label handler;
        private final String type;

        public CatchBlock(@NotNull Label start, @NotNull Label end, @NotNull Label handler2, @Nullable String type2) {
            if (start == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "org/jetbrains/kotlin/codegen/inline/InlineAdapter$CatchBlock", "<init>"));
            }
            if (end == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "org/jetbrains/kotlin/codegen/inline/InlineAdapter$CatchBlock", "<init>"));
            }
            if (handler2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/kotlin/codegen/inline/InlineAdapter$CatchBlock", "<init>"));
            }
            this.start = start;
            this.end = end;
            this.handler = handler2;
            this.type = type2;
        }
    }
}

