/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.when;

import com.google.common.collect.Maps;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.when.SwitchCodegen;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;

public class StringSwitchCodegen
extends SwitchCodegen {
    private static final String HASH_CODE_METHOD_DESC = Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]);
    private static final String EQUALS_METHOD_DESC = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(Object.class)});
    private final Map<Integer, List<Pair<String, Label>>> hashCodesToStringAndEntryLabel;
    private int tempVarIndex;

    public StringSwitchCodegen(@NotNull KtWhenExpression expression2, boolean isStatement, boolean isExhaustive, @NotNull ExpressionCodegen codegen) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/when/StringSwitchCodegen", "<init>"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/when/StringSwitchCodegen", "<init>"));
        }
        super(expression2, isStatement, isExhaustive, codegen);
        this.hashCodesToStringAndEntryLabel = Maps.newHashMap();
    }

    @Override
    protected void processConstant(@NotNull ConstantValue<?> constant, @NotNull Label entryLabel) {
        if (constant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constant", "org/jetbrains/kotlin/codegen/when/StringSwitchCodegen", "processConstant"));
        }
        if (entryLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryLabel", "org/jetbrains/kotlin/codegen/when/StringSwitchCodegen", "processConstant"));
        }
        assert (constant instanceof StringValue) : "guaranteed by usage contract";
        int hashCode = constant.hashCode();
        if (!this.transitionsTable.containsKey(hashCode)) {
            this.transitionsTable.put(hashCode, new Label());
            this.hashCodesToStringAndEntryLabel.put(hashCode, new ArrayList());
        }
        this.hashCodesToStringAndEntryLabel.get(hashCode).add((Pair<String, Label>)new Pair(((StringValue)constant).getValue(), (Object)entryLabel));
    }

    @Override
    public void generate() {
        super.generate();
        this.codegen.myFrameMap.leaveTemp(this.subjectType);
    }

    @Override
    protected void generateSubject() {
        this.tempVarIndex = this.codegen.myFrameMap.enterTemp(this.subjectType);
        super.generateSubject();
        this.v.store(this.tempVarIndex, this.subjectType);
        this.v.load(this.tempVarIndex, this.subjectType);
        this.generateNullCheckIfNeeded();
        this.v.invokevirtual(this.subjectType.getInternalName(), "hashCode", HASH_CODE_METHOD_DESC, false);
    }

    @Override
    protected void generateEntries() {
        for (int hashCode : this.hashCodesToStringAndEntryLabel.keySet()) {
            this.v.visitLabel((Label)this.transitionsTable.get(hashCode));
            List<Pair<String, Label>> items = this.hashCodesToStringAndEntryLabel.get(hashCode);
            Label nextLabel = null;
            for (int i = 0; i < items.size(); ++i) {
                if (nextLabel != null) {
                    this.v.visitLabel(nextLabel);
                }
                Pair<String, Label> stringAndEntryLabel = items.get(i);
                this.v.load(this.tempVarIndex, this.subjectType);
                this.v.aconst(stringAndEntryLabel.first);
                this.v.invokevirtual(this.subjectType.getInternalName(), "equals", EQUALS_METHOD_DESC, false);
                nextLabel = i + 1 < items.size() ? new Label() : this.defaultLabel;
                this.v.ifeq(nextLabel);
                this.v.goTo((Label)stringAndEntryLabel.getSecond());
            }
        }
        super.generateEntries();
    }
}

