/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ArrayUtil;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

public class HierarchyUtils {
    public static final Function1<PsiElement, Boolean> IS_CALL_HIERARCHY_ELEMENT = new Function1<PsiElement, Boolean>(){

        public Boolean invoke(@Nullable PsiElement input) {
            return input instanceof PsiMethod || input instanceof PsiClass || input instanceof KtFile || input instanceof KtNamedFunction || input instanceof KtSecondaryConstructor || input instanceof KtObjectDeclaration || input instanceof KtClass && !((KtClass)input).isInterface() || input instanceof KtProperty;
        }
    };

    public static PsiElement getCurrentElement(DataContext dataContext, Project project) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file2 == null) {
                return null;
            }
            if (!ProjectRootsUtil.isInProjectOrLibSource((PsiElement)file2)) {
                return null;
            }
            return TargetElementUtilBase.findTargetElement((Editor)editor, (int)TargetElementUtilBase.getInstance().getAllAccepted());
        }
        return (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
    }

    public static PsiElement getCallHierarchyElement(PsiElement element2) {
        return PsiUtilsKt.getParentOfTypesAndPredicate(element2, false, ArrayUtil.EMPTY_CLASS_ARRAY, IS_CALL_HIERARCHY_ELEMENT);
    }
}

