/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.branchedTransformations.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.BranchedFoldingUtils;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtReturnExpression;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/branchedTransformations/intentions/FoldIfToReturnIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea"})
public final class FoldIfToReturnIntention
extends SelfTargetingRangeIntention<KtIfExpression> {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtIfExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (BranchedFoldingUtils.INSTANCE.getFoldableBranchedReturn(element2.getThen()) == null) {
            return null;
        }
        if (BranchedFoldingUtils.INSTANCE.getFoldableBranchedReturn(element2.getElse()) == null) {
            return null;
        }
        return element2.getIfKeyword().getTextRange();
    }

    @Override
    public void applyTo(@NotNull KtIfExpression element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtExpression ktExpression = element2.getThen();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtReturnExpression ktReturnExpression = BranchedFoldingUtils.INSTANCE.getFoldableBranchedReturn(ktExpression);
        if (ktReturnExpression == null) {
            Intrinsics.throwNpe();
        }
        KtReturnExpression thenReturn = ktReturnExpression;
        KtExpression ktExpression2 = element2.getElse();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        KtReturnExpression ktReturnExpression2 = BranchedFoldingUtils.INSTANCE.getFoldableBranchedReturn(ktExpression2);
        if (ktReturnExpression2 == null) {
            Intrinsics.throwNpe();
        }
        KtReturnExpression elseReturn = ktReturnExpression2;
        KtExpression ktExpression3 = thenReturn.getReturnedExpression();
        if (ktExpression3 == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement = (PsiElement)ktExpression3;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"thenReturn.returnedExpression!!");
        thenReturn.replace(psiElement);
        KtExpression ktExpression4 = elseReturn.getReturnedExpression();
        if (ktExpression4 == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement2 = (PsiElement)ktExpression4;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"elseReturn.returnedExpression!!");
        elseReturn.replace(psiElement2);
        element2.replace((PsiElement)CreateByPatternKt.createExpressionByPattern(KtPsiFactoryKt.KtPsiFactory((PsiElement)element2), "return $0", element2));
    }

    public FoldIfToReturnIntention() {
        super(KtIfExpression.class, "Replace 'if' expression with return", null, 4, null);
    }
}

