/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectView;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.kotlin.idea.projectView.KtClassOrObjectTreeNode;
import org.jetbrains.kotlin.idea.projectView.KtDeclarationTreeNode;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;

public final class KotlinProjectViewUtil {
    private KotlinProjectViewUtil() {
    }

    public static Collection<AbstractTreeNode> getClassOrObjectChildren(KtClassOrObject classOrObject, Project project, ViewSettings settings) {
        if (classOrObject != null && settings.isShowMembers()) {
            ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
            List<KtDeclaration> declarations2 = classOrObject.getDeclarations();
            for (KtDeclaration declaration : declarations2) {
                if (declaration instanceof KtClassOrObject) {
                    result2.add((AbstractTreeNode)new KtClassOrObjectTreeNode(project, (KtClassOrObject)declaration, settings));
                    continue;
                }
                result2.add((AbstractTreeNode)new KtDeclarationTreeNode(project, declaration, settings));
            }
            return result2;
        }
        return Collections.emptyList();
    }

    public static boolean canRepresentPsiElement(PsiElement value2, Object element2, ViewSettings settings) {
        PsiFile elementFile;
        if (value2 == null || !value2.isValid()) {
            return false;
        }
        PsiFile file2 = value2.getContainingFile();
        if (file2 != null && (file2 == element2 || file2.getVirtualFile() == element2)) {
            return true;
        }
        if (value2 == element2) {
            return true;
        }
        if (!settings.isShowMembers() && element2 instanceof PsiElement && ((PsiElement)element2).getContainingFile() != null && (elementFile = ((PsiElement)element2).getContainingFile()) != null && file2 != null) {
            return elementFile.equals(file2);
        }
        return false;
    }
}

