/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Query;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.UserDataProperty;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J&\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J6\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00170\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\f\u0010 \u001a\u00020\u000f*\u00020\u0005H\u0004R>\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004*\u00020\u00072\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048D@DX\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinPsiProcessor;", "Lcom/intellij/refactoring/rename/RenamePsiElementProcessor;", "()V", "<set-?>", "", "Lcom/intellij/usageView/UsageInfo;", "ambiguousImportUsages", "Lcom/intellij/psi/PsiElement;", "getAmbiguousImportUsages", "(Lcom/intellij/psi/PsiElement;)Ljava/util/List;", "setAmbiguousImportUsages", "(Lcom/intellij/psi/PsiElement;Ljava/util/List;)V", "ambiguousImportUsages$delegate", "Lorg/jetbrains/kotlin/psi/UserDataProperty;", "canProcessElement", "", "element", "findReferences", "", "Lcom/intellij/psi/PsiReference;", "getPostRenameCallback", "Ljava/lang/Runnable;", "newName", "", "elementListener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "prepareRenaming", "", "allRenames", "", "scope", "Lcom/intellij/psi/search/SearchScope;", "isAmbiguousImportUsage", "idea"})
public abstract class RenameKotlinPsiProcessor
extends RenamePsiElementProcessor {
    @Nullable
    private final UserDataProperty ambiguousImportUsages$delegate;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    public boolean canProcessElement(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return element2 instanceof KtNamedDeclaration;
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        SmartList references2 = new SmartList(super.findReferences(element2));
        if (element2 instanceof KtNamedFunction || element2 instanceof KtProperty && !((KtProperty)element2).isLocal() || element2 instanceof KtParameter && ((KtParameter)element2).hasValOrVar()) {
            Iterable $receiver$iv = LightClassUtilsKt.toLightMethods(element2);
            for (Object element$iv : $receiver$iv) {
                PsiMethod it = (PsiMethod)element$iv;
                Query query = MethodReferencesSearch.search((PsiMethod)it);
                Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"MethodReferencesSearch.search(it)");
                Iterable list$iv = (Iterable)query;
                CollectionsKt.addAll((Collection)references2, (Iterable)list$iv);
            }
        }
        return references2;
    }

    public void prepareRenaming(@NotNull PsiElement element2, @Nullable String newName2, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull(allRenames, (String)"allRenames");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        if (newName2 != null && !KotlinNameSuggester.INSTANCE.isIdentifier(newName2)) {
            Map<PsiElement, String> map2 = allRenames;
            String string = UtilsKt.quoteIfNeeded(newName2);
            map2.put(element2, string);
        }
    }

    @Nullable
    protected final List<UsageInfo> getAmbiguousImportUsages(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (List)this.ambiguousImportUsages$delegate.getValue((UserDataHolder)$receiver, $$delegatedProperties[0]);
    }

    protected final void setAmbiguousImportUsages(@NotNull PsiElement $receiver, @Nullable List<? extends UsageInfo> list2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        this.ambiguousImportUsages$delegate.setValue((UserDataHolder)$receiver, $$delegatedProperties[0], list2);
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean isAmbiguousImportUsage(@NotNull UsageInfo $receiver) {
        boolean bl;
        PsiPolyVariantReference ref;
        block3: {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            PsiReference psiReference = $receiver.getReference();
            if (!(psiReference instanceof PsiPolyVariantReference)) {
                psiReference = null;
            }
            PsiPolyVariantReference psiPolyVariantReference = (PsiPolyVariantReference)psiReference;
            if (psiPolyVariantReference == null) {
                return false;
            }
            ref = psiPolyVariantReference;
            PsiElement refElement = ref.getElement();
            Sequence<PsiElement> sequence2 = PsiUtilsKt.getParents(refElement);
            for (Object element$iv : $receiver$iv) {
                PsiElement it = (PsiElement)element$iv;
                if (!(it instanceof KtImportDirective && !((KtImportDirective)it).isAllUnder() || it instanceof PsiImportStaticStatement && !((PsiImportStaticStatement)it).isOnDemand())) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl && ((Object[])ref.multiResolve(false)).length > 1;
    }

    @Nullable
    public Runnable getPostRenameCallback(@NotNull PsiElement element2, @Nullable String newName2, @Nullable RefactoringElementListener elementListener) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (newName2 == null) {
            return null;
        }
        return new Runnable(this, element2, newName2){
            final /* synthetic */ RenameKotlinPsiProcessor this$0;
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ String $newName;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                List<UsageInfo> list2 = this.this$0.getAmbiguousImportUsages(this.$element);
                if (list2 != null) {
                    Iterable $receiver$iv = list2;
                    for (T element$iv : $receiver$iv) {
                        boolean bl;
                        FqName newFqName;
                        KtImportDirective importDirective;
                        block8: {
                            void $receiver$iv2;
                            FqName fqName2;
                            void $receiver$iv3;
                            PsiPolyVariantReference ref;
                            UsageInfo it = (UsageInfo)element$iv;
                            PsiReference psiReference = it.getReference();
                            if (!(psiReference instanceof PsiPolyVariantReference)) {
                                psiReference = null;
                            }
                            if ((PsiPolyVariantReference)psiReference == null) {
                                continue;
                            }
                            PsiElement psiElement = (PsiElement)ref.multiResolve(false);
                            if (((Object[])psiElement).length == 0) {
                                ref.handleElementRename(this.$newName);
                                continue;
                            }
                            Object object = ref.getElement();
                            if (object == null) continue;
                            psiElement = object;
                            object = (KtImportDirective)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv3, KtImportDirective.class, (boolean)true);
                            if (object == null) continue;
                            psiElement = object;
                            importDirective = (KtImportDirective)psiElement;
                            if (importDirective.getImportedFqName() == null) {
                                Intrinsics.throwNpe();
                            }
                            newFqName = fqName2.parent().child(Name.identifier(this.$newName));
                            PsiElement psiElement2 = importDirective.getParent();
                            if (psiElement2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtImportList");
                            }
                            KtImportList importList = (KtImportList)psiElement2;
                            Iterable iterable = importList.getImports();
                            for (T element$iv2 : $receiver$iv2) {
                                KtImportDirective it2 = (KtImportDirective)element$iv2;
                                if (!Intrinsics.areEqual((Object)it2.getImportedFqName(), (Object)newFqName)) continue;
                                bl = false;
                                break block8;
                            }
                            bl = true;
                        }
                        if (!bl) continue;
                        KtImportDirective newImportDirective = KtPsiFactoryKt.KtPsiFactory(this.$element).createImportDirective(new ImportPath(newFqName, false));
                        importDirective.getParent().addAfter((PsiElement)newImportDirective, (PsiElement)importDirective);
                    }
                }
                this.this$0.setAmbiguousImportUsages(this.$element, null);
            }
            {
                this.this$0 = renameKotlinPsiProcessor;
                this.$element = psiElement;
                this.$newName = string;
            }
        };
    }

    public RenameKotlinPsiProcessor() {
        Key key = Key.create((String)"AMBIGUOUS_IMPORT_USAGES");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create(\"AMBIGUOUS_IMPORT_USAGES\")");
        this.ambiguousImportUsages$delegate = new UserDataProperty(key);
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty2((MutablePropertyReference2)new MutablePropertyReference2Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(RenameKotlinPsiProcessor.class), "ambiguousImportUsages", "getAmbiguousImportUsages(Lcom/intellij/psi/PsiElement;)Ljava/util/List;"))};
    }
}

