/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.structureView.KotlinStructureElementPresentation;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParameter;

public class KotlinStructureViewElement
implements StructureViewTreeElement,
Queryable {
    private final NavigatablePsiElement element;
    private final boolean isInherited;
    private KotlinStructureElementPresentation presentation;

    public KotlinStructureViewElement(@NotNull NavigatablePsiElement element2, @NotNull DeclarationDescriptor descriptor2, boolean isInherited) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/structureView/KotlinStructureViewElement", "<init>"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/structureView/KotlinStructureViewElement", "<init>"));
        }
        this.element = element2;
        this.isInherited = isInherited;
        if (!(element2 instanceof KtElement)) {
            this.presentation = new KotlinStructureElementPresentation(this.isInherited(), element2, descriptor2);
        }
    }

    public KotlinStructureViewElement(@NotNull NavigatablePsiElement element2, boolean isInherited) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/structureView/KotlinStructureViewElement", "<init>"));
        }
        this.element = element2;
        this.isInherited = isInherited;
    }

    public KotlinStructureViewElement(@NotNull KtFile fileElement) {
        if (fileElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileElement", "org/jetbrains/kotlin/idea/structureView/KotlinStructureViewElement", "<init>"));
        }
        this.element = fileElement;
        this.isInherited = false;
    }

    @NotNull
    public NavigatablePsiElement getElement() {
        NavigatablePsiElement navigatablePsiElement = this.element;
        if (navigatablePsiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/structureView/KotlinStructureViewElement", "getElement"));
        }
        return navigatablePsiElement;
    }

    public Object getValue() {
        return this.element;
    }

    public void navigate(boolean requestFocus) {
        this.element.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.element.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.element.canNavigateToSource();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        if (this.presentation == null) {
            this.presentation = new KotlinStructureElementPresentation(this.isInherited(), this.element, this.getDescriptor());
        }
        KotlinStructureElementPresentation kotlinStructureElementPresentation = this.presentation;
        if (kotlinStructureElementPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/structureView/KotlinStructureViewElement", "getPresentation"));
        }
        return kotlinStructureElementPresentation;
    }

    @NotNull
    public TreeElement[] getChildren() {
        List<KtDeclaration> childrenDeclarations = this.getChildrenDeclarations();
        TreeElement[] treeElementArray = (TreeElement[])ArrayUtil.toObjectArray((Collection)ContainerUtil.map(childrenDeclarations, (Function)new Function<KtDeclaration, TreeElement>(){

            public TreeElement fun(KtDeclaration declaration) {
                return new KotlinStructureViewElement(declaration, false);
            }
        }), TreeElement.class);
        if (treeElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/structureView/KotlinStructureViewElement", "getChildren"));
        }
        return treeElementArray;
    }

    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/idea/structureView/KotlinStructureViewElement", "putInfo"));
        }
        info.put("text", this.getPresentation().getPresentableText());
        info.put("location", this.getPresentation().getLocationString());
    }

    public boolean isInherited() {
        return this.isInherited;
    }

    @Nullable
    private DeclarationDescriptor getDescriptor() {
        if (!this.element.isValid() || !(this.element instanceof KtDeclaration)) {
            return null;
        }
        final KtDeclaration declaration = (KtDeclaration)this.element;
        if (declaration instanceof KtAnonymousInitializer) {
            return null;
        }
        return (DeclarationDescriptor)ApplicationManager.getApplication().runReadAction((Computable)new Computable<DeclarationDescriptor>(){

            public DeclarationDescriptor compute() {
                if (!DumbService.isDumb((Project)KotlinStructureViewElement.this.element.getProject())) {
                    return ResolutionUtils.resolveToDescriptor(declaration);
                }
                return null;
            }
        });
    }

    @NotNull
    private List<KtDeclaration> getChildrenDeclarations() {
        if (this.element instanceof KtFile) {
            KtFile jetFile = (KtFile)this.element;
            List<KtDeclaration> list2 = jetFile.getDeclarations();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/structureView/KotlinStructureViewElement", "getChildrenDeclarations"));
            }
            return list2;
        }
        if (this.element instanceof KtClass) {
            KtClass ktClass = (KtClass)this.element;
            ArrayList<KtDeclaration> declarations2 = new ArrayList<KtDeclaration>();
            for (KtParameter parameter : ktClass.getPrimaryConstructorParameters()) {
                if (!parameter.hasValOrVar()) continue;
                declarations2.add(parameter);
            }
            declarations2.addAll(ktClass.getDeclarations());
            ArrayList<KtDeclaration> arrayList = declarations2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/structureView/KotlinStructureViewElement", "getChildrenDeclarations"));
            }
            return arrayList;
        }
        if (this.element instanceof KtClassOrObject) {
            List<KtDeclaration> list3 = ((KtClassOrObject)this.element).getDeclarations();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/structureView/KotlinStructureViewElement", "getChildrenDeclarations"));
            }
            return list3;
        }
        List<KtDeclaration> list4 = Collections.emptyList();
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/structureView/KotlinStructureViewElement", "getChildrenDeclarations"));
        }
        return list4;
    }
}

