/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/j2k/AfterConversionPass;", "", "project", "Lcom/intellij/openapi/project/Project;", "postProcessor", "Lorg/jetbrains/kotlin/j2k/PostProcessor;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/j2k/PostProcessor;)V", "getPostProcessor", "()Lorg/jetbrains/kotlin/j2k/PostProcessor;", "getProject", "()Lcom/intellij/openapi/project/Project;", "run", "", "kotlinFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "j2k"})
public final class AfterConversionPass {
    @NotNull
    private final Project project;
    @NotNull
    private final PostProcessor postProcessor;

    public final void run(@NotNull KtFile kotlinFile, @Nullable TextRange range) {
        RangeMarker rangeMarker;
        Intrinsics.checkParameterIsNotNull((Object)kotlinFile, (String)"kotlinFile");
        if (range != null) {
            Document document = kotlinFile.getViewProvider().getDocument();
            if (document == null) {
                Intrinsics.throwNpe();
            }
            Document document2 = document;
            RangeMarker marker = document2.createRangeMarker(range.getStartOffset(), range.getEndOffset());
            marker.setGreedyToLeft(true);
            marker.setGreedyToRight(true);
            rangeMarker = marker;
        } else {
            rangeMarker = null;
        }
        RangeMarker rangeMarker2 = rangeMarker;
        this.postProcessor.doAdditionalProcessing(kotlinFile, rangeMarker2);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final PostProcessor getPostProcessor() {
        return this.postProcessor;
    }

    public AfterConversionPass(@NotNull Project project, @NotNull PostProcessor postProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)postProcessor, (String)"postProcessor");
        this.project = project;
        this.postProcessor = postProcessor;
    }
}

