/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.protobuf;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.protobuf.AbstractMessageLite;
import org.jetbrains.kotlin.protobuf.ByteString;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.CodedOutputStream;
import org.jetbrains.kotlin.protobuf.Descriptors;
import org.jetbrains.kotlin.protobuf.ExtensionRegistry;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;
import org.jetbrains.kotlin.protobuf.FieldSet;
import org.jetbrains.kotlin.protobuf.GeneratedMessage;
import org.jetbrains.kotlin.protobuf.Internal;
import org.jetbrains.kotlin.protobuf.InvalidProtocolBufferException;
import org.jetbrains.kotlin.protobuf.LazyField;
import org.jetbrains.kotlin.protobuf.Message;
import org.jetbrains.kotlin.protobuf.MessageOrBuilder;
import org.jetbrains.kotlin.protobuf.TextFormat;
import org.jetbrains.kotlin.protobuf.UninitializedMessageException;
import org.jetbrains.kotlin.protobuf.UnknownFieldSet;
import org.jetbrains.kotlin.protobuf.WireFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessage
extends AbstractMessageLite
implements Message {
    private int memoizedSize = -1;

    @Override
    public boolean isInitialized() {
        for (Descriptors.FieldDescriptor fieldDescriptor : this.getDescriptorForType().getFields()) {
            if (!fieldDescriptor.isRequired() || this.hasField(fieldDescriptor)) continue;
            return false;
        }
        for (Map.Entry entry : this.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor field3 = (Descriptors.FieldDescriptor)entry.getKey();
            if (field3.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
            if (field3.isRepeated()) {
                for (Message element2 : (List)entry.getValue()) {
                    if (element2.isInitialized()) continue;
                    return false;
                }
                continue;
            }
            if (((Message)entry.getValue()).isInitialized()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> findInitializationErrors() {
        return Builder.findMissingFields(this);
    }

    @Override
    public String getInitializationErrorString() {
        return AbstractMessage.delimitWithCommas(this.findInitializationErrors());
    }

    private static String delimitWithCommas(List<String> parts) {
        StringBuilder result2 = new StringBuilder();
        for (String part : parts) {
            if (result2.length() > 0) {
                result2.append(", ");
            }
            result2.append(part);
        }
        return result2.toString();
    }

    @Override
    public final String toString() {
        return TextFormat.printToString(this);
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        boolean isMessageSet = this.getDescriptorForType().getOptions().getMessageSetWireFormat();
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : this.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor field2 = entry.getKey();
            Object value2 = entry.getValue();
            if (isMessageSet && field2.isExtension() && field2.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && !field2.isRepeated()) {
                output.writeMessageSetExtension(field2.getNumber(), (Message)value2);
                continue;
            }
            FieldSet.writeField(field2, value2, output);
        }
        UnknownFieldSet unknownFields = this.getUnknownFields();
        if (isMessageSet) {
            unknownFields.writeAsMessageSetTo(output);
        } else {
            unknownFields.writeTo(output);
        }
    }

    @Override
    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        boolean isMessageSet = this.getDescriptorForType().getOptions().getMessageSetWireFormat();
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : this.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor field2 = entry.getKey();
            Object value2 = entry.getValue();
            if (isMessageSet && field2.isExtension() && field2.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && !field2.isRepeated()) {
                size += CodedOutputStream.computeMessageSetExtensionSize(field2.getNumber(), (Message)value2);
                continue;
            }
            size += FieldSet.computeFieldSize(field2, value2);
        }
        UnknownFieldSet unknownFields = this.getUnknownFields();
        size = isMessageSet ? (size += unknownFields.getSerializedSizeAsMessageSet()) : (size += unknownFields.getSerializedSize());
        this.memoizedSize = size;
        return size;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Message)) {
            return false;
        }
        Message otherMessage = (Message)other;
        if (this.getDescriptorForType() != otherMessage.getDescriptorForType()) {
            return false;
        }
        return this.getAllFields().equals(otherMessage.getAllFields()) && this.getUnknownFields().equals(otherMessage.getUnknownFields());
    }

    @Override
    public int hashCode() {
        int hash = 41;
        hash = 19 * hash + this.getDescriptorForType().hashCode();
        hash = this.hashFields(hash, this.getAllFields());
        hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    protected int hashFields(int hash, Map<Descriptors.FieldDescriptor, Object> map2) {
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : map2.entrySet()) {
            Descriptors.FieldDescriptor field2 = entry.getKey();
            Object value2 = entry.getValue();
            hash = 37 * hash + field2.getNumber();
            if (field2.getType() != Descriptors.FieldDescriptor.Type.ENUM) {
                hash = 53 * hash + value2.hashCode();
                continue;
            }
            if (field2.isRepeated()) {
                List list2 = (List)value2;
                hash = 53 * hash + AbstractMessage.hashEnumList(list2);
                continue;
            }
            hash = 53 * hash + AbstractMessage.hashEnum((Internal.EnumLite)value2);
        }
        return hash;
    }

    protected static int hashLong(long n) {
        return (int)(n ^ n >>> 32);
    }

    protected static int hashBoolean(boolean b) {
        return b ? 1231 : 1237;
    }

    @Override
    UninitializedMessageException newUninitializedMessageException() {
        return Builder.newUninitializedMessageException(this);
    }

    protected static int hashEnum(Internal.EnumLite e) {
        return e.getNumber();
    }

    protected static int hashEnumList(List<? extends Internal.EnumLite> list2) {
        int hash = 1;
        for (Internal.EnumLite enumLite : list2) {
            hash = 31 * hash + AbstractMessage.hashEnum(enumLite);
        }
        return hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Builder<BuilderType extends Builder>
    extends AbstractMessageLite.Builder<BuilderType>
    implements Message.Builder {
        @Override
        public abstract BuilderType clone();

        public BuilderType clear() {
            for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : this.getAllFields().entrySet()) {
                this.clearField(entry.getKey());
            }
            return (BuilderType)this;
        }

        @Override
        public List<String> findInitializationErrors() {
            return Builder.findMissingFields(this);
        }

        @Override
        public String getInitializationErrorString() {
            return AbstractMessage.delimitWithCommas(this.findInitializationErrors());
        }

        public BuilderType mergeFrom(Message other) {
            if (other.getDescriptorForType() != this.getDescriptorForType()) {
                throw new IllegalArgumentException("mergeFrom(Message) can only merge messages of the same type.");
            }
            for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : other.getAllFields().entrySet()) {
                Descriptors.FieldDescriptor field2 = entry.getKey();
                if (field2.isRepeated()) {
                    for (Object element2 : (List)entry.getValue()) {
                        this.addRepeatedField(field2, element2);
                    }
                    continue;
                }
                if (field2.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                    Message existingValue = (Message)this.getField(field2);
                    if (existingValue == existingValue.getDefaultInstanceForType()) {
                        this.setField(field2, entry.getValue());
                        continue;
                    }
                    this.setField(field2, existingValue.newBuilderForType().mergeFrom(existingValue).mergeFrom((Message)entry.getValue()).build());
                    continue;
                }
                this.setField(field2, entry.getValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            return (BuilderType)this;
        }

        @Override
        public BuilderType mergeFrom(CodedInputStream input) throws IOException {
            return (BuilderType)this.mergeFrom(input, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        }

        @Override
        public BuilderType mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            int tag;
            UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder(this.getUnknownFields());
            while ((tag = input.readTag()) != 0 && Builder.mergeFieldFrom(input, unknownFields, extensionRegistry, this.getDescriptorForType(), this, null, tag)) {
            }
            this.setUnknownFields(unknownFields.build());
            return (BuilderType)this;
        }

        private static void addRepeatedField(Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> extensions, Descriptors.FieldDescriptor field2, Object value2) {
            if (builder != null) {
                builder.addRepeatedField(field2, value2);
            } else {
                extensions.addRepeatedField(field2, value2);
            }
        }

        private static void setField(Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> extensions, Descriptors.FieldDescriptor field2, Object value2) {
            if (builder != null) {
                builder.setField(field2, value2);
            } else {
                extensions.setField(field2, value2);
            }
        }

        private static boolean hasOriginalMessage(Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> extensions, Descriptors.FieldDescriptor field2) {
            if (builder != null) {
                return builder.hasField(field2);
            }
            return extensions.hasField(field2);
        }

        private static Message getOriginalMessage(Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> extensions, Descriptors.FieldDescriptor field2) {
            if (builder != null) {
                return (Message)builder.getField(field2);
            }
            return (Message)extensions.getField(field2);
        }

        private static void mergeOriginalMessage(Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> extensions, Descriptors.FieldDescriptor field2, Message.Builder subBuilder) {
            Message originalMessage = Builder.getOriginalMessage(builder, extensions, field2);
            if (originalMessage != null) {
                subBuilder.mergeFrom(originalMessage);
            }
        }

        static boolean mergeFieldFrom(CodedInputStream input, UnknownFieldSet.Builder unknownFields, ExtensionRegistryLite extensionRegistry, Descriptors.Descriptor type2, Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> extensions, int tag) throws IOException {
            Descriptors.FieldDescriptor field2;
            if (type2.getOptions().getMessageSetWireFormat() && tag == WireFormat.MESSAGE_SET_ITEM_TAG) {
                Builder.mergeMessageSetExtensionFromCodedStream(input, unknownFields, extensionRegistry, type2, builder, extensions);
                return true;
            }
            int wireType = WireFormat.getTagWireType(tag);
            int fieldNumber = WireFormat.getTagFieldNumber(tag);
            Message defaultInstance = null;
            if (type2.isExtensionNumber(fieldNumber)) {
                if (extensionRegistry instanceof ExtensionRegistry) {
                    ExtensionRegistry.ExtensionInfo extension = ((ExtensionRegistry)extensionRegistry).findExtensionByNumber(type2, fieldNumber);
                    if (extension == null) {
                        field2 = null;
                    } else {
                        field2 = extension.descriptor;
                        defaultInstance = extension.defaultInstance;
                        if (defaultInstance == null && field2.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                            throw new IllegalStateException("Message-typed extension lacked default instance: " + field2.getFullName());
                        }
                    }
                } else {
                    field2 = null;
                }
            } else {
                field2 = builder != null ? type2.findFieldByNumber(fieldNumber) : null;
            }
            boolean unknown = false;
            boolean packed = false;
            if (field2 == null) {
                unknown = true;
            } else if (wireType == FieldSet.getWireFormatForFieldType(field2.getLiteType(), false)) {
                packed = false;
            } else if (field2.isPackable() && wireType == FieldSet.getWireFormatForFieldType(field2.getLiteType(), true)) {
                packed = true;
            } else {
                unknown = true;
            }
            if (unknown) {
                return unknownFields.mergeFieldFrom(tag, input);
            }
            if (packed) {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                if (field2.getLiteType() == WireFormat.FieldType.ENUM) {
                    while (input.getBytesUntilLimit() > 0) {
                        int rawValue = input.readEnum();
                        Descriptors.EnumValueDescriptor value2 = field2.getEnumType().findValueByNumber(rawValue);
                        if (value2 == null) {
                            return true;
                        }
                        Builder.addRepeatedField(builder, extensions, field2, value2);
                    }
                } else {
                    while (input.getBytesUntilLimit() > 0) {
                        Object value3 = FieldSet.readPrimitiveField(input, field2.getLiteType());
                        Builder.addRepeatedField(builder, extensions, field2, value3);
                    }
                }
                input.popLimit(limit);
            } else {
                Object value4;
                switch (field2.getType()) {
                    case GROUP: {
                        Message.Builder subBuilder = defaultInstance != null ? defaultInstance.newBuilderForType() : builder.newBuilderForField(field2);
                        if (!field2.isRepeated()) {
                            Builder.mergeOriginalMessage(builder, extensions, field2, subBuilder);
                        }
                        input.readGroup(field2.getNumber(), subBuilder, extensionRegistry);
                        value4 = subBuilder.buildPartial();
                        break;
                    }
                    case MESSAGE: {
                        Message.Builder subBuilder = defaultInstance != null ? defaultInstance.newBuilderForType() : builder.newBuilderForField(field2);
                        if (!field2.isRepeated()) {
                            Builder.mergeOriginalMessage(builder, extensions, field2, subBuilder);
                        }
                        input.readMessage(subBuilder, extensionRegistry);
                        value4 = subBuilder.buildPartial();
                        break;
                    }
                    case ENUM: {
                        int rawValue = input.readEnum();
                        value4 = field2.getEnumType().findValueByNumber(rawValue);
                        if (value4 != null) break;
                        unknownFields.mergeVarintField(fieldNumber, rawValue);
                        return true;
                    }
                    default: {
                        value4 = FieldSet.readPrimitiveField(input, field2.getLiteType());
                    }
                }
                if (field2.isRepeated()) {
                    Builder.addRepeatedField(builder, extensions, field2, value4);
                } else {
                    Builder.setField(builder, extensions, field2, value4);
                }
            }
            return true;
        }

        private static void mergeMessageSetExtensionFromCodedStream(CodedInputStream input, UnknownFieldSet.Builder unknownFields, ExtensionRegistryLite extensionRegistry, Descriptors.Descriptor type2, Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> extensions) throws IOException {
            int tag;
            int typeId = 0;
            ByteString rawBytes = null;
            ExtensionRegistry.ExtensionInfo extension = null;
            while ((tag = input.readTag()) != 0) {
                if (tag == WireFormat.MESSAGE_SET_TYPE_ID_TAG) {
                    typeId = input.readUInt32();
                    if (typeId == 0 || !(extensionRegistry instanceof ExtensionRegistry)) continue;
                    extension = ((ExtensionRegistry)extensionRegistry).findExtensionByNumber(type2, typeId);
                    continue;
                }
                if (tag == WireFormat.MESSAGE_SET_MESSAGE_TAG) {
                    if (typeId != 0 && extension != null && ExtensionRegistryLite.isEagerlyParseMessageSets()) {
                        Builder.eagerlyMergeMessageSetExtension(input, extension, extensionRegistry, builder, extensions);
                        rawBytes = null;
                        continue;
                    }
                    rawBytes = input.readBytes();
                    continue;
                }
                if (input.skipField(tag)) continue;
                break;
            }
            input.checkLastTagWas(WireFormat.MESSAGE_SET_ITEM_END_TAG);
            if (rawBytes != null && typeId != 0) {
                if (extension != null) {
                    Builder.mergeMessageSetExtensionFromBytes(rawBytes, extension, extensionRegistry, builder, extensions);
                } else if (rawBytes != null) {
                    unknownFields.mergeField(typeId, UnknownFieldSet.Field.newBuilder().addLengthDelimited(rawBytes).build());
                }
            }
        }

        private static void eagerlyMergeMessageSetExtension(CodedInputStream input, ExtensionRegistry.ExtensionInfo extension, ExtensionRegistryLite extensionRegistry, Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> extensions) throws IOException {
            Descriptors.FieldDescriptor field2 = extension.descriptor;
            Message value2 = null;
            if (Builder.hasOriginalMessage(builder, extensions, field2)) {
                Message originalMessage = Builder.getOriginalMessage(builder, extensions, field2);
                Message.Builder subBuilder = originalMessage.toBuilder();
                input.readMessage(subBuilder, extensionRegistry);
                value2 = subBuilder.buildPartial();
            } else {
                value2 = input.readMessage(extension.defaultInstance.getParserForType(), extensionRegistry);
            }
            if (builder != null) {
                builder.setField(field2, value2);
            } else {
                extensions.setField(field2, value2);
            }
        }

        private static void mergeMessageSetExtensionFromBytes(ByteString rawBytes, ExtensionRegistry.ExtensionInfo extension, ExtensionRegistryLite extensionRegistry, Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> extensions) throws IOException {
            Descriptors.FieldDescriptor field2 = extension.descriptor;
            boolean hasOriginalValue = Builder.hasOriginalMessage(builder, extensions, field2);
            if (hasOriginalValue || ExtensionRegistryLite.isEagerlyParseMessageSets()) {
                Message value2 = null;
                if (hasOriginalValue) {
                    Message originalMessage = Builder.getOriginalMessage(builder, extensions, field2);
                    Message.Builder subBuilder = originalMessage.toBuilder();
                    subBuilder.mergeFrom(rawBytes, extensionRegistry);
                    value2 = subBuilder.buildPartial();
                } else {
                    value2 = extension.defaultInstance.getParserForType().parsePartialFrom(rawBytes, extensionRegistry);
                }
                Builder.setField(builder, extensions, field2, value2);
            } else {
                LazyField lazyField = new LazyField(extension.defaultInstance, extensionRegistry, rawBytes);
                if (builder != null) {
                    if (builder instanceof GeneratedMessage.ExtendableBuilder) {
                        builder.setField(field2, lazyField);
                    } else {
                        builder.setField(field2, lazyField.getValue());
                    }
                } else {
                    extensions.setField(field2, lazyField);
                }
            }
        }

        public BuilderType mergeUnknownFields(UnknownFieldSet unknownFields) {
            this.setUnknownFields(UnknownFieldSet.newBuilder(this.getUnknownFields()).mergeFrom(unknownFields).build());
            return (BuilderType)this;
        }

        @Override
        public Message.Builder getFieldBuilder(Descriptors.FieldDescriptor field2) {
            throw new UnsupportedOperationException("getFieldBuilder() called on an unsupported message type.");
        }

        protected static UninitializedMessageException newUninitializedMessageException(Message message2) {
            return new UninitializedMessageException(Builder.findMissingFields(message2));
        }

        private static List<String> findMissingFields(MessageOrBuilder message2) {
            ArrayList<String> results2 = new ArrayList<String>();
            Builder.findMissingFields(message2, "", results2);
            return results2;
        }

        private static void findMissingFields(MessageOrBuilder message2, String prefix, List<String> results2) {
            for (Descriptors.FieldDescriptor fieldDescriptor : message2.getDescriptorForType().getFields()) {
                if (!fieldDescriptor.isRequired() || message2.hasField(fieldDescriptor)) continue;
                results2.add(prefix + fieldDescriptor.getName());
            }
            for (Map.Entry entry : message2.getAllFields().entrySet()) {
                Descriptors.FieldDescriptor field3 = (Descriptors.FieldDescriptor)entry.getKey();
                Object value2 = entry.getValue();
                if (field3.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
                if (field3.isRepeated()) {
                    int i = 0;
                    for (Object element2 : (List)value2) {
                        Builder.findMissingFields((MessageOrBuilder)element2, Builder.subMessagePrefix(prefix, field3, i++), results2);
                    }
                    continue;
                }
                if (!message2.hasField(field3)) continue;
                Builder.findMissingFields((MessageOrBuilder)value2, Builder.subMessagePrefix(prefix, field3, -1), results2);
            }
        }

        private static String subMessagePrefix(String prefix, Descriptors.FieldDescriptor field2, int index2) {
            StringBuilder result2 = new StringBuilder(prefix);
            if (field2.isExtension()) {
                result2.append('(').append(field2.getFullName()).append(')');
            } else {
                result2.append(field2.getName());
            }
            if (index2 != -1) {
                result2.append('[').append(index2).append(']');
            }
            result2.append('.');
            return result2.toString();
        }

        @Override
        public BuilderType mergeFrom(ByteString data) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(data));
        }

        @Override
        public BuilderType mergeFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(data, extensionRegistry));
        }

        @Override
        public BuilderType mergeFrom(byte[] data) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(data));
        }

        @Override
        public BuilderType mergeFrom(byte[] data, int off, int len) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(data, off, len));
        }

        @Override
        public BuilderType mergeFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(data, extensionRegistry));
        }

        @Override
        public BuilderType mergeFrom(byte[] data, int off, int len, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(data, off, len, extensionRegistry));
        }

        @Override
        public BuilderType mergeFrom(InputStream input) throws IOException {
            return (BuilderType)((Builder)super.mergeFrom(input));
        }

        @Override
        public BuilderType mergeFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (BuilderType)((Builder)super.mergeFrom(input, extensionRegistry));
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream input) throws IOException {
            return super.mergeDelimitedFrom(input);
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return super.mergeDelimitedFrom(input, extensionRegistry);
        }
    }
}

