/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.types.DelegatingFlexibleType;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypeFactory;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/types/DynamicTypeFactory;", "Lorg/jetbrains/kotlin/types/FlexibleTypeFactory;", "()V", "id", "", "getId", "()Ljava/lang/String;", "create", "Lorg/jetbrains/kotlin/types/KotlinType;", "lowerBound", "upperBound", "Impl", "descriptors"})
public final class DynamicTypeFactory
implements FlexibleTypeFactory {
    public static final DynamicTypeFactory INSTANCE;

    @Override
    @NotNull
    public String getId() {
        return "kotlin.DynamicType";
    }

    @Override
    @NotNull
    public KotlinType create(@NotNull KotlinType lowerBound, @NotNull KotlinType upperBound) {
        Intrinsics.checkParameterIsNotNull((Object)lowerBound, (String)"lowerBound");
        Intrinsics.checkParameterIsNotNull((Object)upperBound, (String)"upperBound");
        if (KotlinTypeChecker.FLEXIBLE_UNEQUAL_TO_INFLEXIBLE.equalTypes(lowerBound, TypeUtilsKt.getBuiltIns(lowerBound).getNothingType()) && KotlinTypeChecker.FLEXIBLE_UNEQUAL_TO_INFLEXIBLE.equalTypes(upperBound, TypeUtilsKt.getBuiltIns(upperBound).getNullableAnyType())) {
            return new Impl(lowerBound, upperBound);
        }
        throw (Throwable)new IllegalStateException("Illegal type range for dynamic type: " + lowerBound + ".." + upperBound);
    }

    private DynamicTypeFactory() {
        INSTANCE = this;
    }

    static {
        new DynamicTypeFactory();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/types/DynamicTypeFactory$Impl;", "Lorg/jetbrains/kotlin/types/DelegatingFlexibleType;", "lowerBound", "Lorg/jetbrains/kotlin/types/KotlinType;", "upperBound", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;)V", "delegateType", "getDelegateType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getSpecificityRelationTo", "Lorg/jetbrains/kotlin/types/Flexibility$SpecificityRelation;", "otherType", "isMarkedNullable", "", "makeNullableAsSpecified", "nullable", "descriptors"})
    private static final class Impl
    extends DelegatingFlexibleType {
        @Override
        @NotNull
        protected KotlinType getDelegateType() {
            return this.getUpperBound();
        }

        @Override
        @NotNull
        public Flexibility.SpecificityRelation getSpecificityRelationTo(@NotNull KotlinType otherType) {
            Intrinsics.checkParameterIsNotNull((Object)otherType, (String)"otherType");
            return !DynamicTypesKt.isDynamic(otherType) ? Flexibility.SpecificityRelation.LESS_SPECIFIC : Flexibility.SpecificityRelation.DONT_KNOW;
        }

        @Override
        @NotNull
        public KotlinType makeNullableAsSpecified(boolean nullable2) {
            return DynamicTypesKt.createDynamicType(TypeUtilsKt.getBuiltIns(this.getDelegateType()));
        }

        @Override
        public boolean isMarkedNullable() {
            return false;
        }

        public Impl(@NotNull KotlinType lowerBound, @NotNull KotlinType upperBound) {
            Intrinsics.checkParameterIsNotNull((Object)lowerBound, (String)"lowerBound");
            Intrinsics.checkParameterIsNotNull((Object)upperBound, (String)"upperBound");
            super(lowerBound, upperBound, INSTANCE);
        }
    }
}

