/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.LocalTimeCounter;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathVariableReference;
import org.jetbrains.annotations.NotNull;

public class XPathChangeUtil {
    private XPathChangeUtil() {
    }

    @NotNull
    public static XPathExpression createExpression(PsiElement context, String text) {
        XPathFile file = XPathChangeUtil.createXPathFile(context, text);
        XPathExpression child = (XPathExpression)PsiTreeUtil.getChildOfType((PsiElement)file, XPathExpression.class);
        assert (child != null);
        XPathExpression xPathExpression = child;
        if (xPathExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathChangeUtil", "createExpression"));
        }
        return xPathExpression;
    }

    @NotNull
    public static XPathVariableReference createVariableReference(PsiElement context, String name) {
        XPathVariableReference xPathVariableReference = (XPathVariableReference)XPathChangeUtil.createExpression(context, "$" + name);
        if (xPathVariableReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathChangeUtil", "createVariableReference"));
        }
        return xPathVariableReference;
    }

    @NotNull
    public static XPathFile createXPathFile(PsiElement context, String text) {
        XPathFile file = XPathChangeUtil.createXPathFile(context.getProject(), text, context.getContainingFile().getFileType());
        ContextProvider.copy(context.getContainingFile(), file);
        XPathFile xPathFile = file;
        if (xPathFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathChangeUtil", "createXPathFile"));
        }
        return xPathFile;
    }

    @NotNull
    public static XPathFile createXPathFile(Project project, String text, FileType fileType) {
        XPathFile xPathFile = (XPathFile)PsiFileFactory.getInstance((Project)project).createFileFromText("dummy." + fileType.getDefaultExtension(), fileType, (CharSequence)text, LocalTimeCounter.currentTime(), true);
        if (xPathFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathChangeUtil", "createXPathFile"));
        }
        return xPathFile;
    }
}

