/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.validation.inspections;

import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.intellij.lang.xpath.xslt.validation.inspections.InspectionUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class XsltInspection
extends LocalInspectionTool
implements CustomSuppressableInspectionTool {
    XsltInspection() {
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public SuppressIntentionAction[] getSuppressActions(@Nullable PsiElement psiElement) {
        List<SuppressIntentionAction> actions = InspectionUtil.getSuppressActions(this, false);
        SuppressIntentionAction[] suppressIntentionActionArray = actions.toArray(new SuppressIntentionAction[actions.size()]);
        if (suppressIntentionActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/validation/inspections/XsltInspection", "getSuppressActions"));
        }
        return suppressIntentionActionArray;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/validation/inspections/XsltInspection", "isSuppressedFor"));
        }
        return InspectionUtil.isSuppressed(this, element);
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("XSLT" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/validation/inspections/XsltInspection", "getGroupDisplayName"));
        }
        return "XSLT";
    }
}

