/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.TableViewDesignInfoX;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.HashMap;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.control.TableColumn;

public class TableColumnResizer {
    private static final PropertyName minWidthName = new PropertyName("minWidth");
    private static final PropertyName prefWidthName = new PropertyName("prefWidth");
    private static final PropertyName maxWidthName = new PropertyName("maxWidth");
    private final TableColumn<?, ?> tableColumn;
    private final TableColumn<?, ?> tableColumnNext;
    private final ColumnSizing originalSizing;
    private final ColumnSizing originalSizingNext;
    private final double x1;
    private final double x2;
    private final double x3;

    public TableColumnResizer(TableColumn<?, ?> tableColumn) {
        assert (tableColumn != null);
        assert (tableColumn.getTableView() != null);
        this.tableColumn = tableColumn;
        this.originalSizing = new ColumnSizing(this.tableColumn);
        ObservableList columns = this.tableColumn.getParentColumn() != null ? this.tableColumn.getParentColumn().getColumns() : this.tableColumn.getTableView().getColumns();
        int columnIndex = columns.indexOf(this.tableColumn);
        if (columnIndex + 1 < columns.size()) {
            this.tableColumnNext = (TableColumn)columns.get(columnIndex + 1);
            this.originalSizingNext = new ColumnSizing(this.tableColumnNext);
        } else {
            this.tableColumnNext = null;
            this.originalSizingNext = null;
        }
        TableViewDesignInfoX di = new TableViewDesignInfoX();
        Bounds columnBounds = di.getColumnBounds(tableColumn);
        this.x1 = columnBounds.getMinX();
        this.x2 = columnBounds.getMaxX();
        if (this.tableColumnNext != null) {
            Bounds nextBounds = di.getColumnBounds(this.tableColumnNext);
            this.x3 = nextBounds.getMaxX();
        } else if (tableColumn.getParentColumn() != null) {
            TableColumn parentColumn = (TableColumn)this.tableColumn.getParentColumn();
            Bounds parentBounds = di.getColumnBounds(parentColumn);
            this.x3 = parentBounds.getMaxX();
        } else {
            Bounds layoutBounds = tableColumn.getTableView().getLayoutBounds();
            this.x3 = layoutBounds.getMaxX();
        }
    }

    public TableColumn<?, ?> getTableColumn() {
        return this.tableColumn;
    }

    public void updateWidth(double dx) {
        double newX2 = Math.max(this.x1, Math.min(this.x3, this.x2 + dx));
        double newWidth = newX2 - this.x1;
        double newWidthNext = this.x3 - newX2;
        this.tableColumn.setPrefWidth(newWidth);
        if (this.tableColumn.getMinWidth() == -1.0) {
            this.tableColumn.setMinWidth(newWidth);
        } else {
            this.tableColumn.setMinWidth(Math.min(newWidth, this.tableColumn.getMinWidth()));
        }
        if (this.tableColumn.getMaxWidth() == -1.0) {
            this.tableColumn.setMaxWidth(newWidth);
        } else {
            this.tableColumn.setMaxWidth(Math.max(newWidth, this.tableColumn.getMaxWidth()));
        }
        if (this.tableColumnNext != null) {
            this.tableColumnNext.setPrefWidth(newWidthNext);
            if (this.tableColumnNext.getMinWidth() == -1.0) {
                this.tableColumnNext.setMinWidth(newWidthNext);
            } else {
                this.tableColumnNext.setMinWidth(Math.min(newWidthNext, this.tableColumnNext.getMinWidth()));
            }
            if (this.tableColumnNext.getMaxWidth() == -1.0) {
                this.tableColumnNext.setMaxWidth(newWidthNext);
            } else {
                this.tableColumnNext.setMaxWidth(Math.max(newWidthNext, this.tableColumnNext.getMaxWidth()));
            }
        }
    }

    public void revertToOriginalSize() {
        this.originalSizing.applyTo(this.tableColumn);
        if (this.tableColumnNext != null) {
            this.originalSizingNext.applyTo(this.tableColumnNext);
        }
    }

    public Map<PropertyName, Object> getChangeMap() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        if (!MathUtils.equals(this.tableColumn.getMinWidth(), this.originalSizing.getMinWidth())) {
            result.put(minWidthName, this.tableColumn.getMinWidth());
        }
        if (!MathUtils.equals(this.tableColumn.getPrefWidth(), this.originalSizing.getPrefWidth())) {
            result.put(prefWidthName, this.tableColumn.getPrefWidth());
        }
        if (!MathUtils.equals(this.tableColumn.getMaxWidth(), this.originalSizing.getMaxWidth())) {
            result.put(maxWidthName, this.tableColumn.getMaxWidth());
        }
        return result;
    }

    public Map<PropertyName, Object> getChangeMapNext() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        if (this.tableColumnNext != null) {
            if (!MathUtils.equals(this.tableColumnNext.getMinWidth(), this.originalSizingNext.getMinWidth())) {
                result.put(minWidthName, this.tableColumnNext.getMinWidth());
            }
            if (!MathUtils.equals(this.tableColumnNext.getPrefWidth(), this.originalSizingNext.getPrefWidth())) {
                result.put(prefWidthName, this.tableColumnNext.getPrefWidth());
            }
            if (!MathUtils.equals(this.tableColumnNext.getMaxWidth(), this.originalSizingNext.getMaxWidth())) {
                result.put(maxWidthName, this.tableColumnNext.getMaxWidth());
            }
        }
        return result;
    }

    private static class ColumnSizing {
        private final double minWidth;
        private final double maxWidth;
        private final double prefWidth;

        public ColumnSizing(TableColumn<?, ?> tc) {
            this.minWidth = tc.getMinWidth();
            this.maxWidth = tc.getMaxWidth();
            this.prefWidth = tc.getPrefWidth();
        }

        public double getMinWidth() {
            return this.minWidth;
        }

        public double getMaxWidth() {
            return this.maxWidth;
        }

        public double getPrefWidth() {
            return this.prefWidth;
        }

        public void applyTo(TableColumn<?, ?> tc) {
            tc.setMinWidth(this.minWidth);
            tc.setMaxWidth(this.maxWidth);
            tc.setPrefWidth(this.prefWidth);
        }
    }
}

