/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.AbstractSegment;

class HorizontalSegment
extends AbstractSegment {
    private final double x1;
    private final double x2;
    private final double y;
    private final double length;

    public HorizontalSegment(double x1, double x2, double y) {
        this.x1 = x1;
        this.x2 = x2;
        this.y = y;
        this.length = Math.abs(x2 - x1);
    }

    @Override
    public double getX1() {
        return this.x1;
    }

    @Override
    public double getX2() {
        return this.x2;
    }

    @Override
    public double getY1() {
        return this.y;
    }

    @Override
    public double getY2() {
        return this.y;
    }

    @Override
    public double getLength() {
        return this.length;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (int)(Double.doubleToLongBits(this.x1) ^ Double.doubleToLongBits(this.x1) >>> 32);
        hash = 89 * hash + (int)(Double.doubleToLongBits(this.x2) ^ Double.doubleToLongBits(this.x2) >>> 32);
        hash = 89 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HorizontalSegment other = (HorizontalSegment)obj;
        if (Double.doubleToLongBits(this.x1) != Double.doubleToLongBits(other.x1)) {
            return false;
        }
        if (Double.doubleToLongBits(this.x2) != Double.doubleToLongBits(other.x2)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    @Override
    public int compareTo(AbstractSegment o) {
        assert (o != null);
        return Double.compare(this.length, o.getLength());
    }
}

