/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNode;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.list.StringListPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.URLUtils;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FXOMAssetIndex {
    private final FXOMDocument fxomDocument;
    private final Map<Path, FXOMNode> fileAssets;
    private static final PropertyName valueName = new PropertyName("value");

    public FXOMAssetIndex(FXOMDocument fxomDocument) {
        assert (fxomDocument != null);
        this.fxomDocument = fxomDocument;
        this.fileAssets = Collections.unmodifiableMap(this.collectAssets());
    }

    public Map<Path, FXOMNode> getFileAssets() {
        return this.fileAssets;
    }

    private Map<Path, FXOMNode> collectAssets() {
        HashMap<Path, FXOMNode> result = new HashMap<Path, FXOMNode>();
        if (this.fxomDocument.getFxomRoot() != null) {
            FXOMObject fxomRoot = this.fxomDocument.getFxomRoot();
            for (FXOMPropertyT p : fxomRoot.collectPropertiesT()) {
                for (String s : StringListPropertyMetadata.splitValue(p.getValue())) {
                    Path path = this.extractPath(s);
                    if (path == null) continue;
                    result.put(path, p);
                }
            }
            for (FXOMObject fxomObject : fxomRoot.collectObjectWithSceneGraphObjectClass(URL.class)) {
                if (!(fxomObject instanceof FXOMInstance)) continue;
                FXOMInstance urlInstance = (FXOMInstance)fxomObject;
                FXOMProperty valueProperty = urlInstance.getProperties().get(valueName);
                if (valueProperty instanceof FXOMPropertyT) {
                    FXOMPropertyT valuePropertyT = (FXOMPropertyT)valueProperty;
                    Path path = this.extractPath(valuePropertyT.getValue());
                    if (path == null) continue;
                    result.put(path, valuePropertyT);
                    continue;
                }
                assert (false) : "valueProperty.getName()=" + valueProperty.getName();
            }
            for (FXOMIntrinsic fxomInclude : fxomRoot.collectIncludes(null)) {
                String equivalentValue = "@" + fxomInclude.getSource();
                Path path = this.extractPath(equivalentValue);
                if (path == null) continue;
                result.put(path, fxomInclude);
            }
        }
        return result;
    }

    private Path extractPath(String stringValue) {
        Path result;
        block22: {
            PrefixedValue pv = new PrefixedValue(stringValue);
            if (pv.isPlainString()) {
                try {
                    File file = URLUtils.getFile(pv.getSuffix());
                    if (file == null) {
                        result = null;
                        break block22;
                    }
                    result = file.toPath();
                }
                catch (URISyntaxException x) {
                    result = null;
                }
            } else if (pv.isDocumentRelativePath()) {
                URL documentLocation = this.fxomDocument.getLocation();
                if (documentLocation == null) {
                    result = null;
                } else {
                    URL url = pv.resolveDocumentRelativePath(documentLocation);
                    if (url == null) {
                        result = null;
                    } else {
                        try {
                            result = Paths.get(url.toURI());
                        }
                        catch (URISyntaxException | FileSystemNotFoundException x) {
                            result = null;
                        }
                    }
                }
            } else if (pv.isClassLoaderRelativePath()) {
                ClassLoader classLoader = this.fxomDocument.getClassLoader();
                if (classLoader == null) {
                    result = null;
                } else {
                    URL url = pv.resolveClassLoaderRelativePath(classLoader);
                    if (url == null) {
                        result = null;
                    } else {
                        try {
                            File file = URLUtils.getFile(url);
                            if (file == null) {
                                result = null;
                                break block22;
                            }
                            result = file.toPath();
                        }
                        catch (URISyntaxException x) {
                            result = null;
                        }
                    }
                }
            } else {
                result = null;
            }
        }
        return result;
    }
}

