/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCloner;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNode;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueInstruction;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.klass.ComponentClassMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.PropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DoublePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.ImagePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignImage;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.JavaLanguage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.media.Media;
import javafx.scene.media.MediaException;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;

public class FXOMNodes {
    private static final PropertyName toggleGroupName = new PropertyName("toggleGroup");
    private static Set<String> weakPropertyNames;

    public static List<FXOMObject> sort(Set<FXOMObject> objects) {
        List<FXOMObject> result;
        assert (objects != null);
        if (objects.isEmpty()) {
            result = Collections.emptyList();
        } else if (objects.size() == 1) {
            result = Collections.singletonList(objects.iterator().next());
        } else {
            FXOMObject object0 = objects.iterator().next();
            FXOMDocument fxomDocument = object0.getFxomDocument();
            assert (fxomDocument != null);
            result = new ArrayList<FXOMObject>();
            FXOMNodes.sort(fxomDocument.getFxomRoot(), objects, result);
        }
        return result;
    }

    public static Set<FXOMObject> flatten(Set<FXOMObject> objects) {
        HashSet<FXOMObject> result = new HashSet<FXOMObject>();
        assert (objects != null);
        for (FXOMObject o : objects) {
            if (FXOMNodes.lookupAncestor(o, objects) != null) continue;
            result.add(o);
        }
        return result;
    }

    public static FXOMObject lookupAncestor(FXOMObject obj, Set<FXOMObject> candidates) {
        FXOMObject result;
        assert (obj != null);
        assert (candidates != null);
        assert (!candidates.isEmpty());
        for (result = obj.getParentObject(); result != null && !candidates.contains(result); result = result.getParentObject()) {
        }
        return result;
    }

    public static FXOMObject newObject(FXOMDocument targetDocument, File file) throws IOException {
        FXOMObject result;
        block12: {
            assert (targetDocument != null);
            assert (file != null);
            result = null;
            if (file.getAbsolutePath().endsWith(".fxml")) {
                String fxmlText = FXOMDocument.readContentFromURL(file.toURI().toURL());
                FXOMDocument transientDoc = new FXOMDocument(fxmlText, targetDocument.getLocation(), targetDocument.getClassLoader(), targetDocument.getResources());
                result = transientDoc.getFxomRoot();
                if (result != null) {
                    result.moveToFxomDocument(targetDocument);
                }
            } else {
                String fileURL = file.toURI().toURL().toString();
                Image image = new Image(fileURL);
                if (!image.isError()) {
                    FXOMDocument transientDoc = FXOMNodes.makeFxomDocumentFromImageURL(image, 200.0);
                    result = transientDoc.getFxomRoot();
                    if (result != null) {
                        result.moveToFxomDocument(targetDocument);
                    }
                } else {
                    try {
                        Media media = new Media(fileURL);
                        if (media.getError() == null) {
                            FXOMDocument transientDoc = FXOMNodes.makeFxomDocumentFromMedia(media, 200.0);
                            result = transientDoc.getFxomRoot();
                            if (result != null) {
                                result.moveToFxomDocument(targetDocument);
                            }
                            break block12;
                        }
                        throw new IOException(media.getError());
                    }
                    catch (MediaException x) {
                        throw new IOException(x);
                    }
                }
            }
        }
        return result;
    }

    public static FXOMIntrinsic newInclude(FXOMDocument targetDocument, File file) throws IOException {
        URL fxmlURL;
        String fxmlText;
        FXOMDocument transientDoc;
        assert (targetDocument != null);
        assert (targetDocument.getLocation() != null);
        assert (file != null);
        FXOMIntrinsic result = null;
        if (file.getAbsolutePath().endsWith(".fxml") && (transientDoc = new FXOMDocument(fxmlText = FXOMDocument.readContentFromURL(fxmlURL = file.toURI().toURL()), fxmlURL, targetDocument.getClassLoader(), targetDocument.getResources())).getFxomRoot() != null) {
            PrefixedValue pv = PrefixedValue.makePrefixedValue(fxmlURL, targetDocument.getLocation());
            assert (pv.isDocumentRelativePath());
            assert (pv.toString().startsWith("@"));
            String includeRef = pv.toString().substring("@".length());
            result = new FXOMIntrinsic(targetDocument, FXOMIntrinsic.Type.FX_INCLUDE, includeRef);
            result.setSourceSceneGraphObject(transientDoc.getFxomRoot().getSceneGraphObject());
        }
        return result;
    }

    public static FXOMDocument newDocument(FXOMObject source) {
        assert (source != null);
        FXOMDocument result = new FXOMDocument();
        FXOMDocument sourceDocument = source.getFxomDocument();
        assert (sourceDocument.getFxomRoot() != null);
        List<FXOMObject> unresolvedObjects = FXOMNodes.collectUnresolvedObjects(sourceDocument.getFxomRoot());
        if (!unresolvedObjects.isEmpty()) {
            GlueDocument sourceGlue = sourceDocument.getGlue();
            GlueDocument resultGlue = result.getGlue();
            for (GlueInstruction i : sourceGlue.collectInstructions("import")) {
                GlueInstruction ci = new GlueInstruction(resultGlue, i.getTarget(), i.getData());
                resultGlue.getHeader().add(ci);
            }
        }
        FXOMCloner cloner = new FXOMCloner(result);
        FXOMObject sourceClone = cloner.clone(source);
        result.beginUpdate();
        result.setLocation(sourceDocument.getLocation());
        result.setClassLoader(sourceDocument.getClassLoader());
        result.setFxomRoot(sourceClone);
        if (result.getFxomRoot() instanceof FXOMInstance) {
            FXOMNodes.trimStaticProperties((FXOMInstance)result.getFxomRoot());
        }
        result.endUpdate();
        return result;
    }

    public static void updateProperty(FXOMInstance fxomInstance, FXOMProperty sourceProperty) {
        assert (fxomInstance != null);
        assert (sourceProperty != null);
        assert (sourceProperty.getFxomDocument() == fxomInstance.getFxomDocument());
        FXOMProperty currentProperty = fxomInstance.getProperties().get(sourceProperty.getName());
        if (currentProperty == null) {
            sourceProperty.addToParentInstance(-1, fxomInstance);
        } else if (currentProperty instanceof FXOMPropertyT && sourceProperty instanceof FXOMPropertyT) {
            FXOMPropertyT currentPropertyT = (FXOMPropertyT)currentProperty;
            FXOMPropertyT newPropertyT = (FXOMPropertyT)sourceProperty;
            FXOMNodes.updateProperty(currentPropertyT, newPropertyT);
        } else if (currentProperty instanceof FXOMPropertyC && sourceProperty instanceof FXOMPropertyC) {
            FXOMPropertyC currentPropertyC = (FXOMPropertyC)currentProperty;
            FXOMPropertyC newPropertyC = (FXOMPropertyC)sourceProperty;
            FXOMNodes.updateProperty(currentPropertyC, newPropertyC);
        } else {
            int index = currentProperty.getIndexInParentInstance();
            currentProperty.removeFromParentInstance();
            sourceProperty.addToParentInstance(index, fxomInstance);
        }
    }

    public static void updateProperty(FXOMPropertyT fxomProperty, FXOMPropertyT sourceProperty) {
        assert (fxomProperty != null);
        assert (sourceProperty != null);
        assert (fxomProperty.getName().equals(sourceProperty.getName()));
        fxomProperty.setValue(sourceProperty.getValue());
    }

    public static void updateProperty(FXOMPropertyC fxomProperty, FXOMPropertyC sourceProperty) {
        FXOMObject currentValue;
        int i;
        assert (fxomProperty != null);
        assert (sourceProperty != null);
        assert (fxomProperty.getName().equals(sourceProperty.getName()));
        ArrayList<FXOMObject> currentValues = new ArrayList<FXOMObject>();
        currentValues.addAll(fxomProperty.getValues());
        ArrayList<FXOMObject> sourceValues = new ArrayList<FXOMObject>();
        sourceValues.addAll(sourceProperty.getValues());
        int currentCount = currentValues.size();
        int newCount = sourceValues.size();
        int updateCount = Math.min(currentCount, newCount);
        for (i = 0; i < updateCount; ++i) {
            currentValue = (FXOMObject)currentValues.get(i);
            FXOMObject newValue = (FXOMObject)sourceValues.get(i);
            if (currentValue instanceof FXOMInstance && newValue instanceof FXOMInstance) {
                FXOMInstance currentInstance = (FXOMInstance)currentValue;
                FXOMInstance newInstance = (FXOMInstance)newValue;
                if (currentInstance.getDeclaredClass() == newInstance.getDeclaredClass()) {
                    FXOMNodes.updateInstance(currentInstance, newInstance);
                    continue;
                }
                FXOMNodes.replacePropertyValue(currentValue, newValue);
                continue;
            }
            if (currentValue instanceof FXOMCollection && newValue instanceof FXOMCollection) {
                FXOMCollection currentCollection = (FXOMCollection)currentValue;
                FXOMCollection newCollection = (FXOMCollection)newValue;
                FXOMNodes.updateCollection(currentCollection, newCollection);
                continue;
            }
            if (currentValue instanceof FXOMIntrinsic && newValue instanceof FXOMIntrinsic) {
                FXOMIntrinsic currentIntrinsic = (FXOMIntrinsic)currentValue;
                FXOMIntrinsic newIntrinsic = (FXOMIntrinsic)newValue;
                FXOMNodes.updateIntrinsic(currentIntrinsic, newIntrinsic);
                continue;
            }
            FXOMNodes.replacePropertyValue(currentValue, newValue);
        }
        if (currentCount < newCount) {
            for (i = currentCount; i < newCount; ++i) {
                FXOMObject newValue = (FXOMObject)sourceValues.get(i);
                newValue.addToParentProperty(-1, fxomProperty);
            }
        } else {
            for (i = newCount; i < currentCount; ++i) {
                currentValue = (FXOMObject)currentValues.get(i);
                currentValue.removeFromParentProperty();
            }
        }
    }

    public static void updateInstance(FXOMInstance fxomInstance, FXOMInstance sourceInstance) {
        assert (fxomInstance != null);
        assert (sourceInstance != null);
        assert (fxomInstance.getFxomDocument() == sourceInstance.getFxomDocument());
        assert (fxomInstance.getDeclaredClass() == sourceInstance.getDeclaredClass());
        HashSet<PropertyName> obsoleteNames = new HashSet<PropertyName>();
        obsoleteNames.addAll(fxomInstance.getProperties().keySet());
        obsoleteNames.removeAll(sourceInstance.getProperties().keySet());
        HashSet<FXOMProperty> sourceProperties = new HashSet<FXOMProperty>(sourceInstance.getProperties().values());
        for (FXOMProperty sourceProperty : sourceProperties) {
            FXOMNodes.updateProperty(fxomInstance, sourceProperty);
        }
        for (PropertyName pn : obsoleteNames) {
            FXOMProperty fxomProperty = fxomInstance.getProperties().get(pn);
            assert (fxomProperty != null);
            assert (fxomProperty.getParentInstance() == fxomInstance);
            fxomProperty.removeFromParentInstance();
        }
        fxomInstance.setFxConstant(sourceInstance.getFxConstant());
        fxomInstance.setFxValue(sourceInstance.getFxValue());
        fxomInstance.setFxFactory(sourceInstance.getFxFactory());
    }

    public static void updateCollection(FXOMCollection fxomCollection, FXOMCollection sourceCollection) {
        FXOMObject newValue;
        assert (fxomCollection != null);
        assert (sourceCollection != null);
        assert (fxomCollection.getFxomDocument() == sourceCollection.getFxomDocument());
        int currentCount = fxomCollection.getItems().size();
        int sourceCount = sourceCollection.getItems().size();
        int updateCount = Math.min(currentCount, sourceCount);
        for (int i = 0; i < updateCount; ++i) {
            FXOMObject currentValue = fxomCollection.getItems().get(i);
            newValue = sourceCollection.getItems().get(i);
            if (currentValue instanceof FXOMInstance && newValue instanceof FXOMInstance) {
                FXOMInstance currentInstance = (FXOMInstance)currentValue;
                FXOMInstance newInstance = (FXOMInstance)newValue;
                FXOMNodes.updateInstance(currentInstance, newInstance);
                continue;
            }
            if (currentValue instanceof FXOMCollection && newValue instanceof FXOMCollection) {
                FXOMCollection currentCollection = (FXOMCollection)currentValue;
                FXOMCollection newCollection = (FXOMCollection)newValue;
                FXOMNodes.updateCollection(currentCollection, newCollection);
                continue;
            }
            if (currentValue instanceof FXOMIntrinsic && newValue instanceof FXOMIntrinsic) {
                FXOMIntrinsic currentIntrinsic = (FXOMIntrinsic)currentValue;
                FXOMIntrinsic newIntrinsic = (FXOMIntrinsic)newValue;
                FXOMNodes.updateIntrinsic(currentIntrinsic, newIntrinsic);
                continue;
            }
            int index = currentValue.getIndexInParentProperty();
            assert (index != -1);
            currentValue.removeFromParentCollection();
            newValue.addToParentCollection(index, fxomCollection);
        }
        if (currentCount < sourceCount) {
            int addCount = sourceCount - currentCount;
            for (int i = 0; i < addCount; ++i) {
                newValue = sourceCollection.getItems().get(i);
                newValue.addToParentCollection(-1, fxomCollection);
            }
        } else {
            int removeCount = currentCount - sourceCount;
            for (int i = 0; i < removeCount; ++i) {
                FXOMObject currentValue = fxomCollection.getItems().get(sourceCount);
                currentValue.removeFromParentProperty();
            }
        }
        fxomCollection.setFxConstant(sourceCollection.getFxConstant());
        fxomCollection.setFxValue(sourceCollection.getFxValue());
        fxomCollection.setFxFactory(sourceCollection.getFxFactory());
    }

    public static void updateIntrinsic(FXOMIntrinsic fxomIntrinsic, FXOMIntrinsic sourceIntrinsic) {
        assert (fxomIntrinsic != null);
        assert (sourceIntrinsic != null);
        assert (fxomIntrinsic.getFxomDocument() != sourceIntrinsic.getFxomDocument());
        assert (fxomIntrinsic.getType() == sourceIntrinsic.getType());
        fxomIntrinsic.setSource(sourceIntrinsic.getSource());
        fxomIntrinsic.setFxConstant(sourceIntrinsic.getFxConstant());
        fxomIntrinsic.setFxValue(sourceIntrinsic.getFxValue());
        fxomIntrinsic.setFxFactory(sourceIntrinsic.getFxFactory());
    }

    public static List<FXOMPropertyT> collectReferenceExpression(FXOMObject fxomRoot, String fxId) {
        assert (fxomRoot != null);
        assert (fxId != null);
        ArrayList<FXOMPropertyT> result = new ArrayList<FXOMPropertyT>();
        for (FXOMPropertyT p : fxomRoot.collectPropertiesT()) {
            String id;
            PrefixedValue pv = new PrefixedValue(p.getValue());
            if (!pv.isExpression() || !(id = pv.getSuffix()).equals(fxId)) continue;
            result.add(p);
        }
        return result;
    }

    public static List<FXOMObject> collectUnresolvedObjects(FXOMObject fxomObject) {
        ArrayList<FXOMObject> result = new ArrayList<FXOMObject>();
        for (FXOMObject o : FXOMNodes.serializeObjects(fxomObject)) {
            if (o.getSceneGraphObject() != null) continue;
            result.add(o);
        }
        return result;
    }

    public static List<FXOMObject> serializeObjects(FXOMObject fxomObject) {
        ArrayList<FXOMObject> result = new ArrayList<FXOMObject>();
        FXOMNodes.serializeObjects(fxomObject, result);
        assert (!result.isEmpty());
        assert (result.get(0) == fxomObject);
        return result;
    }

    public static void removeToggleGroups(Map<String, FXOMObject> fxIdMap) {
        assert (fxIdMap != null);
        for (String fxId : new HashSet<String>(fxIdMap.keySet())) {
            FXOMObject fxomObject = fxIdMap.get(fxId);
            if (!(fxomObject.getSceneGraphObject() instanceof ToggleGroup)) continue;
            fxIdMap.remove(fxId);
        }
    }

    public static String extractReferenceSource(FXOMNode node) {
        String result;
        if (node instanceof FXOMIntrinsic) {
            FXOMIntrinsic intrinsic = (FXOMIntrinsic)node;
            switch (intrinsic.getType()) {
                case FX_REFERENCE: 
                case FX_COPY: {
                    result = intrinsic.getSource();
                    break;
                }
                default: {
                    result = null;
                    break;
                }
            }
        } else {
            FXOMPropertyT property;
            PrefixedValue pv;
            result = node instanceof FXOMPropertyT ? ((pv = new PrefixedValue((property = (FXOMPropertyT)node).getValue())).isExpression() && JavaLanguage.isIdentifier(pv.getSuffix()) ? pv.getSuffix() : null) : null;
        }
        return result;
    }

    public static boolean isToggleGroupReference(FXOMNode node) {
        boolean result;
        if (FXOMNodes.extractReferenceSource(node) == null) {
            result = false;
        } else if (node instanceof FXOMIntrinsic) {
            FXOMIntrinsic intrinsic = (FXOMIntrinsic)node;
            FXOMPropertyC parentProperty = intrinsic.getParentProperty();
            result = parentProperty == null ? false : parentProperty.getName().equals(toggleGroupName);
        } else if (node instanceof FXOMPropertyT) {
            FXOMPropertyT property = (FXOMPropertyT)node;
            result = property.getName().equals(toggleGroupName);
        } else {
            result = false;
        }
        return result;
    }

    public static FXOMPropertyC makeToggleGroup(FXOMDocument fxomDocument, String fxId) {
        FXOMInstance toggleGroup = new FXOMInstance(fxomDocument, ToggleGroup.class);
        toggleGroup.setFxId(fxId);
        return new FXOMPropertyC(fxomDocument, toggleGroupName, toggleGroup);
    }

    public static boolean isWeakReference(FXOMNode node) {
        boolean result;
        if (node instanceof FXOMIntrinsic) {
            FXOMIntrinsic intrinsic = (FXOMIntrinsic)node;
            switch (intrinsic.getType()) {
                case FX_REFERENCE: 
                case FX_COPY: {
                    if (intrinsic.getParentProperty() != null) {
                        PropertyName propertyName = intrinsic.getParentProperty().getName();
                        if (propertyName.getResidenceClass() == null) {
                            result = FXOMNodes.getWeakPropertyNames().contains(propertyName.getName());
                            break;
                        }
                        result = false;
                        break;
                    }
                    result = false;
                    break;
                }
                default: {
                    result = false;
                }
            }
        } else {
            PropertyName propertyName;
            FXOMPropertyT property;
            PrefixedValue pv;
            result = node instanceof FXOMPropertyT ? ((pv = new PrefixedValue((property = (FXOMPropertyT)node).getValue())).isExpression() && JavaLanguage.isIdentifier(pv.getSuffix()) ? ((propertyName = property.getName()).getResidenceClass() == null ? FXOMNodes.getWeakPropertyNames().contains(propertyName.getName()) : false) : false) : false;
        }
        return result;
    }

    public static synchronized Set<String> getWeakPropertyNames() {
        if (weakPropertyNames == null) {
            weakPropertyNames = new HashSet<String>();
            weakPropertyNames.add("labelFor");
            weakPropertyNames.add("expandedPane");
            weakPropertyNames.add("clip");
        }
        return weakPropertyNames;
    }

    private static void sort(FXOMObject from, Set<FXOMObject> objects, List<FXOMObject> result) {
        if (objects.contains(from)) {
            result.add(from);
        }
        if (from instanceof FXOMCollection) {
            FXOMCollection collection = (FXOMCollection)from;
            for (FXOMObject item : collection.getItems()) {
                FXOMNodes.sort(item, objects, result);
            }
        } else if (from instanceof FXOMInstance) {
            FXOMInstance instance = (FXOMInstance)from;
            ArrayList<PropertyName> propertyNames = new ArrayList<PropertyName>(instance.getProperties().keySet());
            Collections.sort(propertyNames);
            for (PropertyName name : propertyNames) {
                FXOMProperty property = instance.getProperties().get(name);
                assert (property != null);
                if (!(property instanceof FXOMPropertyC)) continue;
                FXOMPropertyC propertyC = (FXOMPropertyC)property;
                for (FXOMObject v : propertyC.getValues()) {
                    FXOMNodes.sort(v, objects, result);
                }
            }
        } else assert (from instanceof FXOMIntrinsic) : "Unexpected FXOMObject subclass " + from.getClass();
    }

    private static void trimStaticProperties(FXOMInstance fxomInstance) {
        ArrayList<FXOMProperty> properties = new ArrayList<FXOMProperty>(fxomInstance.getProperties().values());
        for (FXOMProperty p : properties) {
            if (p.getName().getResidenceClass() == null) continue;
            p.removeFromParentInstance();
        }
    }

    private static void replacePropertyValue(FXOMObject replacee, FXOMObject replacement) {
        assert (replacee.getIndexInParentProperty() != -1);
        int replaceeIndex = replacee.getIndexInParentProperty();
        assert (replaceeIndex != -1);
        replacement.addToParentProperty(replaceeIndex, replacee.getParentProperty());
        replacee.removeFromParentProperty();
    }

    private static FXOMDocument makeFxomDocumentFromImageURL(Image image, double fitSize) throws IOException {
        double fitHeight;
        double fitWidth;
        double imageHeight;
        assert (image != null);
        assert (fitSize > 0.0);
        double imageWidth = image.getWidth();
        double imageSize = Math.max(imageWidth, imageHeight = image.getHeight());
        if (imageSize < fitSize) {
            fitWidth = 0.0;
            fitHeight = 0.0;
        } else {
            double widthScale = fitSize / imageSize;
            double heightScale = fitSize / imageHeight;
            double scale = Math.min(widthScale, heightScale);
            fitWidth = Math.floor(imageWidth * scale);
            fitHeight = Math.floor(imageHeight * scale);
        }
        return FXOMNodes.makeFxomDocumentFromImageURL(image, fitWidth, fitHeight);
    }

    private static FXOMDocument makeFxomDocumentFromImageURL(Image image, double fitWidth, double fitHeight) {
        FXOMDocument result = new FXOMDocument();
        FXOMInstance imageView = new FXOMInstance(result, ImageView.class);
        PropertyName imageName = new PropertyName("image");
        PropertyName fitWidthName = new PropertyName("fitWidth");
        PropertyName fitHeightName = new PropertyName("fitHeight");
        ComponentClassMetadata imageViewMeta = Metadata.getMetadata().queryComponentMetadata(ImageView.class);
        PropertyMetadata imagePropMeta = imageViewMeta.lookupProperty(imageName);
        PropertyMetadata fitWidthPropMeta = imageViewMeta.lookupProperty(fitWidthName);
        PropertyMetadata fitHeightPropMeta = imageViewMeta.lookupProperty(fitHeightName);
        assert (imagePropMeta instanceof ImagePropertyMetadata);
        assert (fitWidthPropMeta instanceof DoublePropertyMetadata);
        assert (fitHeightPropMeta instanceof DoublePropertyMetadata);
        ImagePropertyMetadata imageMeta = (ImagePropertyMetadata)imagePropMeta;
        DoublePropertyMetadata fitWidthMeta = (DoublePropertyMetadata)fitWidthPropMeta;
        DoublePropertyMetadata fitHeightMeta = (DoublePropertyMetadata)fitHeightPropMeta;
        imageMeta.setValue(imageView, new DesignImage(image));
        fitWidthMeta.setValue(imageView, fitWidth);
        fitHeightMeta.setValue(imageView, fitHeight);
        result.setFxomRoot(imageView);
        return result;
    }

    private static FXOMDocument makeFxomDocumentFromMedia(Media media, double fitSize) throws IOException {
        double fitHeight;
        double fitWidth;
        double mediaHeight;
        assert (media != null);
        assert (fitSize > 0.0);
        double mediaWidth = media.getWidth();
        double mediaSize = Math.max(mediaWidth, mediaHeight = (double)media.getHeight());
        if (mediaSize < fitSize) {
            fitWidth = 0.0;
            fitHeight = 0.0;
        } else {
            double widthScale = fitSize / mediaSize;
            double heightScale = fitSize / mediaHeight;
            double scale = Math.min(widthScale, heightScale);
            fitWidth = Math.floor(mediaWidth * scale);
            fitHeight = Math.floor(mediaHeight * scale);
        }
        return FXOMNodes.makeFxomDocumentFromMedia(media, fitWidth, fitHeight);
    }

    private static FXOMDocument makeFxomDocumentFromMedia(Media media, double fitWidth, double fitHeight) {
        FXOMDocument result = new FXOMDocument();
        PropertyName valueName = new PropertyName("value");
        FXOMPropertyT valueProperty = new FXOMPropertyT(result, valueName, media.getSource());
        FXOMInstance urlInstance = new FXOMInstance(result, URL.class);
        valueProperty.addToParentInstance(-1, urlInstance);
        PropertyName sourceName = new PropertyName("source");
        FXOMPropertyC sourceProperty = new FXOMPropertyC(result, sourceName, urlInstance);
        FXOMInstance mediaInstance = new FXOMInstance(result, Media.class);
        sourceProperty.addToParentInstance(-1, mediaInstance);
        PropertyName mediaName = new PropertyName("media");
        FXOMPropertyC mediaProperty = new FXOMPropertyC(result, mediaName, mediaInstance);
        FXOMInstance mediaPlayerInstance = new FXOMInstance(result, MediaPlayer.class);
        mediaProperty.addToParentInstance(-1, mediaPlayerInstance);
        PropertyName mediaPlayerName = new PropertyName("mediaPlayer");
        FXOMPropertyC mediaPlayerProperty = new FXOMPropertyC(result, mediaPlayerName, mediaPlayerInstance);
        PropertyName fitWidthName = new PropertyName("fitWidth");
        FXOMPropertyT fitWidthProperty = new FXOMPropertyT(result, fitWidthName, String.valueOf(fitWidth));
        PropertyName fitHeightName = new PropertyName("fitHeight");
        FXOMPropertyT fitHeightProperty = new FXOMPropertyT(result, fitHeightName, String.valueOf(fitHeight));
        FXOMInstance mediaView = new FXOMInstance(result, MediaView.class);
        mediaPlayerProperty.addToParentInstance(-1, mediaView);
        fitWidthProperty.addToParentInstance(-1, mediaView);
        fitHeightProperty.addToParentInstance(-1, mediaView);
        result.setFxomRoot(mediaView);
        return result;
    }

    private static void serializeObjects(FXOMObject fxomObject, List<FXOMObject> result) {
        block6: {
            block5: {
                assert (fxomObject != null);
                assert (result != null);
                result.add(fxomObject);
                if (!(fxomObject instanceof FXOMInstance)) break block5;
                FXOMInstance fxomInstance = (FXOMInstance)fxomObject;
                for (FXOMProperty p : fxomInstance.getProperties().values()) {
                    if (!(p instanceof FXOMPropertyC)) continue;
                    FXOMPropertyC pc = (FXOMPropertyC)p;
                    for (FXOMObject v : pc.getValues()) {
                        FXOMNodes.serializeObjects(v, result);
                    }
                }
                break block6;
            }
            if (!(fxomObject instanceof FXOMCollection)) break block6;
            FXOMCollection fxomCollection = (FXOMCollection)fxomObject;
            for (FXOMObject i : fxomCollection.getItems()) {
                FXOMNodes.serializeObjects(i, result);
            }
        }
    }
}

