/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueElement;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FXOMPropertyC
extends FXOMProperty {
    private final List<FXOMObject> values = new ArrayList<FXOMObject>();
    private final GlueElement glueElement;

    public FXOMPropertyC(FXOMDocument document, PropertyName name, List<FXOMObject> values, GlueElement glueElement) {
        super(document, name);
        assert (values != null);
        assert (!values.isEmpty());
        assert (glueElement != null);
        assert (glueElement.getTagName().equals(this.getName().toString()));
        this.glueElement = glueElement;
        for (FXOMObject v : values) {
            this.values.add(v);
            v.setParentProperty(this);
        }
    }

    public FXOMPropertyC(FXOMDocument document, PropertyName name) {
        super(document, name);
        this.glueElement = new GlueElement(document.getGlue(), name.toString());
    }

    public FXOMPropertyC(FXOMDocument document, PropertyName name, FXOMObject value) {
        super(document, name);
        assert (value != null);
        this.glueElement = new GlueElement(document.getGlue(), name.toString());
        value.addToParentProperty(-1, this);
    }

    public FXOMPropertyC(FXOMDocument document, PropertyName name, List<FXOMObject> values) {
        super(document, name);
        assert (values != null);
        assert (!values.isEmpty());
        this.glueElement = new GlueElement(document.getGlue(), name.toString());
        for (FXOMObject value : values) {
            value.addToParentProperty(-1, this);
        }
    }

    public List<FXOMObject> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public GlueElement getGlueElement() {
        return this.glueElement;
    }

    @Override
    public void addToParentInstance(int index, FXOMInstance newParentInstance) {
        if (this.getParentInstance() != null) {
            this.removeFromParentInstance();
        }
        this.setParentInstance(newParentInstance);
        newParentInstance.addProperty(this);
        GlueElement newParentElement = newParentInstance.getGlueElement();
        this.glueElement.addToParent(index, newParentElement);
    }

    @Override
    public void removeFromParentInstance() {
        assert (this.getParentInstance() != null);
        FXOMInstance currentParentInstance = this.getParentInstance();
        assert (this.glueElement.getParent() == currentParentInstance.getGlueElement());
        this.glueElement.removeFromParent();
        this.setParentInstance(null);
        currentParentInstance.removeProperty(this);
    }

    @Override
    public int getIndexInParentInstance() {
        int result;
        if (this.getParentInstance() == null) {
            result = -1;
        } else {
            GlueElement parentElement = this.getParentInstance().getGlueElement();
            result = parentElement.getChildren().indexOf(this.glueElement);
            assert (result != -1);
        }
        return result;
    }

    @Override
    public void moveToFxomDocument(FXOMDocument destination) {
        assert (destination != null);
        assert (destination != this.getFxomDocument());
        this.documentLocationWillChange(destination.getLocation());
        if (this.getParentInstance() != null) {
            assert (this.getParentInstance().getFxomDocument() == this.getFxomDocument());
            this.removeFromParentInstance();
        }
        assert (this.getParentInstance() == null);
        assert (this.glueElement.getParent() == null);
        this.glueElement.moveToDocument(destination.getGlue());
        this.changeFxomDocument(destination);
    }

    @Override
    protected void changeFxomDocument(FXOMDocument destination) {
        assert (destination != null);
        assert (destination != this.getFxomDocument());
        assert (destination.getGlue() == this.glueElement.getDocument());
        super.changeFxomDocument(destination);
        for (FXOMObject v : this.values) {
            v.changeFxomDocument(destination);
        }
    }

    @Override
    public void documentLocationWillChange(URL newLocation) {
        for (FXOMObject v : this.values) {
            v.documentLocationWillChange(newLocation);
        }
    }

    void addValue(int index, FXOMObject value) {
        assert (value != null);
        assert (value.getParentProperty() == this);
        assert (!this.values.contains(value));
        if (index == -1) {
            this.values.add(value);
        } else {
            this.values.add(index, value);
        }
    }

    void removeValue(FXOMObject value) {
        assert (value != null);
        assert (value.getParentProperty() == null);
        assert (this.values.contains(value));
        this.values.remove(value);
    }
}

