/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javafx.scene.paint.Color;

public class ColorEncoder {
    private static Map<String, Color> standardColors;
    private static Map<Color, String> standardColorNames;

    public static String encodeColor(Color color) {
        String colorName = ColorEncoder.getStandardColorNames().get(color);
        String result = colorName != null ? colorName : ColorEncoder.makeColorEncoding(color);
        return result;
    }

    public static synchronized Map<String, Color> getStandardColors() {
        if (standardColors == null) {
            standardColors = new HashMap<String, Color>();
            standardColors.put("ALICEBLUE", Color.ALICEBLUE);
            standardColors.put("ANTIQUEWHITE", Color.ANTIQUEWHITE);
            standardColors.put("AQUA", Color.AQUA);
            standardColors.put("AQUAMARINE", Color.AQUAMARINE);
            standardColors.put("AZURE", Color.AZURE);
            standardColors.put("BEIGE", Color.BEIGE);
            standardColors.put("BISQUE", Color.BISQUE);
            standardColors.put("BLACK", Color.BLACK);
            standardColors.put("BLANCHEDALMOND", Color.BLANCHEDALMOND);
            standardColors.put("BLUE", Color.BLUE);
            standardColors.put("BLUEVIOLET", Color.BLUEVIOLET);
            standardColors.put("BROWN", Color.BROWN);
            standardColors.put("BURLYWOOD", Color.BURLYWOOD);
            standardColors.put("CADETBLUE", Color.CADETBLUE);
            standardColors.put("CHARTREUSE", Color.CHARTREUSE);
            standardColors.put("CHOCOLATE", Color.CHOCOLATE);
            standardColors.put("CORAL", Color.CORAL);
            standardColors.put("CORNFLOWERBLUE", Color.CORNFLOWERBLUE);
            standardColors.put("CORNSILK", Color.CORNSILK);
            standardColors.put("CRIMSON", Color.CRIMSON);
            standardColors.put("CYAN", Color.CYAN);
            standardColors.put("DARKBLUE", Color.DARKBLUE);
            standardColors.put("DARKCYAN", Color.DARKCYAN);
            standardColors.put("DARKGOLDENROD", Color.DARKGOLDENROD);
            standardColors.put("DARKGRAY", Color.DARKGRAY);
            standardColors.put("DARKGREEN", Color.DARKGREEN);
            standardColors.put("DARKGREY", Color.DARKGREY);
            standardColors.put("DARKKHAKI", Color.DARKKHAKI);
            standardColors.put("DARKMAGENTA", Color.DARKMAGENTA);
            standardColors.put("DARKOLIVEGREEN", Color.DARKOLIVEGREEN);
            standardColors.put("DARKORANGE", Color.DARKORANGE);
            standardColors.put("DARKORCHID", Color.DARKORCHID);
            standardColors.put("DARKRED", Color.DARKRED);
            standardColors.put("DARKSALMON", Color.DARKSALMON);
            standardColors.put("DARKSEAGREEN", Color.DARKSEAGREEN);
            standardColors.put("DARKSLATEBLUE", Color.DARKSLATEBLUE);
            standardColors.put("DARKSLATEGRAY", Color.DARKSLATEGRAY);
            standardColors.put("DARKSLATEGREY", Color.DARKSLATEGREY);
            standardColors.put("DARKTURQUOISE", Color.DARKTURQUOISE);
            standardColors.put("DARKVIOLET", Color.DARKVIOLET);
            standardColors.put("DEEPPINK", Color.DEEPPINK);
            standardColors.put("DEEPSKYBLUE", Color.DEEPSKYBLUE);
            standardColors.put("DIMGRAY", Color.DIMGRAY);
            standardColors.put("DIMGREY", Color.DIMGREY);
            standardColors.put("DODGERBLUE", Color.DODGERBLUE);
            standardColors.put("FIREBRICK", Color.FIREBRICK);
            standardColors.put("FLORALWHITE", Color.FLORALWHITE);
            standardColors.put("FORESTGREEN", Color.FORESTGREEN);
            standardColors.put("FUCHSIA", Color.FUCHSIA);
            standardColors.put("GAINSBORO", Color.GAINSBORO);
            standardColors.put("GHOSTWHITE", Color.GHOSTWHITE);
            standardColors.put("GOLD", Color.GOLD);
            standardColors.put("GOLDENROD", Color.GOLDENROD);
            standardColors.put("GRAY", Color.GRAY);
            standardColors.put("GREEN", Color.GREEN);
            standardColors.put("GREENYELLOW", Color.GREENYELLOW);
            standardColors.put("GREY", Color.GREY);
            standardColors.put("HONEYDEW", Color.HONEYDEW);
            standardColors.put("HOTPINK", Color.HOTPINK);
            standardColors.put("INDIANRED", Color.INDIANRED);
            standardColors.put("INDIGO", Color.INDIGO);
            standardColors.put("IVORY", Color.IVORY);
            standardColors.put("KHAKI", Color.KHAKI);
            standardColors.put("LAVENDER", Color.LAVENDER);
            standardColors.put("LAVENDERBLUSH", Color.LAVENDERBLUSH);
            standardColors.put("LAWNGREEN", Color.LAWNGREEN);
            standardColors.put("LEMONCHIFFON", Color.LEMONCHIFFON);
            standardColors.put("LIGHTBLUE", Color.LIGHTBLUE);
            standardColors.put("LIGHTCORAL", Color.LIGHTCORAL);
            standardColors.put("LIGHTCYAN", Color.LIGHTCYAN);
            standardColors.put("LIGHTGOLDENRODYELLOW", Color.LIGHTGOLDENRODYELLOW);
            standardColors.put("LIGHTGRAY", Color.LIGHTGRAY);
            standardColors.put("LIGHTGREEN", Color.LIGHTGREEN);
            standardColors.put("LIGHTGREY", Color.LIGHTGREY);
            standardColors.put("LIGHTPINK", Color.LIGHTPINK);
            standardColors.put("LIGHTSALMON", Color.LIGHTSALMON);
            standardColors.put("LIGHTSEAGREEN", Color.LIGHTSEAGREEN);
            standardColors.put("LIGHTSKYBLUE", Color.LIGHTSKYBLUE);
            standardColors.put("LIGHTSLATEGRAY", Color.LIGHTSLATEGRAY);
            standardColors.put("LIGHTSLATEGREY", Color.LIGHTSLATEGREY);
            standardColors.put("LIGHTSTEELBLUE", Color.LIGHTSTEELBLUE);
            standardColors.put("LIGHTYELLOW", Color.LIGHTYELLOW);
            standardColors.put("LIME", Color.LIME);
            standardColors.put("LIMEGREEN", Color.LIMEGREEN);
            standardColors.put("LINEN", Color.LINEN);
            standardColors.put("MAGENTA", Color.MAGENTA);
            standardColors.put("MAROON", Color.MAROON);
            standardColors.put("MEDIUMAQUAMARINE", Color.MEDIUMAQUAMARINE);
            standardColors.put("MEDIUMBLUE", Color.MEDIUMBLUE);
            standardColors.put("MEDIUMORCHID", Color.MEDIUMORCHID);
            standardColors.put("MEDIUMPURPLE", Color.MEDIUMPURPLE);
            standardColors.put("MEDIUMSEAGREEN", Color.MEDIUMSEAGREEN);
            standardColors.put("MEDIUMSLATEBLUE", Color.MEDIUMSLATEBLUE);
            standardColors.put("MEDIUMSPRINGGREEN", Color.MEDIUMSPRINGGREEN);
            standardColors.put("MEDIUMTURQUOISE", Color.MEDIUMTURQUOISE);
            standardColors.put("MEDIUMVIOLETRED", Color.MEDIUMVIOLETRED);
            standardColors.put("MIDNIGHTBLUE", Color.MIDNIGHTBLUE);
            standardColors.put("MINTCREAM", Color.MINTCREAM);
            standardColors.put("MISTYROSE", Color.MISTYROSE);
            standardColors.put("MOCCASIN", Color.MOCCASIN);
            standardColors.put("NAVAJOWHITE", Color.NAVAJOWHITE);
            standardColors.put("NAVY", Color.NAVY);
            standardColors.put("OLDLACE", Color.OLDLACE);
            standardColors.put("OLIVE", Color.OLIVE);
            standardColors.put("OLIVEDRAB", Color.OLIVEDRAB);
            standardColors.put("ORANGE", Color.ORANGE);
            standardColors.put("ORANGERED", Color.ORANGERED);
            standardColors.put("ORCHID", Color.ORCHID);
            standardColors.put("PALEGOLDENROD", Color.PALEGOLDENROD);
            standardColors.put("PALEGREEN", Color.PALEGREEN);
            standardColors.put("PALETURQUOISE", Color.PALETURQUOISE);
            standardColors.put("PALEVIOLETRED", Color.PALEVIOLETRED);
            standardColors.put("PAPAYAWHIP", Color.PAPAYAWHIP);
            standardColors.put("PEACHPUFF", Color.PEACHPUFF);
            standardColors.put("PERU", Color.PERU);
            standardColors.put("PINK", Color.PINK);
            standardColors.put("PLUM", Color.PLUM);
            standardColors.put("POWDERBLUE", Color.POWDERBLUE);
            standardColors.put("PURPLE", Color.PURPLE);
            standardColors.put("RED", Color.RED);
            standardColors.put("ROSYBROWN", Color.ROSYBROWN);
            standardColors.put("ROYALBLUE", Color.ROYALBLUE);
            standardColors.put("SADDLEBROWN", Color.SADDLEBROWN);
            standardColors.put("SALMON", Color.SALMON);
            standardColors.put("SANDYBROWN", Color.SANDYBROWN);
            standardColors.put("SEAGREEN", Color.SEAGREEN);
            standardColors.put("SEASHELL", Color.SEASHELL);
            standardColors.put("SIENNA", Color.SIENNA);
            standardColors.put("SILVER", Color.SILVER);
            standardColors.put("SKYBLUE", Color.SKYBLUE);
            standardColors.put("SLATEBLUE", Color.SLATEBLUE);
            standardColors.put("SLATEGRAY", Color.SLATEGRAY);
            standardColors.put("SLATEGREY", Color.SLATEGREY);
            standardColors.put("SNOW", Color.SNOW);
            standardColors.put("SPRINGGREEN", Color.SPRINGGREEN);
            standardColors.put("STEELBLUE", Color.STEELBLUE);
            standardColors.put("TAN", Color.TAN);
            standardColors.put("TEAL", Color.TEAL);
            standardColors.put("THISTLE", Color.THISTLE);
            standardColors.put("TOMATO", Color.TOMATO);
            standardColors.put("TRANSPARENT", Color.TRANSPARENT);
            standardColors.put("TURQUOISE", Color.TURQUOISE);
            standardColors.put("VIOLET", Color.VIOLET);
            standardColors.put("WHEAT", Color.WHEAT);
            standardColors.put("WHITE", Color.WHITE);
            standardColors.put("WHITESMOKE", Color.WHITESMOKE);
            standardColors.put("YELLOW", Color.YELLOW);
            standardColors.put("YELLOWGREEN", Color.YELLOWGREEN);
            standardColors = Collections.unmodifiableMap(standardColors);
        }
        return standardColors;
    }

    public static synchronized Map<Color, String> getStandardColorNames() {
        if (standardColorNames == null) {
            standardColorNames = new HashMap<Color, String>();
            for (Map.Entry<String, Color> e : ColorEncoder.getStandardColors().entrySet()) {
                standardColorNames.put(e.getValue(), e.getKey());
            }
            standardColorNames = Collections.unmodifiableMap(standardColorNames);
        }
        return standardColorNames;
    }

    public static String encodeColorToRGBA(Color color) {
        String result;
        if (color == null) {
            result = "null";
        } else {
            int red = (int)(color.getRed() * 255.0);
            int green = (int)(color.getGreen() * 255.0);
            int blue = (int)(color.getBlue() * 255.0);
            result = "rgba(" + red + "," + green + "," + blue + "," + color.getOpacity() + ")";
        }
        return result;
    }

    private static String makeColorEncoding(Color c) {
        int red = (int)Math.round(c.getRed() * 255.0);
        int green = (int)Math.round(c.getGreen() * 255.0);
        int blue = (int)Math.round(c.getBlue() * 255.0);
        int alpha = (int)Math.round(c.getOpacity() * 255.0);
        String result = alpha == 255 ? String.format((Locale)null, "#%02x%02x%02x", red, green, blue) : String.format((Locale)null, "#%02x%02x%02x%02x", red, green, blue, alpha);
        return result;
    }
}

