/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryCreator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.repo.HgRepositoryImpl;
import org.zmlx.hg4idea.util.HgUtil;

public class HgRepositoryCreator
extends VcsRepositoryCreator {
    @NotNull
    private final Project myProject;

    public HgRepositoryCreator(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/repo/HgRepositoryCreator", "<init>"));
        }
        this.myProject = project;
    }

    public Repository createRepositoryIfValid(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/repo/HgRepositoryCreator", "createRepositoryIfValid"));
        }
        return HgUtil.isHgRoot(root) ? HgRepositoryImpl.getInstance(root, this.myProject, (Disposable)this.myProject) : null;
    }

    @NotNull
    public VcsKey getVcsKey() {
        VcsKey vcsKey = HgVcs.getKey();
        if (vcsKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryCreator", "getVcsKey"));
        }
        return vcsKey;
    }
}

