/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.radComponents.RadAbstractGridLayoutManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import java.awt.LayoutManager;
import org.jetbrains.annotations.NotNull;

public final class GridChangeUtil {
    private GridChangeUtil() {
    }

    public static void splitColumn(RadContainer grid, int columnIndex) {
        GridChangeUtil.splitCell(grid, columnIndex, false);
    }

    public static void splitRow(RadContainer grid, int rowIndex) {
        GridChangeUtil.splitCell(grid, rowIndex, true);
    }

    public static boolean isColumnEmpty(RadContainer grid, int columnIndex) {
        return GridChangeUtil.canDeleteCell(grid, columnIndex, false) == CellStatus.Empty;
    }

    public static boolean isRowEmpty(RadContainer grid, int rowIndex) {
        return GridChangeUtil.canDeleteCell(grid, rowIndex, true) == CellStatus.Empty;
    }

    public static void insertRowOrColumn(RadContainer grid, int cellIndex, boolean isRow, boolean isBefore) {
        GridChangeUtil.check(grid, isRow, cellIndex);
        RadAbstractGridLayoutManager oldLayout = grid.getGridLayoutManager();
        int beforeIndex = cellIndex;
        if (!isBefore) {
            ++beforeIndex;
        }
        LayoutManager newLayout = oldLayout.copyLayout(grid.getLayout(), isRow ? 1 : 0, isRow ? 0 : 1);
        GridConstraints[] oldConstraints = GridChangeUtil.copyConstraints(grid);
        for (int i = grid.getComponentCount() - 1; i >= 0; --i) {
            GridConstraints constraints = grid.getComponent(i).getConstraints();
            GridChangeUtil.adjustConstraintsOnInsert(constraints, isRow, beforeIndex, 1);
        }
        grid.setLayout(newLayout);
        GridChangeUtil.fireAllConstraintsChanged(grid, oldConstraints);
    }

    private static GridConstraints[] copyConstraints(RadContainer grid) {
        GridConstraints[] gridConstraints = new GridConstraints[grid.getComponentCount()];
        for (int i = 0; i < grid.getComponentCount(); ++i) {
            gridConstraints[i] = (GridConstraints)grid.getComponent(i).getConstraints().clone();
        }
        return gridConstraints;
    }

    private static void fireAllConstraintsChanged(RadContainer grid, GridConstraints[] oldConstraints) {
        for (int i = grid.getComponentCount() - 1; i >= 0; --i) {
            grid.getComponent(i).fireConstraintsChanged(oldConstraints[i]);
        }
    }

    public static void adjustConstraintsOnInsert(GridConstraints constraints, boolean isRow, int beforeIndex, int count) {
        if (constraints.getCell(isRow) >= beforeIndex) {
            GridChangeUtil.addToCell(constraints, isRow, count);
        } else if (GridChangeUtil.isCellInsideComponent(constraints, isRow, beforeIndex)) {
            GridChangeUtil.addToSpan(constraints, isRow, count);
        }
    }

    public static void splitCell(RadContainer grid, int cellIndex, boolean isRow) {
        GridChangeUtil.check(grid, isRow, cellIndex);
        int insertedCells = grid.getGridLayoutManager().insertGridCells(grid, cellIndex, isRow, false, false);
        for (int i = grid.getComponentCount() - 1; i >= 0; --i) {
            RadComponent component = grid.getComponent(i);
            GridConstraints constraints = component.getConstraints();
            if (constraints.getCell(isRow) + constraints.getSpan(isRow) - 1 != cellIndex) continue;
            GridConstraints oldConstraints = (GridConstraints)constraints.clone();
            constraints.setSpan(isRow, constraints.getSpan(isRow) + insertedCells);
            component.fireConstraintsChanged(oldConstraints);
        }
    }

    public static CellStatus canDeleteCell(@NotNull RadContainer grid, int cellIndex, boolean isRow) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/uiDesigner/GridChangeUtil", "canDeleteCell"));
        }
        GridChangeUtil.check(grid, isRow, cellIndex);
        if (isRow && grid.getGridRowCount() <= grid.getGridLayoutManager().getMinCellCount()) {
            return CellStatus.Required;
        }
        if (!isRow && grid.getGridColumnCount() <= grid.getGridLayoutManager().getMinCellCount()) {
            return CellStatus.Required;
        }
        boolean haveComponents = false;
        boolean haveOrigins = false;
        boolean haveSingleSpan = false;
        for (int i = 0; i < grid.getComponentCount(); ++i) {
            GridConstraints constraints = grid.getComponent(i).getConstraints();
            int cell = constraints.getCell(isRow);
            int span = constraints.getSpan(isRow);
            if (cellIndex < cell || cellIndex >= cell + span) continue;
            haveComponents = true;
            if (cellIndex != cell) continue;
            haveOrigins = true;
            if (span != 1) continue;
            haveSingleSpan = true;
        }
        if (haveSingleSpan) {
            return CellStatus.Required;
        }
        if (haveOrigins) {
            return CellStatus.CanShift;
        }
        if (haveComponents) {
            return CellStatus.Redundant;
        }
        return CellStatus.Empty;
    }

    public static boolean canDeleteCells(RadContainer grid, int[] cells, boolean row) {
        for (int cell : cells) {
            CellStatus status = GridChangeUtil.canDeleteCell(grid, cell, row);
            if (status == CellStatus.Empty) continue;
            return cells.length == 1 && status == CellStatus.Redundant;
        }
        return true;
    }

    public static void deleteCell(RadContainer grid, int cellIndex, boolean isRow) {
        GridChangeUtil.check(grid, isRow, cellIndex);
        if (GridChangeUtil.canDeleteCell(grid, cellIndex, isRow) == CellStatus.Required) {
            throw new IllegalArgumentException("cell cannot be deleted");
        }
        RadAbstractGridLayoutManager oldLayout = grid.getGridLayoutManager();
        LayoutManager newLayout = oldLayout.copyLayout(grid.getLayout(), isRow ? -1 : 0, isRow ? 0 : -1);
        GridConstraints[] oldConstraints = GridChangeUtil.copyConstraints(grid);
        for (int i = grid.getComponentCount() - 1; i >= 0; --i) {
            GridConstraints constraints = grid.getComponent(i).getConstraints();
            if (constraints.getCell(isRow) > cellIndex) {
                GridChangeUtil.addToCell(constraints, isRow, -1);
                continue;
            }
            if (!GridChangeUtil.isCellInsideComponent(constraints, isRow, cellIndex)) continue;
            GridChangeUtil.addToSpan(constraints, isRow, -1);
        }
        grid.setLayout(newLayout);
        GridChangeUtil.fireAllConstraintsChanged(grid, oldConstraints);
    }

    private static boolean isCellInsideComponent(GridConstraints constraints, boolean isRow, int cellIndex) {
        int cell = constraints.getCell(isRow);
        int span = constraints.getSpan(isRow);
        return cell <= cellIndex && cellIndex <= cell + span - 1;
    }

    private static void check(@NotNull RadContainer grid, boolean isRow, int cellIndex) {
        int cellCount;
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/uiDesigner/GridChangeUtil", "check"));
        }
        if (!grid.getLayoutManager().isGrid()) {
            throw new IllegalArgumentException("container must be grid");
        }
        int n = cellCount = isRow ? grid.getGridRowCount() : grid.getGridColumnCount();
        if (cellIndex == 0 && cellCount == 0) {
            return;
        }
        if (cellIndex < 0 || cellIndex >= cellCount) {
            throw new IllegalArgumentException("invalid index: " + cellIndex);
        }
    }

    private static void addToCell(GridConstraints constraints, boolean isRow, int delta) {
        if (isRow) {
            constraints.setRow(constraints.getRow() + delta);
        } else {
            constraints.setColumn(constraints.getColumn() + delta);
        }
    }

    private static void addToSpan(GridConstraints constraints, boolean isRow, int delta) {
        if (isRow) {
            constraints.setRowSpan(constraints.getRowSpan() + delta);
        } else {
            constraints.setColSpan(constraints.getColSpan() + delta);
        }
    }

    public static void moveCells(RadContainer container, boolean isRow, int[] cellsToMove, int targetCell) {
        for (int i = 0; i < cellsToMove.length; ++i) {
            int sourceCell = cellsToMove[i];
            GridChangeUtil.moveCell(container, isRow, sourceCell, targetCell);
            if (sourceCell < targetCell) {
                int j = i + 1;
                while (j < cellsToMove.length) {
                    int n = j++;
                    cellsToMove[n] = cellsToMove[n] - 1;
                }
                continue;
            }
            ++targetCell;
        }
    }

    public static void moveCell(RadContainer container, boolean isRow, int sourceCell, int targetCell) {
        if (targetCell == sourceCell || targetCell == sourceCell + 1) {
            return;
        }
        int delta = sourceCell > targetCell ? 1 : -1;
        int startCell = Math.min(sourceCell, targetCell);
        int endCell = Math.max(sourceCell, targetCell);
        if (sourceCell < targetCell) {
            --targetCell;
        }
        for (RadComponent c : container.getComponents()) {
            GridConstraints constraints = c.getConstraints();
            GridConstraints oldConstraints = (GridConstraints)constraints.clone();
            int aCell = constraints.getCell(isRow);
            if (aCell == sourceCell) {
                constraints.setCell(isRow, targetCell);
            } else if (aCell >= startCell && aCell < endCell) {
                constraints.setCell(isRow, aCell + delta);
            }
            c.fireConstraintsChanged(oldConstraints);
        }
    }

    public static enum CellStatus {
        Empty,
        Redundant,
        CanShift,
        Required;

    }
}

