/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.SelectionState;
import com.intellij.uiDesigner.componentTree.ComponentPtr;
import com.intellij.uiDesigner.componentTree.ComponentTreeBuilder;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.propertyInspector.DesignerToolWindowManager;
import java.util.Stack;

public final class ShrinkSelectionAction
extends AnAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent e) {
        GuiEditor editor = FormEditingUtil.getEditorFromContext(e.getDataContext());
        assert (editor != null);
        SelectionState selectionState = editor.getSelectionState();
        selectionState.setInsideChange(true);
        ComponentTreeBuilder builder = DesignerToolWindowManager.getInstance(editor).getComponentTreeBuilder();
        builder.beginUpdateSelection();
        try {
            Stack<ComponentPtr[]> history = selectionState.getSelectionHistory();
            history.pop();
            SelectionState.restoreSelection(editor, history.peek());
        }
        finally {
            builder.endUpdateSelection();
            selectionState.setInsideChange(false);
        }
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        GuiEditor editor = FormEditingUtil.getEditorFromContext(e.getDataContext());
        if (editor == null) {
            presentation.setEnabled(false);
            return;
        }
        Stack<ComponentPtr[]> history = editor.getSelectionState().getSelectionHistory();
        presentation.setEnabled(history.size() > 1);
    }
}

